/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.Pipes.Pipe;

import io.github.apfelcreme.Pipes.Event.PipeMoveItemEvent;
import io.github.apfelcreme.Pipes.LoopDetection.Detection;
import io.github.apfelcreme.Pipes.Manager.DetectionManager;
import io.github.apfelcreme.Pipes.Manager.PipeManager;
import io.github.apfelcreme.Pipes.Pipe.Pipe;
import io.github.apfelcreme.Pipes.Pipe.PipeInput;
import io.github.apfelcreme.Pipes.Pipe.PipeOutput;
import io.github.apfelcreme.Pipes.Pipe.SimpleLocation;
import io.github.apfelcreme.Pipes.Pipes;
import io.github.apfelcreme.Pipes.PipesUtil;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.event.Event;
import org.bukkit.inventory.BrewerInventory;
import org.bukkit.inventory.FurnaceInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class ScheduledItemTransfer {
    private SimpleLocation inputLocation;

    public ScheduledItemTransfer(SimpleLocation inputLocation) {
        this.inputLocation = inputLocation;
    }

    public boolean execute() {
        Location location = this.inputLocation.getLocation();
        if (!location.getWorld().isChunkLoaded(location.getBlockX() >> 4, location.getBlockZ() >> 4)) {
            return false;
        }
        Pipe pipe = PipeManager.getInstance().getPipe(this.inputLocation);
        if (pipe == null) {
            return true;
        }
        PipeInput input = pipe.getInput(this.inputLocation);
        InventoryHolder inputHolder = input.getHolder();
        if (inputHolder == null) {
            return true;
        }
        LinkedList<ItemStack> itemQueue = new LinkedList<ItemStack>();
        for (ItemStack itemStack : inputHolder.getInventory()) {
            if (itemStack == null) continue;
            itemQueue.add(itemStack);
        }
        for (Detection detection : DetectionManager.getInstance().getDetections().values()) {
            detection.addLocation(new SimpleLocation(input.getLocation()));
        }
        boolean transferredAll = true;
        for (ItemStack item : itemQueue) {
            List<PipeOutput> outputs = pipe.getOutputs(item);
            this.processItemTransfer(pipe, inputHolder, item, outputs);
            if (item.getAmount() == 0) continue;
            transferredAll = false;
        }
        return transferredAll;
    }

    private void processItemTransfer(Pipe pipe, InventoryHolder inputHolder, ItemStack itemStack, List<PipeOutput> outputs) {
        block15: for (PipeOutput output : outputs) {
            InventoryHolder targetHolder = output.getTargetHolder();
            if (targetHolder == null || !output.getFilterItems().isEmpty() && !PipesUtil.containsSimilar(output.getFilterItems(), itemStack)) continue;
            int originalAmount = itemStack.getAmount();
            block0 : switch (targetHolder.getInventory().getType()) {
                case FURNACE: {
                    switch (itemStack.getType()) {
                        case COAL: 
                        case COAL_BLOCK: 
                        case LAVA_BUCKET: {
                            this.addFuel(inputHolder, targetHolder.getInventory(), itemStack);
                            break block0;
                        }
                    }
                    FurnaceInventory furnaceInventory = (FurnaceInventory)targetHolder.getInventory();
                    ItemStack smelting = furnaceInventory.getSmelting();
                    if (smelting == null) {
                        inputHolder.getInventory().remove(itemStack);
                        furnaceInventory.setSmelting(itemStack);
                        break;
                    }
                    if (!smelting.isSimilar(itemStack) || smelting.getMaxStackSize() != -1 && smelting.getAmount() >= smelting.getMaxStackSize()) break;
                    int resultSize = itemStack.getAmount() - (smelting.getMaxStackSize() - smelting.getAmount());
                    ItemStack result = itemStack.clone();
                    if (resultSize <= 0) {
                        inputHolder.getInventory().remove(itemStack);
                        result.setAmount(smelting.getAmount() + itemStack.getAmount());
                        furnaceInventory.setSmelting(result);
                        itemStack.setAmount(0);
                        break;
                    }
                    inputHolder.getInventory().remove(itemStack);
                    itemStack.setAmount(resultSize);
                    inputHolder.getInventory().addItem(new ItemStack[]{itemStack});
                    result.setAmount(itemStack.getMaxStackSize());
                    furnaceInventory.setSmelting(result);
                    itemStack.setAmount(itemStack.getMaxStackSize() - resultSize);
                    break;
                }
                case BREWING: {
                    BrewerInventory brewerInventory = (BrewerInventory)targetHolder.getInventory();
                    switch (itemStack.getType()) {
                        case BLAZE_POWDER: {
                            if (this.addFuel(inputHolder, (Inventory)brewerInventory, itemStack)) break block0;
                            continue block15;
                        }
                        case POTION: 
                        case SPLASH_POTION: 
                        case LINGERING_POTION: {
                            int firstEmpty = brewerInventory.firstEmpty();
                            while (firstEmpty != -1 && firstEmpty < 3 && itemStack.getAmount() > 0) {
                                inputHolder.getInventory().remove(itemStack);
                                ItemStack result = new ItemStack(itemStack);
                                if (itemStack.getAmount() > 1) {
                                    int newAmount = itemStack.getAmount() - 1;
                                    itemStack.setAmount(newAmount);
                                    result.setAmount(1);
                                    inputHolder.getInventory().addItem(new ItemStack[]{itemStack});
                                    itemStack.setAmount(newAmount);
                                }
                                brewerInventory.setItem(firstEmpty, result);
                                firstEmpty = brewerInventory.firstEmpty();
                            }
                            break block0;
                        }
                        default: {
                            ItemStack ingredient = brewerInventory.getIngredient();
                            if (ingredient == null) {
                                inputHolder.getInventory().remove(itemStack);
                                brewerInventory.setIngredient(itemStack);
                                itemStack.setAmount(0);
                                break;
                            }
                            if (!ingredient.isSimilar(itemStack) || ingredient.getMaxStackSize() != -1 && ingredient.getAmount() >= ingredient.getMaxStackSize()) break block0;
                            int rest = itemStack.getMaxStackSize() - ingredient.getAmount();
                            inputHolder.getInventory().remove(itemStack);
                            ingredient.setAmount(ingredient.getMaxStackSize());
                            brewerInventory.setIngredient(ingredient);
                            itemStack.setAmount(rest);
                            inputHolder.getInventory().addItem(new ItemStack[]{itemStack});
                            break;
                        }
                    }
                    break;
                }
                case BEACON: {
                    switch (itemStack.getType()) {
                        case DIAMOND: 
                        case EMERALD: 
                        case GOLD_INGOT: 
                        case IRON_INGOT: {
                            this.addItem(inputHolder.getInventory(), targetHolder.getInventory(), itemStack);
                        }
                    }
                    break;
                }
                default: {
                    this.addItem(inputHolder.getInventory(), targetHolder.getInventory(), itemStack);
                }
            }
            if (itemStack.getAmount() == originalAmount) continue;
            PipeMoveItemEvent event = new PipeMoveItemEvent(pipe, inputHolder.getInventory(), itemStack, targetHolder.getInventory(), true);
            Pipes.getInstance().getServer().getPluginManager().callEvent((Event)event);
            if (itemStack.getAmount() > 0) continue;
            return;
        }
    }

    private void addItem(Inventory source, Inventory target, ItemStack itemStack) {
        source.remove(itemStack);
        if (target.firstEmpty() != -1) {
            target.addItem(new ItemStack[]{itemStack});
            itemStack.setAmount(0);
        } else {
            ItemStack[] stacks = new ItemStack[itemStack.getAmount()];
            for (int i = 0; i < itemStack.getAmount(); ++i) {
                ItemStack clone = new ItemStack(itemStack);
                clone.setAmount(1);
                stacks[i] = clone;
            }
            HashMap rest = target.addItem(stacks);
            int newAmount = 0;
            for (ItemStack item : rest.values()) {
                newAmount += item.getAmount();
            }
            itemStack.setAmount(newAmount);
            if (itemStack.getAmount() > 0) {
                source.addItem(new ItemStack[]{itemStack});
                itemStack.setAmount(newAmount);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean addFuel(InventoryHolder inputHolder, Inventory inventory, ItemStack itemStack) {
        ItemStack fuel = this.getFuel(inventory);
        if (fuel != null && fuel.isSimilar(itemStack)) {
            if (fuel.getMaxStackSize() != -1 && fuel.getAmount() >= fuel.getMaxStackSize()) return false;
            int resultSize = itemStack.getAmount() - (fuel.getMaxStackSize() - fuel.getAmount());
            ItemStack result = itemStack.clone();
            if (resultSize <= 0) {
                inputHolder.getInventory().remove(itemStack);
                result.setAmount(fuel.getAmount() + itemStack.getAmount());
                this.setFuel(inventory, result);
                itemStack.setAmount(0);
                return true;
            } else {
                inputHolder.getInventory().remove(itemStack);
                itemStack.setAmount(resultSize);
                inputHolder.getInventory().addItem(new ItemStack[]{itemStack});
                result.setAmount(itemStack.getMaxStackSize());
                this.setFuel(inventory, result);
                itemStack.setAmount(itemStack.getMaxStackSize() - resultSize);
            }
            return true;
        } else {
            if (fuel != null) return true;
            inputHolder.getInventory().remove(itemStack);
            this.setFuel(inventory, itemStack);
        }
        return true;
    }

    private ItemStack getFuel(Inventory inventory) {
        switch (inventory.getType()) {
            case BREWING: {
                return ((BrewerInventory)inventory).getFuel();
            }
            case FURNACE: {
                return ((FurnaceInventory)inventory).getFuel();
            }
        }
        throw new IllegalArgumentException("Inventories of the type " + inventory.getType() + " do not have fuel!");
    }

    private void setFuel(Inventory inventory, ItemStack itemStack) {
        switch (inventory.getType()) {
            case BREWING: {
                ((BrewerInventory)inventory).setFuel(itemStack);
                break;
            }
            case FURNACE: {
                ((FurnaceInventory)inventory).setFuel(itemStack);
                break;
            }
            default: {
                throw new IllegalArgumentException("Inventories of the type " + inventory.getType() + " do not have fuel!");
            }
        }
    }

    public SimpleLocation getInputLocation() {
        return this.inputLocation;
    }
}

