/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.Pipes.Pipe;

import java.util.LinkedHashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;

public class SimpleLocation {
    private final String worldName;
    private final int x;
    private final int y;
    private final int z;

    public SimpleLocation(String worldName, int x, int y, int z) {
        this.worldName = worldName;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public SimpleLocation(Location location) {
        this.worldName = location.getWorld().getName();
        this.x = location.getBlockX();
        this.y = location.getBlockY();
        this.z = location.getBlockZ();
    }

    public SimpleLocation(SimpleLocation location) {
        this.worldName = location.getWorldName();
        this.x = location.getX();
        this.y = location.getY();
        this.z = location.getZ();
    }

    public String getWorldName() {
        return this.worldName;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public SimpleLocation getRelative(BlockFace face) {
        switch (face) {
            case NORTH: {
                return new SimpleLocation(this.worldName, this.x, this.y, this.z - 1);
            }
            case EAST: {
                return new SimpleLocation(this.worldName, this.x + 1, this.y, this.z);
            }
            case SOUTH: {
                return new SimpleLocation(this.worldName, this.x, this.y, this.z + 1);
            }
            case WEST: {
                return new SimpleLocation(this.worldName, this.x - 1, this.y, this.z);
            }
            case UP: {
                return new SimpleLocation(this.worldName, this.x, this.y + 1, this.z);
            }
            case DOWN: {
                return new SimpleLocation(this.worldName, this.x, this.y - 1, this.z);
            }
        }
        return null;
    }

    public Location getLocation() {
        return new Location(Bukkit.getServer().getWorld(this.worldName), (double)this.x, (double)this.y, (double)this.z);
    }

    public Block getBlock() {
        World world = Bukkit.getServer().getWorld(this.worldName);
        if (world != null) {
            return world.getBlockAt(this.x, this.y, this.z);
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleLocation that = (SimpleLocation)o;
        if (this.x != that.x) {
            return false;
        }
        if (this.y != that.y) {
            return false;
        }
        if (this.z != that.z) {
            return false;
        }
        return this.worldName.equals(that.worldName);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return "SimpleLocation{worldName='" + this.worldName + '\'' + ", x=" + this.x + ", y=" + this.y + ", z=" + this.z + '}';
    }

    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("world", this.getWorldName());
        result.put("x", this.getX());
        result.put("y", this.getY());
        result.put("z", this.getZ());
        return result;
    }

    public static SimpleLocation deserialize(Map<String, Object> args) throws IllegalArgumentException {
        String world = "";
        int x = 0;
        int y = 0;
        int z = 0;
        if (!args.containsKey("world")) {
            throw new IllegalArgumentException("Missing value for world!");
        }
        world = (String)args.get("world");
        if (!args.containsKey("x")) {
            throw new IllegalArgumentException("Missing value for x!");
        }
        x = (Integer)args.get("x");
        if (!args.containsKey("y")) {
            throw new IllegalArgumentException("Missing value for y!");
        }
        y = (Integer)args.get("y");
        if (!args.containsKey("z")) {
            throw new IllegalArgumentException("Missing value for z!");
        }
        z = (Integer)args.get("z");
        return new SimpleLocation(world, x, y, z);
    }
}

