/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.Pipes;

import io.github.apfelcreme.Pipes.Command.DetectCommand;
import io.github.apfelcreme.Pipes.Command.InfoCommand;
import io.github.apfelcreme.Pipes.Command.MonitorCommand;
import io.github.apfelcreme.Pipes.Command.ReloadCommand;
import io.github.apfelcreme.Pipes.Command.SubCommand;
import io.github.apfelcreme.Pipes.Command.TpCommand;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class PipeCommand
implements CommandExecutor {
    public boolean onCommand(CommandSender commandSender, Command command, String s, String[] strings) {
        SubCommand subCommand = null;
        if (strings.length > 0) {
            Operation operation = Operation.getOperation(strings[0]);
            if (operation != null) {
                switch (operation) {
                    case CHECK: 
                    case INFO: {
                        subCommand = new InfoCommand();
                        break;
                    }
                    case DETECT: {
                        subCommand = new DetectCommand();
                        break;
                    }
                    case MONITOR: {
                        subCommand = new MonitorCommand();
                        break;
                    }
                    case RELOAD: {
                        subCommand = new ReloadCommand();
                        break;
                    }
                    case TP: {
                        subCommand = new TpCommand();
                    }
                }
            }
            if (subCommand != null) {
                subCommand.execute(commandSender, strings);
                return true;
            }
        }
        return false;
    }

    public static enum Operation {
        CHECK,
        DETECT,
        INFO,
        MONITOR,
        RELOAD,
        TP;


        public static Operation getOperation(String operationString) {
            for (Operation operation : Operation.values()) {
                if (!operation.name().equalsIgnoreCase(operationString)) continue;
                return operation;
            }
            return null;
        }
    }
}

