/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.Pipes;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.github.apfelcreme.Pipes.Listener.BlockListener;
import io.github.apfelcreme.Pipes.Listener.InventoryChangeListener;
import io.github.apfelcreme.Pipes.Listener.PlayerRightclickListener;
import io.github.apfelcreme.Pipes.Manager.ItemMoveScheduler;
import io.github.apfelcreme.Pipes.PipeCommand;
import io.github.apfelcreme.Pipes.PipesConfig;
import io.github.apfelcreme.Pipes.PipesItem;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.Material;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Pipes
extends JavaPlugin {
    private Cache<UUID, String> registeredRightClicks;
    private static Pipes instance = null;

    public void onEnable() {
        instance = this;
        this.registeredRightClicks = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.SECONDS).build();
        PipesConfig.load();
        ItemMoveScheduler.load();
        this.getServer().getPluginManager().registerEvents((Listener)new InventoryChangeListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerRightclickListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new BlockListener(this), (Plugin)this);
        this.getServer().getPluginCommand("pipe").setExecutor((CommandExecutor)new PipeCommand());
        ShapelessRecipe dispenserRecipe = new ShapelessRecipe(PipesItem.PIPE_INPUT.toItemStack());
        for (Map.Entry<Material, Integer> entry : PipesConfig.getRecipeMaterials("dispenserRecipe").entrySet()) {
            dispenserRecipe.addIngredient(entry.getValue().intValue(), entry.getKey());
        }
        this.getServer().addRecipe((Recipe)dispenserRecipe);
        ShapelessRecipe dropperRecipe = new ShapelessRecipe(PipesItem.PIPE_OUTPUT.toItemStack());
        for (Map.Entry<Material, Integer> entry : PipesConfig.getRecipeMaterials("dropperRecipe").entrySet()) {
            dropperRecipe.addIngredient(entry.getValue().intValue(), entry.getKey());
        }
        this.getServer().addRecipe((Recipe)dropperRecipe);
        ShapelessRecipe shapelessRecipe = new ShapelessRecipe(PipesItem.CHUNK_LOADER.toItemStack());
        for (Map.Entry<Material, Integer> material : PipesConfig.getRecipeMaterials("chunkLoaderRecipe").entrySet()) {
            shapelessRecipe.addIngredient(material.getValue().intValue(), material.getKey());
        }
        this.getServer().addRecipe((Recipe)shapelessRecipe);
    }

    public void onDisable() {
        ItemMoveScheduler.exit();
    }

    public void registerRightClick(Player player, String action) {
        this.registeredRightClicks.put((Object)player.getUniqueId(), (Object)action);
    }

    public String getRegisterRightClick(Player player) {
        return (String)this.registeredRightClicks.getIfPresent((Object)player.getUniqueId());
    }

    public void unregisterRightClick(Player player) {
        this.registeredRightClicks.invalidate((Object)player.getUniqueId());
    }

    public static void sendMessage(CommandSender player, String message) {
        player.sendMessage(PipesConfig.getText("prefix") + message);
    }

    public static Pipes getInstance() {
        return instance;
    }
}

