/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.Pipes;

import io.github.apfelcreme.Pipes.Pipes;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class PipesConfig {
    private static YamlConfiguration languageConfig;
    private static Pipes plugin;
    private static long transferCooldown;

    public static void load() {
        plugin = Pipes.getInstance();
        if (!plugin.getDataFolder().exists()) {
            plugin.getDataFolder().mkdirs();
        }
        plugin.saveDefaultConfig();
        plugin.saveResource("lang.de.yml", false);
        plugin.reloadConfig();
        transferCooldown = plugin.getConfig().getLong("transferCooldown", 20L);
        languageConfig = YamlConfiguration.loadConfiguration((File)new File(plugin.getDataFolder(), "lang.de.yml"));
    }

    public static long getPipeCacheDuration() {
        return plugin.getConfig().getLong("pipeCacheDuration", 10000L);
    }

    public static long getTransferCooldown() {
        return transferCooldown;
    }

    public static Map<Material, Integer> getRecipeMaterials(String path) {
        HashMap<Material, Integer> ret = new HashMap<Material, Integer>();
        ConfigurationSection section = plugin.getConfig().getConfigurationSection(path);
        if (section != null) {
            for (String key : section.getKeys(false)) {
                ret.put(Material.getMaterial((String)key), section.getInt(key));
            }
        }
        return ret;
    }

    public static String getText(String key) {
        String ret = (String)languageConfig.get("texts." + key);
        if (ret != null && !ret.isEmpty()) {
            ret = ChatColor.translateAlternateColorCodes((char)'&', (String)ret);
            return ChatColor.translateAlternateColorCodes((char)'\u00a7', (String)ret);
        }
        return "Missing text node: " + key;
    }
}

