/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.Pipes;

import io.github.apfelcreme.Pipes.PipesConfig;
import io.github.apfelcreme.Pipes.PipesUtil;
import java.util.Arrays;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public enum PipesItem {
    PIPE_INPUT("Pipe Input", Material.DISPENSER, "dispenserLore"),
    PIPE_OUTPUT("Pipe Output", Material.DROPPER, "dropperLore"),
    CHUNK_LOADER("Chunk Loader", Material.FURNACE, "chunkLoaderLore");

    private static final String IDENTIFIER = "Pipes";
    private final String name;
    private final Material material;
    private final String loreKey;
    private ItemStack item;

    private PipesItem(String name, Material material, String loreKey) {
        this.name = name;
        this.material = material;
        this.loreKey = loreKey;
    }

    public static String getIdentifier() {
        return IDENTIFIER;
    }

    public String getName() {
        return this.name;
    }

    public Material getMaterial() {
        return this.material;
    }

    public String getLoreKey() {
        return this.loreKey;
    }

    public ItemStack toItemStack() {
        if (this.item != null) {
            return this.item;
        }
        ItemStack item = new ItemStack(this.material);
        ItemMeta meta = item.getItemMeta();
        List<String> lore = Arrays.asList(PipesConfig.getText("info." + this.loreKey), ChatColor.BLUE + "" + ChatColor.ITALIC + PipesUtil.hideString(this.toString(), IDENTIFIER));
        meta.setLore(lore);
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        meta.addEnchant(Enchantment.ARROW_DAMAGE, 1, true);
        meta.setDisplayName(ChatColor.RESET + "" + ChatColor.WHITE + PipesUtil.hideString(this.toString(), this.name));
        item.setItemMeta(meta);
        this.item = item;
        return item;
    }

    public boolean check(Block block) {
        if (block == null || block.getType() != this.material || !(block.getState() instanceof InventoryHolder)) {
            return false;
        }
        String hidden = PipesUtil.getHiddenString(((InventoryHolder)block.getState()).getInventory().getTitle());
        return hidden != null && this.toString().equals(hidden) || IDENTIFIER.equals(hidden);
    }

    public boolean check(ItemStack item) {
        if (item == null || item.getType() != this.material || !item.hasItemMeta() || !item.getItemMeta().hasLore()) {
            return false;
        }
        List lore = item.getItemMeta().getLore();
        String hidden = PipesUtil.getHiddenString((String)lore.get(lore.size() - 1));
        return hidden != null && this.name.equals(hidden) || IDENTIFIER.equals(hidden);
    }
}

