/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.Pipes;

import io.github.apfelcreme.Pipes.PipesItem;
import java.util.List;
import java.util.regex.Pattern;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Dispenser;
import org.bukkit.block.Dropper;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.DirectionalContainer;

public class PipesUtil {
    public static boolean isNumeric(String string) {
        return Pattern.matches("([0-9])*", string);
    }

    @Deprecated
    public static BlockFace getDropperFace(Dropper dropper) {
        if (dropper.getData() instanceof DirectionalContainer) {
            return ((DirectionalContainer)dropper.getData()).getFacing();
        }
        return null;
    }

    @Deprecated
    public static BlockFace getDispenserFace(Dispenser dispenser) {
        if (dispenser.getData() instanceof DirectionalContainer) {
            return ((DirectionalContainer)dispenser.getData()).getFacing();
        }
        return null;
    }

    public static String hideString(String hidden, String string) {
        int i;
        for (i = string.length() - 1; i >= 0 && string.length() - i <= 2; --i) {
            if (string.charAt(i) != '\u00a7') continue;
            string = string.substring(0, i);
        }
        for (i = 0; i < hidden.length(); ++i) {
            string = string + '\u00a7' + hidden.substring(i, i + 1);
        }
        return string;
    }

    public static String getHiddenString(String string) {
        StringBuilder builder = new StringBuilder();
        char[] chars = string.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '\u00a7') continue;
            if (i + 1 < chars.length) {
                if (chars[i + 1] == '\u00a7' && i > 1 && chars[i - 1] == '\u00a7') {
                    builder.append(c);
                    continue;
                }
                if (builder.length() <= 0) continue;
                builder = new StringBuilder();
                continue;
            }
            if (i <= 0 || chars[i - 1] != '\u00a7') continue;
            builder.append(c);
        }
        if (builder.length() == 0) {
            return null;
        }
        return builder.toString();
    }

    public static PipesItem getPipesItem(ItemStack item) {
        if (item == null || !item.hasItemMeta() || !item.getItemMeta().hasLore() || item.getItemMeta().getLore().isEmpty()) {
            return null;
        }
        List lore = item.getItemMeta().getLore();
        if (!((String)lore.get(lore.size() - 1)).contains(PipesItem.getIdentifier())) {
            return null;
        }
        String hidden = PipesUtil.getHiddenString((String)lore.get(lore.size() - 1));
        if (hidden == null || hidden.isEmpty()) {
            return null;
        }
        try {
            return PipesItem.valueOf(hidden);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static PipesItem getPipesItem(Block block) {
        if (!(block.getState() instanceof InventoryHolder)) {
            return null;
        }
        if (block.getType() != PipesItem.PIPE_INPUT.getMaterial() && block.getType() != PipesItem.PIPE_OUTPUT.getMaterial() && block.getType() != PipesItem.CHUNK_LOADER.getMaterial()) {
            return null;
        }
        String hidden = PipesUtil.getHiddenString(((InventoryHolder)block.getState()).getInventory().getTitle());
        if (hidden == null || hidden.isEmpty()) {
            return null;
        }
        try {
            return PipesItem.valueOf(hidden);
        }
        catch (IllegalArgumentException e) {
            if (PipesItem.getIdentifier().equals(hidden)) {
                switch (block.getType()) {
                    case DISPENSER: {
                        return PipesItem.PIPE_INPUT;
                    }
                    case DROPPER: {
                        return PipesItem.PIPE_OUTPUT;
                    }
                    case FURNACE: {
                        return PipesItem.CHUNK_LOADER;
                    }
                }
            }
            return null;
        }
    }

    public static void removeItems(Inventory inventory, Material material, int count, boolean removeSpecial) {
        for (int i = 0; i < inventory.getContents().length && count > 0; ++i) {
            ItemStack itemStack = inventory.getContents()[i];
            if (itemStack == null || itemStack.getType() != material || !removeSpecial && (itemStack.hasItemMeta() || itemStack.getDurability() != 0)) continue;
            if (itemStack.getAmount() > count) {
                itemStack.setAmount(itemStack.getAmount() - count);
                inventory.setItem(i, itemStack);
                count = 0;
                continue;
            }
            count -= itemStack.getAmount();
            inventory.clear(i);
        }
    }

    public static boolean containsSimilar(List<ItemStack> items, ItemStack itemStack) {
        for (ItemStack item : items) {
            if (item.getType() != itemStack.getType() || !item.getData().equals((Object)itemStack.getData())) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static ItemStack getCustomDispenserItem() {
        return PipesItem.PIPE_INPUT.toItemStack();
    }

    @Deprecated
    public static ItemStack getCustomDropperItem() {
        return PipesItem.PIPE_OUTPUT.toItemStack();
    }

    @Deprecated
    public static ItemStack getCustomChunkLoaderItem() {
        return PipesItem.CHUNK_LOADER.toItemStack();
    }
}

