/*
 * Decompiled with CFR 0.152.
 */
package io.github.waterfallmc.waterfall.utils;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Longs;
import io.github.waterfallmc.waterfall.utils.Hex;
import java.util.UUID;

public class UUIDUtils {
    private UUIDUtils() {
    }

    public static String undash(String id) {
        return new StringBuilder(32).append(id, 0, 8).append(id, 9, 13).append(id, 14, 18).append(id, 19, 23).append(id, 24, 36).toString();
    }

    public static String toMojangString(UUID id) {
        Preconditions.checkNotNull((Object)id, (Object)"Null id");
        return Hex.encodeString(UUIDUtils.toBytes(id));
    }

    public static UUID fromString(String s) {
        Preconditions.checkNotNull((Object)s, (Object)"Null string");
        if (s.length() == 36) {
            s = UUIDUtils.undash(s);
        } else if (s.length() != 32) {
            throw new IllegalArgumentException("Invalid UUID: " + s);
        }
        return UUIDUtils.fromMojangString0(s);
    }

    public static UUID fromMojangString(String s) {
        Preconditions.checkNotNull((Object)s, (Object)"Null string");
        if (s.length() != 32) {
            throw new IllegalArgumentException("UUID not in mojang format: " + s);
        }
        return UUIDUtils.fromMojangString0(s);
    }

    private static UUID fromMojangString0(String s) {
        assert (s != null) : "Null string";
        assert (s.length() == 32) : "invalid length: " + s;
        try {
            return UUIDUtils.fromBytes(Hex.decode(s));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid UUID: " + s);
        }
    }

    public static byte[] toBytes(UUID id) {
        Preconditions.checkNotNull((Object)id, (Object)"Null id");
        byte[] result = new byte[16];
        long lsb = id.getLeastSignificantBits();
        for (int i = 15; i >= 8; --i) {
            result[i] = (byte)(lsb & 0xFFL);
            lsb >>= 8;
        }
        long msb = id.getMostSignificantBits();
        for (int i = 7; i >= 0; --i) {
            result[i] = (byte)(msb & 0xFFL);
            msb >>= 8;
        }
        return result;
    }

    public static UUID fromBytes(byte[] bytes) {
        Preconditions.checkNotNull((Object)bytes, (Object)"Null bytes");
        if (bytes.length != 16) {
            throw new IllegalArgumentException("Invalid length: " + bytes.length);
        }
        long msb = Longs.fromBytes((byte)bytes[0], (byte)bytes[1], (byte)bytes[2], (byte)bytes[3], (byte)bytes[4], (byte)bytes[5], (byte)bytes[6], (byte)bytes[7]);
        long lsb = Longs.fromBytes((byte)bytes[8], (byte)bytes[9], (byte)bytes[10], (byte)bytes[11], (byte)bytes[12], (byte)bytes[13], (byte)bytes[14], (byte)bytes[15]);
        return new UUID(msb, lsb);
    }
}

