/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.plugin.loader.library.impl;

import io.papermc.paper.plugin.loader.library.ClassPathLibrary;
import io.papermc.paper.plugin.loader.library.LibraryLoadingException;
import io.papermc.paper.plugin.loader.library.LibraryStore;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transfer.AbstractTransferListener;
import org.eclipse.aether.transfer.TransferCancelledException;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transfer.TransferListener;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.jetbrains.annotations.NotNull;

public class MavenLibraryResolver
implements ClassPathLibrary {
    private static final Logger logger = Logger.getLogger("MavenLibraryResolver");
    private final RepositorySystem repository;
    private final DefaultRepositorySystemSession session;
    private final List<RemoteRepository> repositories = new ArrayList<RemoteRepository>();
    private final List<Dependency> dependencies = new ArrayList<Dependency>();

    public MavenLibraryResolver() {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        this.repository = (RepositorySystem)locator.getService(RepositorySystem.class);
        this.session = MavenRepositorySystemUtils.newSession();
        this.session.setChecksumPolicy("fail");
        this.session.setLocalRepositoryManager(this.repository.newLocalRepositoryManager((RepositorySystemSession)this.session, new LocalRepository("libraries")));
        this.session.setTransferListener((TransferListener)new AbstractTransferListener(){

            public void transferInitiated(@NotNull TransferEvent event) throws TransferCancelledException {
                logger.log(Level.INFO, "Downloading {0}", event.getResource().getRepositoryUrl() + event.getResource().getResourceName());
            }
        });
        this.session.setReadOnly();
    }

    public void addDependency(@NotNull Dependency dependency) {
        this.dependencies.add(dependency);
    }

    public void addRepository(@NotNull RemoteRepository remoteRepository) {
        this.repositories.add(remoteRepository);
    }

    @Override
    public void register(@NotNull LibraryStore store) throws LibraryLoadingException {
        DependencyResult result;
        List repos = this.repository.newResolutionRepositories((RepositorySystemSession)this.session, this.repositories);
        try {
            result = this.repository.resolveDependencies((RepositorySystemSession)this.session, new DependencyRequest(new CollectRequest((Dependency)null, this.dependencies, repos), null));
        }
        catch (DependencyResolutionException ex) {
            throw new LibraryLoadingException("Error resolving libraries", (Exception)((Object)ex));
        }
        for (ArtifactResult artifact : result.getArtifactResults()) {
            File file = artifact.getArtifact().getFile();
            store.addLibrary(file.toPath());
        }
    }
}

