/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry.set;

import com.google.common.collect.Lists;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.TypedKey;
import io.papermc.paper.registry.set.RegistryKeySet;
import io.papermc.paper.registry.set.RegistryKeySetImpl;
import io.papermc.paper.registry.set.RegistryValueSet;
import org.bukkit.Keyed;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;

@ApiStatus.Experimental
public sealed interface RegistrySet<T>
permits RegistryKeySet, RegistryValueSet {
    @Contract(value="_, _ -> new", pure=true)
    public static <T extends Keyed> @NonNull RegistryKeySet<T> keySetFromValues(@NonNull RegistryKey<T> registryKey, @NonNull Iterable<? extends T> values) {
        return RegistryKeySetImpl.create(registryKey, values);
    }

    @SafeVarargs
    public static <T extends Keyed> RegistryKeySet<T> keySet(@NonNull RegistryKey<T> registryKey, TypedKey<T> ... keys) {
        return RegistrySet.keySet(registryKey, Lists.newArrayList((Object[])keys));
    }

    @Contract(value="_, _ -> new", pure=true)
    public static <T extends Keyed> @NonNull RegistryKeySet<T> keySet(@NonNull RegistryKey<T> registryKey, @NonNull Iterable<TypedKey<T>> keys) {
        return new RegistryKeySetImpl<T>(registryKey, Lists.newArrayList(keys));
    }

    public @NonNull RegistryKey<T> registryKey();

    public int size();

    default public boolean isEmpty() {
        return this.size() == 0;
    }
}

