/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.datacomponent.item;

import io.papermc.paper.datacomponent.DataComponentBuilder;
import io.papermc.paper.datacomponent.item.ItemComponentTypesBridge;
import java.util.List;
import org.bukkit.FireworkEffect;
import org.checkerframework.common.value.qual.IntRange;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NullMarked;

@NullMarked
@ApiStatus.Experimental
@ApiStatus.NonExtendable
public interface Fireworks {
    @Contract(value="_, _ -> new", pure=true)
    public static Fireworks fireworks(List<FireworkEffect> effects, int flightDuration) {
        return (Fireworks)Fireworks.fireworks().addEffects(effects).flightDuration(flightDuration).build();
    }

    @Contract(value="-> new", pure=true)
    public static Builder fireworks() {
        return ItemComponentTypesBridge.bridge().fireworks();
    }

    @Contract(pure=true)
    public @Unmodifiable List<FireworkEffect> effects();

    @Contract(pure=true)
    public @IntRange(from=0L, to=255L) int flightDuration();

    @ApiStatus.Experimental
    @ApiStatus.NonExtendable
    public static interface Builder
    extends DataComponentBuilder<Fireworks> {
        @Contract(value="_ -> this", mutates="this")
        public Builder flightDuration(@IntRange(from=0L, to=255L) int var1);

        @Contract(value="_ -> this", mutates="this")
        public Builder addEffect(FireworkEffect var1);

        @Contract(value="_ -> this", mutates="this")
        public Builder addEffects(List<FireworkEffect> var1);
    }
}

