/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.event.entity;

import com.google.common.base.Preconditions;
import org.bukkit.entity.Egg;
import org.bukkit.entity.EntityType;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class ThrownEggHatchEvent
extends Event {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    private final Egg egg;
    private boolean hatching;
    private byte numHatches;
    private EntityType hatchType;

    @ApiStatus.Internal
    public ThrownEggHatchEvent(Egg egg, boolean hatching, byte numHatches, EntityType hatchingType) {
        this.egg = egg;
        this.hatching = hatching;
        this.numHatches = numHatches;
        this.hatchType = hatchingType;
    }

    public Egg getEgg() {
        return this.egg;
    }

    public boolean isHatching() {
        return this.hatching;
    }

    public void setHatching(boolean hatching) {
        this.hatching = hatching;
    }

    public EntityType getHatchingType() {
        return this.hatchType;
    }

    public void setHatchingType(EntityType hatchType) {
        Preconditions.checkArgument((boolean)hatchType.isSpawnable(), (Object)"Can't spawn that entity type from an egg!");
        this.hatchType = hatchType;
    }

    public byte getNumHatches() {
        return this.numHatches;
    }

    public void setNumHatches(byte numHatches) {
        this.numHatches = numHatches;
    }

    @Override
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }
}

