/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.event.executor;

import com.destroystokyo.paper.util.SneakyThrow;
import io.papermc.paper.event.executor.EventExecutorFactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import org.bukkit.event.Event;
import org.bukkit.event.EventException;
import org.bukkit.event.Listener;
import org.bukkit.plugin.EventExecutor;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.NullMarked;

@NullMarked
@ApiStatus.Internal
class MethodHandleEventExecutorTemplate
implements EventExecutor {
    private static final Method METHOD;
    private static final MethodHandle HANDLE;
    private static final Class<? extends Event> EVENT_CLASS;

    MethodHandleEventExecutorTemplate() {
    }

    @Override
    public void execute(Listener listener, Event event) throws EventException {
        if (!EVENT_CLASS.isInstance(event)) {
            return;
        }
        try {
            HANDLE.invokeExact(listener, event);
        }
        catch (Throwable t) {
            SneakyThrow.sneaky(t);
        }
    }

    public String toString() {
        return "MethodHandleEventExecutorTemplate['" + String.valueOf(METHOD) + "']";
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        EventExecutorFactory.ClassData classData = EventExecutorFactory.classData(lookup);
        METHOD = classData.method();
        HANDLE = classData.methodHandle();
        EVENT_CLASS = classData.eventClass();
    }
}

