/*
 * Decompiled with CFR 0.152.
 */
package me.william278.huskhomes2.commands;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import me.william278.huskhomes2.util.MessageManager;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public abstract class CommandBase
implements CommandExecutor {
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (sender instanceof Player) {
            if (!this.onCommand((Player)sender, command, label, args)) {
                this.sendInvalidSyntaxMessage((Player)sender, command.getName(), command.getUsage());
            }
            return true;
        }
        return false;
    }

    protected void sendInvalidSyntaxMessage(Player player, String command, String usage) {
        if (MessageManager.hasMessage("error_invalid_syntax_" + command)) {
            MessageManager.sendMessage(player, "error_invalid_syntax_" + command, usage);
        } else {
            MessageManager.sendMessage(player, "error_invalid_syntax", usage);
        }
    }

    protected abstract boolean onCommand(Player var1, Command var2, String var3, String[] var4);

    public PluginCommand register(PluginCommand command) {
        Objects.requireNonNull(command);
        command.setExecutor((CommandExecutor)this);
        if (this instanceof TabCompleter) {
            command.setTabCompleter((TabCompleter)this);
        }
        command.setDescription(MessageManager.getRawMessage(command.getName() + "_command_description"));
        return command;
    }

    public static class EmptyTab
    implements TabCompleter {
        public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, String[] strings) {
            return Collections.emptyList();
        }
    }
}

