/*
 * Decompiled with CFR 0.152.
 */
package me.william278.huskhomes2.commands;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import me.william278.huskhomes2.HuskHomes;
import me.william278.huskhomes2.commands.CommandBase;
import me.william278.huskhomes2.commands.HomeListCommand;
import me.william278.huskhomes2.commands.PublicHomeCommand;
import me.william278.huskhomes2.data.DataManager;
import me.william278.huskhomes2.teleport.TeleportManager;
import me.william278.huskhomes2.teleport.points.Home;
import me.william278.huskhomes2.util.MessageManager;
import me.william278.huskhomes2.util.RegexUtil;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;

public class HomeCommand
extends CommandBase {
    private static final HuskHomes plugin = HuskHomes.getInstance();

    @Override
    protected boolean onCommand(Player p, Command command, String label, String[] args) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            try (Connection connection = HuskHomes.getConnection();){
                if (args.length == 1) {
                    String homeArgument = args[0];
                    if (RegexUtil.OWNER_NAME_PATTERN.matcher(homeArgument).matches()) {
                        PublicHomeCommand.queueHomeTeleport(p, homeArgument);
                    } else if (DataManager.homeExists(p, homeArgument, connection).booleanValue()) {
                        Home home = DataManager.getHome(p.getName(), homeArgument, connection);
                        TeleportManager.queueTimedTeleport(p, home);
                    } else {
                        MessageManager.sendMessage(p, "error_home_invalid", homeArgument);
                    }
                } else {
                    List<Home> homes = DataManager.getPlayerHomes(p.getName(), connection);
                    if (homes.size() == 1) {
                        TeleportManager.queueTimedTeleport(p, homes.get(0));
                        return;
                    }
                    HomeListCommand.displayPlayerHomeList(p, p.getName(), 1);
                }
            }
            catch (SQLException e) {
                plugin.getLogger().log(Level.SEVERE, "An SQL exception occurred teleporting home.", e);
            }
        });
        return true;
    }

    public static class Tab
    implements TabCompleter {
        private static final Map<UUID, List<String>> homeTabCache = new HashMap<UUID, List<String>>();

        public static void updatePlayerHomeCache(Player p) {
            UUID uuid = p.getUniqueId();
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
                try (Connection connection = HuskHomes.getConnection();){
                    List<Home> playerHomes = DataManager.getPlayerHomes(p.getName(), connection);
                    ArrayList<String> homeNames = new ArrayList<String>();
                    for (Home home : playerHomes) {
                        homeNames.add(home.getName());
                    }
                    homeTabCache.put(uuid, homeNames);
                }
                catch (SQLException e) {
                    plugin.getLogger().log(Level.WARNING, "An SQL exception occurred updating the player home cache", e);
                }
            });
        }

        public List<String> onTabComplete(CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
            Player p = (Player)sender;
            if (!sender.hasPermission("huskhomes.home")) {
                return Collections.emptyList();
            }
            if (args.length == 1) {
                ArrayList<String> tabCompletions = new ArrayList<String>();
                List<String> homes = homeTabCache.get(p.getUniqueId());
                if (homes == null) {
                    Tab.updatePlayerHomeCache(p);
                    return Collections.emptyList();
                }
                StringUtil.copyPartialMatches((String)args[0], homes, tabCompletions);
                Collections.sort(tabCompletions);
                return tabCompletions;
            }
            return Collections.emptyList();
        }

        public static Map<UUID, List<String>> getHomeTabCache() {
            return homeTabCache;
        }
    }
}

