/*
 * Decompiled with CFR 0.152.
 */
package me.william278.huskhomes2.commands;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import me.william278.huskhomes2.HuskHomes;
import me.william278.huskhomes2.commands.CommandBase;
import me.william278.huskhomes2.data.DataManager;
import me.william278.huskhomes2.libraries.minedown.MineDown;
import me.william278.huskhomes2.teleport.points.Home;
import me.william278.huskhomes2.util.ChatList;
import me.william278.huskhomes2.util.MessageManager;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class HomeListCommand
extends CommandBase {
    private static final HuskHomes plugin = HuskHomes.getInstance();

    @Override
    protected boolean onCommand(Player p, Command command, String label, String[] args) {
        String homeOwnerName;
        int pageNo;
        block5: {
            pageNo = 1;
            homeOwnerName = p.getName();
            if (args.length == 1 || args.length == 2) {
                try {
                    pageNo = Integer.parseInt(args[0]);
                }
                catch (NumberFormatException numberFormatException) {
                    homeOwnerName = args[0];
                    if (args.length != 2) break block5;
                    try {
                        pageNo = Integer.parseInt(args[1]);
                    }
                    catch (NumberFormatException numberFormatException2) {
                        return false;
                    }
                }
            }
        }
        HomeListCommand.displayPlayerHomeList(p, homeOwnerName, pageNo);
        return true;
    }

    public static void displayPlayerHomeList(Player player, String homeOwnerName, int pageNumber) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            if (!player.getName().equalsIgnoreCase(homeOwnerName) && !player.hasPermission("huskhomes.home.other")) {
                MessageManager.sendMessage(player, "error_no_permission");
                return;
            }
            try (Connection connection = HuskHomes.getConnection();){
                ChatList homeChatList;
                if (!DataManager.playerExists(homeOwnerName, connection).booleanValue()) {
                    MessageManager.sendMessage(player, "error_invalid_player");
                    return;
                }
                List<Home> homes = DataManager.getPlayerHomes(homeOwnerName, connection);
                if (homes.isEmpty()) {
                    if (!player.getName().equalsIgnoreCase(homeOwnerName)) {
                        MessageManager.sendMessage(player, "error_no_homes_set_other", homeOwnerName);
                    } else {
                        MessageManager.sendMessage(player, "error_no_homes_set");
                    }
                    return;
                }
                ArrayList<String> homeList = new ArrayList<String>();
                for (Home home : homes) {
                    homeList.add(MessageManager.getRawMessage("home_list_item", home.getName(), home.getOwnerUsername(), MineDown.escape(home.getDescription()).replace("]", "\\]").replace("[", "\\[").replace("(", "\\(").replace(")", "\\)")));
                }
                int itemsPerPage = HuskHomes.getSettings().getPrivateHomesPerPage();
                int homeLowerBound = (pageNumber - 1) * itemsPerPage;
                int homeUpperBound = pageNumber * itemsPerPage;
                if (homeUpperBound > homeList.size()) {
                    homeUpperBound = homeList.size();
                }
                if ((homeChatList = new ChatList(homeList, itemsPerPage, "/huskhomes:homelist " + homeOwnerName, MessageManager.getRawMessage("list_item_divider"), true)).doesNotContainPage(pageNumber)) {
                    MessageManager.sendMessage(player, "error_invalid_page_number");
                    return;
                }
                MessageManager.sendMessage(player, "private_home_list_page_top", homeOwnerName, Integer.toString(homeLowerBound + 1), Integer.toString(homeUpperBound), Integer.toString(homeList.size()));
                homeChatList.sendPage(player, pageNumber);
            }
            catch (SQLException e) {
                plugin.getLogger().log(Level.SEVERE, "An SQL exception occurred!", e);
            }
        });
    }
}

