/*
 * Decompiled with CFR 0.152.
 */
package me.william278.huskhomes2.commands;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import me.william278.huskhomes2.HuskHomes;
import me.william278.huskhomes2.commands.CommandBase;
import me.william278.huskhomes2.commands.PublicHomeListCommand;
import me.william278.huskhomes2.data.DataManager;
import me.william278.huskhomes2.teleport.TeleportManager;
import me.william278.huskhomes2.teleport.points.Home;
import me.william278.huskhomes2.util.MessageManager;
import me.william278.huskhomes2.util.RegexUtil;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;

public class PublicHomeCommand
extends CommandBase
implements TabCompleter {
    private static final Map<String, String> publicHomeTabCache = new HashMap<String, String>();
    private static final HuskHomes plugin = HuskHomes.getInstance();

    public static void updatePublicHomeTabCache() {
        publicHomeTabCache.clear();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            try (Connection connection = HuskHomes.getConnection();){
                for (Home home : DataManager.getPublicHomes(connection)) {
                    publicHomeTabCache.put(home.getName(), home.getOwnerUsername());
                }
            }
            catch (SQLException exception) {
                plugin.getLogger().log(Level.SEVERE, "An SQL exception occurred updating the public home tab cache");
            }
        });
    }

    public static void queueHomeTeleport(Player p, String publicHome) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            try (Connection connection = HuskHomes.getConnection();){
                String[] split = publicHome.split("\\.");
                String ownerName = split[0];
                String homeName = split[1];
                if (DataManager.homeExists(ownerName, homeName, connection).booleanValue()) {
                    Home home = DataManager.getHome(ownerName, homeName, connection);
                    assert (home != null);
                    if (home.isPublic() || p.getName().equalsIgnoreCase(ownerName) || p.hasPermission("huskhomes.home.other")) {
                        TeleportManager.queueTimedTeleport(p, home);
                    } else {
                        MessageManager.sendMessage(p, "error_public_home_invalid", ownerName, homeName);
                    }
                } else {
                    MessageManager.sendMessage(p, "error_public_home_invalid", ownerName, homeName);
                }
            }
            catch (SQLException e) {
                plugin.getLogger().log(Level.SEVERE, "An exception occurred teleporting to a public home.");
            }
        });
    }

    @Override
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        CommandSender commandSender = sender;
        if (!(commandSender instanceof Player)) {
            PublicHomeCommand.handleConsolePublicHomeTeleport(sender, args);
            return true;
        }
        Player p = (Player)commandSender;
        if (args.length == 0) {
            PublicHomeListCommand.displayPublicHomeList(p, 1);
            return true;
        }
        String publicHome = args[0];
        if (RegexUtil.OWNER_NAME_PATTERN.matcher(publicHome).matches()) {
            PublicHomeCommand.queueHomeTeleport(p, publicHome);
        } else {
            this.sendInvalidSyntaxMessage(p, command.getName(), command.getUsage());
        }
        return true;
    }

    public static void handleConsolePublicHomeTeleport(CommandSender sender, String[] args) {
        if (args.length == 2) {
            String publicHomeName = args[0];
            Player targetPlayer = Bukkit.getPlayer((String)args[1]);
            if (targetPlayer != null) {
                if (RegexUtil.OWNER_NAME_PATTERN.matcher(publicHomeName).matches()) {
                    String[] split = publicHomeName.split("\\.");
                    String ownerName = split[0];
                    String homeName = split[1];
                    Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
                        try (Connection connection = HuskHomes.getConnection();){
                            if (DataManager.homeExists(ownerName, homeName, connection).booleanValue()) {
                                Home home = DataManager.getHome(ownerName, homeName, connection);
                                assert (home != null);
                                if (!home.isPublic()) {
                                    sender.sendMessage("Warning: Bypassed home security (" + home.getName() + " was not set to public by " + home.getOwnerUsername() + ")");
                                }
                                Bukkit.getScheduler().runTask((Plugin)plugin, () -> {
                                    TeleportManager.teleportPlayer(targetPlayer, home);
                                    sender.sendMessage("Successfully teleported player!");
                                    MessageManager.sendMessage(targetPlayer, "teleporting_complete_console", home.getOwnerUsername() + "." + homeName);
                                });
                            } else {
                                sender.sendMessage("Error: Invalid home \"" + publicHomeName + "\" specified");
                            }
                        }
                        catch (SQLException e) {
                            plugin.getLogger().log(Level.SEVERE, "An SQL exception occurred handling a consome phome teleport");
                        }
                    });
                } else {
                    sender.sendMessage("Error: Invalid public home format: /warp <ownerUsername.homeName> <player>");
                }
            } else {
                sender.sendMessage("Error: Invalid player specified (are they online?)");
            }
        } else {
            sender.sendMessage("Console Public Home Usage: /phome <owner_name.home_name> <player>");
        }
    }

    @Override
    protected boolean onCommand(Player player, Command command, String label, String[] args) {
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
        if (!sender.hasPermission("huskhomes.publichome")) {
            return Collections.emptyList();
        }
        if (args.length == 1) {
            ArrayList sortedHomeNames = new ArrayList();
            StringUtil.copyPartialMatches((String)args[0], publicHomeTabCache.keySet(), sortedHomeNames);
            Collections.sort(sortedHomeNames);
            ArrayList<String> finalCompletions = new ArrayList<String>();
            for (String homeName : sortedHomeNames) {
                finalCompletions.add(publicHomeTabCache.get(homeName) + "." + homeName);
            }
            return finalCompletions;
        }
        return Collections.emptyList();
    }
}

