/*
 * Decompiled with CFR 0.152.
 */
package me.william278.huskhomes2.commands;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import me.william278.huskhomes2.HuskHomes;
import me.william278.huskhomes2.commands.CommandBase;
import me.william278.huskhomes2.data.DataManager;
import me.william278.huskhomes2.teleport.SettingHandler;
import me.william278.huskhomes2.teleport.points.Home;
import me.william278.huskhomes2.util.MessageManager;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class SetHomeCommand
extends CommandBase {
    private static final HuskHomes plugin = HuskHomes.getInstance();

    @Override
    protected boolean onCommand(Player p, Command command, String label, String[] args) {
        if (args.length == 1) {
            String homeName = args[0];
            SettingHandler.setHome(p.getLocation(), p, homeName);
        } else {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
                try (Connection connection = HuskHomes.getConnection();){
                    int currentHomeCount = DataManager.getPlayerHomeCount(p, connection);
                    if (currentHomeCount == 0) {
                        SettingHandler.setHome(p.getLocation(), p, "home");
                    } else if (currentHomeCount == 1 && Home.getSetHomeLimit(p) == 1) {
                        MessageManager.sendMessage(p, "error_set_home_already_set");
                    } else {
                        this.sendInvalidSyntaxMessage(p, command.getName(), command.getUsage());
                    }
                }
                catch (SQLException e) {
                    plugin.getLogger().log(Level.SEVERE, "An exception occurred setting your first home");
                }
            });
        }
        return true;
    }
}

