/*
 * Decompiled with CFR 0.152.
 */
package me.william278.huskhomes2.config;

import java.util.Locale;
import me.william278.huskhomes2.HuskHomes;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class Settings {
    private final Plugin plugin;
    private String language;
    private boolean doStartupUpdateChecks;
    private boolean doBungee;
    private int clusterId;
    private String server;
    private boolean doCrossServerTabCompletion;
    private int crossServerTabUpdateDelay;
    private String messengerType;
    private String storageType;
    private String playerDataTable;
    private String locationsDataTable;
    private String homesDataTable;
    private String warpsDataTable;
    private int mySQLPort;
    private String mySQLHost;
    private String mySQLDatabase;
    private String mySQLUsername;
    private String mySQLPassword;
    private String mySQLParams;
    private int hikariMaximumPoolSize;
    private int hikariMinimumIdle;
    private long hikariMaximumLifetime;
    private long hikariKeepAliveTime;
    private long hikariConnectionTimeOut;
    private int redisPort;
    private String redisHost;
    private String redisPassword;
    private boolean redisSSL;
    private boolean doMapIntegration;
    private String mapPlugin;
    private boolean mapPublicHomes;
    private boolean mapWarps;
    private String mapPublicHomeMarkerSet;
    private String mapWarpMarkerSet;
    private boolean doEconomy;
    private int freeHomeSlots;
    private double setHomeCost;
    private double publicHomeCost;
    private double rtpCost;
    private double backCost;
    private boolean allowUnicodeInDescriptions;
    private boolean checkVanishedPlayers;
    private int maximumHomes;
    private int teleportRequestExpiryTime;
    private int teleportWarmupTime;
    private DisplayStyle teleportWarmupDisplayStyle;
    private boolean doBackCommand;
    private Sound teleportationCompleteSound;
    private Sound teleportWarmupSound;
    private Sound teleportCancelledSound;
    private int privateHomesPerPage;
    private int publicHomesPerPage;
    private int warpsPerPage;
    private boolean hideCommandsFromHelpMenuWithoutPermission;
    private boolean hideHuskHomesCommandFromHelpMenu;
    private boolean autoCompletePlayerNames;
    private boolean homeLimitPermissionStacking;
    private boolean doRtpCommand;
    private int rtpRange;
    private int rtpCoolDown;
    private boolean doSpawnCommand;
    private boolean doCrossServerSpawn;
    private String crossServerSpawnWarpName;
    private boolean forceSpawnOnLogin;
    private boolean doWarpCommand;
    private boolean doPermissionRestrictedWarps;
    private boolean hideRestrictedWarps;
    private String warpRestrictionPermissionFormat;

    public Settings(Plugin plugin) {
        this.plugin = plugin;
    }

    public void reload() {
        this.plugin.reloadConfig();
        this.reloadFromFile(this.plugin.getConfig());
    }

    public void reloadFromFile(FileConfiguration config) {
        try {
            Plugin vault;
            PluginManager pluginManager;
            this.language = config.getString("language", "en-gb");
            this.doStartupUpdateChecks = config.getBoolean("check_for_updates", true);
            this.doBungee = config.getBoolean("bungee_options.enable_bungee_mode", false);
            this.server = config.getString("bungee_options.server_id", "server");
            this.clusterId = config.getInt("bungee_options.cluster_id", 0);
            this.doCrossServerTabCompletion = config.getBoolean("bungee_options.tab_complete_cross_server.enabled", true);
            this.crossServerTabUpdateDelay = config.getInt("bungee_options.tab_complete_cross_server.delay", 60);
            this.messengerType = config.getString("bungee_options.messenger_type", "pluginmessage");
            this.storageType = config.getString("data_storage_options.storage_type", "SQLite");
            this.playerDataTable = config.getString("data_storage_options.table_names.player_data", "huskhomes_player_data");
            this.locationsDataTable = config.getString("data_storage_options.table_names.locations_data", "huskhomes_location_data");
            this.homesDataTable = config.getString("data_storage_options.table_names.homes_data", "huskhomes_home_data");
            this.warpsDataTable = config.getString("data_storage_options.table_names.warps_data", "huskhomes_warp_data");
            if (this.storageType.equalsIgnoreCase("SQLite") && this.doBungee) {
                Bukkit.getLogger().warning("Bungee mode was set in config to be enabled but storage type was set to SQLite!");
                Bukkit.getLogger().warning("A mySQL Database is required to utilise Bungee mode, so bungee mode has been disabled.");
                Bukkit.getLogger().warning("To use Bungee mode and cross-server teleportation, please update your data storage settings to use \"mysql\" and update the connection credentials accordingly.");
                this.doBungee = false;
            }
            this.mySQLHost = config.getString("data_storage_options.mysql_credentials.host", "localhost");
            this.mySQLDatabase = config.getString("data_storage_options.mysql_credentials.database", "HuskHomes");
            this.mySQLUsername = config.getString("data_storage_options.mysql_credentials.username", "root");
            this.mySQLPassword = config.getString("data_storage_options.mysql_credentials.password", "pa55w0rd");
            this.mySQLPort = config.getInt("data_storage_options.mysql_credentials.port", 3306);
            this.mySQLParams = config.getString("data_storage_options.mysql_credentials.params", "?autoReconnect=true&useSSL=false");
            this.hikariMaximumPoolSize = config.getInt("data_storage_options.connection_pool_options.maximum_pool_size", 10);
            this.hikariMinimumIdle = config.getInt("data_storage_options.connection_pool_options.minimum_idle", 10);
            this.hikariMaximumLifetime = config.getLong("data_storage_options.connection_pool_options.maximum_lifetime", 1800000L);
            this.hikariKeepAliveTime = config.getLong("data_storage_options.connection_pool_options.keepalive_time", 0L);
            this.hikariConnectionTimeOut = config.getLong("data_storage_options.connection_pool_options.connection_timeout", 5000L);
            this.redisHost = config.getString("bungee_options.redis_credentials.host", "localhost");
            this.redisPort = config.getInt("bungee_options.redis_credentials.port", 6379);
            this.redisPassword = config.getString("bungee_options.redis_credentials.password", "");
            this.redisSSL = config.getBoolean("bungee_options.redis_credentials.use_ssl", false);
            this.doMapIntegration = config.getBoolean("map_integration.enabled", false);
            this.mapPlugin = config.getString("map_integration.plugin", "dynmap");
            if (this.doMapIntegration) {
                pluginManager = HuskHomes.getInstance().getServer().getPluginManager();
                switch (this.mapPlugin.toLowerCase()) {
                    case "dynmap": 
                    case "bluemap": 
                    case "squaremap": {
                        Plugin mapSpigotPlugin = pluginManager.getPlugin(this.mapPlugin.toLowerCase());
                        if (mapSpigotPlugin != null) break;
                        Bukkit.getLogger().warning(this.mapPlugin + " integration was enabled in config, but the " + this.mapPlugin + " plugin could not be found!");
                        Bukkit.getLogger().warning("The map integration setting has been disabled. Please ensure " + this.mapPlugin + " is installed and restart the server.");
                        this.doMapIntegration = false;
                        this.plugin.getConfig().set("map_integration.enabled", (Object)false);
                        this.plugin.saveConfig();
                        break;
                    }
                    default: {
                        Bukkit.getLogger().warning("Map integration was enabled in config, but the map plugin type was invalid.");
                        Bukkit.getLogger().warning("The map integration setting has been disabled. Please ensure you specify a valid map plugin type.");
                        this.doMapIntegration = false;
                        this.plugin.getConfig().set("map_integration.enabled", (Object)false);
                        this.plugin.saveConfig();
                    }
                }
            }
            this.mapPublicHomes = config.getBoolean("map_integration.markers.public_homes.show", true);
            this.mapWarps = config.getBoolean("map_integration.markers.warps.show", true);
            this.mapPublicHomeMarkerSet = config.getString("map_integration.markers.public_homes.set_name", "Public Homes");
            this.mapWarpMarkerSet = config.getString("map_integration.markers.warps.set_name", "Warps");
            this.doEconomy = config.getBoolean("economy_integration.enabled", false);
            if (this.doEconomy && (vault = (pluginManager = HuskHomes.getInstance().getServer().getPluginManager()).getPlugin("Vault")) == null) {
                Bukkit.getLogger().warning("Economy integration was enabled in config, but the Vault plugin could not be found!");
                Bukkit.getLogger().warning("Economy features have been disabled. Please ensure both Vault and an economy plugin are installed and restart the server.");
                this.doEconomy = false;
            }
            this.freeHomeSlots = config.getInt("economy_integration.free_home_slots", 5);
            this.setHomeCost = config.getDouble("economy_integration.costs.additional_home_slot", 100.0);
            this.publicHomeCost = config.getDouble("economy_integration.costs.make_home_public", 50.0);
            this.rtpCost = config.getDouble("economy_integration.costs.random_teleport", 20.0);
            this.backCost = config.getDouble("economy_integration.costs.back", 0.0);
            this.teleportationCompleteSound = this.getSound(config, "teleportation_complete", Sound.ENTITY_ENDERMAN_TELEPORT);
            this.teleportWarmupSound = this.getSound(config, "teleportation_warmup", Sound.BLOCK_NOTE_BLOCK_BANJO);
            this.teleportCancelledSound = this.getSound(config, "teleportation_cancelled", Sound.ENTITY_ITEM_BREAK);
            this.allowUnicodeInDescriptions = config.getBoolean("allow_unicode_descriptions", true);
            this.checkVanishedPlayers = config.getBoolean("handle_vanished_players", true);
            this.doSpawnCommand = config.getBoolean("spawn_command.enabled", true);
            this.doCrossServerSpawn = config.getBoolean("spawn_command.bungee_network_spawn.enabled", false);
            this.crossServerSpawnWarpName = config.getString("spawn_command.bungee_network_spawn.warp_name", "Spawn");
            this.forceSpawnOnLogin = config.getBoolean("spawn_command.force_teleport_on_login", false);
            this.doWarpCommand = config.getBoolean("warp_command.enabled", true);
            this.doPermissionRestrictedWarps = config.getBoolean("warp_command.permission_restrictions.require_permission", false);
            this.warpRestrictionPermissionFormat = config.getString("warp_command.permission_restrictions.format", "huskhomes.warp.");
            this.hideRestrictedWarps = config.getBoolean("warp_command.permission_restrictions.hide_restricted_warps", true);
            this.autoCompletePlayerNames = config.getBoolean("general.auto_complete_player_names", true);
            this.homeLimitPermissionStacking = config.getBoolean("general.home_limit_permission_stacking", false);
            this.doRtpCommand = config.getBoolean("random_teleport_command.enabled", true);
            this.rtpRange = config.getInt("random_teleport_command.range", 5000);
            this.rtpCoolDown = config.getInt("random_teleport_command.cooldown", 30);
            this.doBackCommand = config.getBoolean("general.enable_back_command", true);
            this.privateHomesPerPage = config.getInt("general.lists.private_homes_per_page", 10);
            this.publicHomesPerPage = config.getInt("general.lists.public_homes_per_page", 10);
            this.warpsPerPage = config.getInt("general.lists.warps_per_page", 10);
            this.hideCommandsFromHelpMenuWithoutPermission = config.getBoolean("general.help_menu.hide_commands_without_permission", true);
            this.hideHuskHomesCommandFromHelpMenu = config.getBoolean("general.help_menu.hide_huskhomes_command", false);
            this.maximumHomes = config.getInt("general.max_sethomes", 10);
            this.teleportRequestExpiryTime = config.getInt("general.teleport_request_expiry_time", 60);
            this.teleportWarmupTime = config.getInt("general.teleport_warmup_time", 5);
            this.teleportWarmupDisplayStyle = DisplayStyle.valueOf(config.getString("general.teleport_warmup_display", "ACTION_BAR"));
        }
        catch (Exception e) {
            HuskHomes.disablePlugin("An error occurred loading the HuskHomes config (" + e.getCause() + ")");
            e.printStackTrace();
        }
    }

    private Sound getSound(FileConfiguration config, String configKey, Sound defaultSound) {
        String soundString = config.getString("general.sounds." + configKey);
        if (soundString != null && !soundString.isEmpty()) {
            try {
                return Sound.valueOf((String)soundString.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException exception) {
                Bukkit.getLogger().severe("Invalid sound " + soundString + " specified in config.yml for " + configKey + "; using default sound " + defaultSound + " instead.");
                return defaultSound;
            }
        }
        return null;
    }

    public String getMapPlugin() {
        return this.mapPlugin;
    }

    public boolean showPublicHomesOnMap() {
        return this.mapPublicHomes;
    }

    public boolean showWarpsOnMap() {
        return this.mapWarps;
    }

    public String getMapPublicHomeMarkerSet() {
        return this.mapPublicHomeMarkerSet;
    }

    public String getMapWarpMarkerSet() {
        return this.mapWarpMarkerSet;
    }

    public boolean doMapIntegration() {
        return this.doMapIntegration;
    }

    public int getTeleportWarmupTime() {
        return this.teleportWarmupTime;
    }

    public String getDatabaseType() {
        return this.storageType;
    }

    public boolean isCheckVanishedPlayers() {
        return this.checkVanishedPlayers;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getServerID() {
        return this.server;
    }

    public int getClusterId() {
        return this.clusterId;
    }

    public boolean doBungee() {
        return this.doBungee;
    }

    public int getMaximumHomes() {
        return this.maximumHomes;
    }

    public int getRtpCoolDown() {
        return this.rtpCoolDown;
    }

    public int getTeleportRequestExpiryTime() {
        return this.teleportRequestExpiryTime;
    }

    public int getRtpRange() {
        return this.rtpRange;
    }

    public boolean doRtpCommand() {
        return this.doRtpCommand;
    }

    public String getPlayerDataTable() {
        return this.playerDataTable;
    }

    public String getLocationsDataTable() {
        return this.locationsDataTable;
    }

    public String getHomesDataTable() {
        return this.homesDataTable;
    }

    public String getWarpsDataTable() {
        return this.warpsDataTable;
    }

    public int getMySQLPort() {
        return this.mySQLPort;
    }

    public String getMySQLHost() {
        return this.mySQLHost;
    }

    public String getMySQLDatabase() {
        return this.mySQLDatabase;
    }

    public String getMySQLUsername() {
        return this.mySQLUsername;
    }

    public String getMySQLPassword() {
        return this.mySQLPassword;
    }

    public String getMySQLParams() {
        return this.mySQLParams;
    }

    public boolean doSpawnCommand() {
        return this.doSpawnCommand;
    }

    public boolean doCrossServerSpawn() {
        return this.doCrossServerSpawn;
    }

    public String getSpawnWarpName() {
        return this.crossServerSpawnWarpName;
    }

    public boolean doForceSpawnOnLogin() {
        return this.forceSpawnOnLogin;
    }

    public boolean doEconomy() {
        return this.doEconomy;
    }

    public int getFreeHomeSlots() {
        return this.freeHomeSlots;
    }

    public double getSetHomeCost() {
        return this.setHomeCost;
    }

    public double getBackCost() {
        return this.backCost;
    }

    public double getPublicHomeCost() {
        return this.publicHomeCost;
    }

    public double getRtpCost() {
        return this.rtpCost;
    }

    public int getPrivateHomesPerPage() {
        return this.privateHomesPerPage;
    }

    public int getPublicHomesPerPage() {
        return this.publicHomesPerPage;
    }

    public int getWarpsPerPage() {
        return this.warpsPerPage;
    }

    public Sound getTeleportationCompleteSound() {
        return this.teleportationCompleteSound;
    }

    public Sound getTeleportWarmupSound() {
        return this.teleportWarmupSound;
    }

    public Sound getTeleportCancelledSound() {
        return this.teleportCancelledSound;
    }

    public boolean doStartupUpdateChecks() {
        return this.doStartupUpdateChecks;
    }

    public boolean doCrossServerTabCompletion() {
        return this.doCrossServerTabCompletion;
    }

    public int getCrossServerTabUpdateDelay() {
        return this.crossServerTabUpdateDelay;
    }

    public boolean doWarpCommand() {
        return this.doWarpCommand;
    }

    public boolean doPermissionRestrictedWarps() {
        return this.doPermissionRestrictedWarps;
    }

    public String getWarpRestrictionPermissionFormat() {
        return this.warpRestrictionPermissionFormat;
    }

    public boolean doHideRestrictedWarps() {
        return this.hideRestrictedWarps;
    }

    public boolean hideCommandsFromHelpMenuWithoutPermission() {
        return this.hideCommandsFromHelpMenuWithoutPermission;
    }

    public boolean hideHuskHomesCommandFromHelpMenu() {
        return this.hideHuskHomesCommandFromHelpMenu;
    }

    public boolean doUnicodeInDescriptions() {
        return this.allowUnicodeInDescriptions;
    }

    public String getMessengerType() {
        return this.messengerType;
    }

    public int getRedisPort() {
        return this.redisPort;
    }

    public String getRedisHost() {
        return this.redisHost;
    }

    public String getRedisPassword() {
        return this.redisPassword;
    }

    public boolean getRedisSSL() {
        return this.redisSSL;
    }

    public boolean getDoBackCommand() {
        return this.doBackCommand;
    }

    public int getHikariMaximumPoolSize() {
        return this.hikariMaximumPoolSize;
    }

    public int getHikariMinimumIdle() {
        return this.hikariMinimumIdle;
    }

    public long getHikariMaximumLifetime() {
        return this.hikariMaximumLifetime;
    }

    public long getHikariKeepAliveTime() {
        return this.hikariKeepAliveTime;
    }

    public long getHikariConnectionTimeOut() {
        return this.hikariConnectionTimeOut;
    }

    public boolean doAutoCompletePlayerNames() {
        return this.autoCompletePlayerNames;
    }

    public boolean doHomeLimitPermissionStacking() {
        return this.homeLimitPermissionStacking;
    }

    public DisplayStyle getWarmupDisplayStyle() {
        return this.teleportWarmupDisplayStyle;
    }

    public static enum DisplayStyle {
        ACTION_BAR,
        TITLE,
        SUBTITLE,
        CHAT;

    }
}

