/*
 * Decompiled with CFR 0.152.
 */
package me.william278.huskhomes2.data.message;

import java.util.Locale;
import java.util.StringJoiner;
import me.william278.huskhomes2.HuskHomes;
import org.bukkit.entity.Player;

public abstract class Message {
    private static final String MESSAGE_DATA_SEPARATOR = "$";
    private final int clusterId;
    private final MessageType messageType;
    private final String targetPlayerName;
    private final String messageData;

    public Message(String targetPlayerName, MessageType pluginMessageType, String ... messageData) {
        this.clusterId = HuskHomes.getSettings().getClusterId();
        this.messageType = pluginMessageType;
        StringJoiner newMessageData = new StringJoiner(MESSAGE_DATA_SEPARATOR);
        for (String dataItem : messageData) {
            newMessageData.add(dataItem);
        }
        this.messageData = newMessageData.toString();
        this.targetPlayerName = targetPlayerName;
    }

    public Message(MessageType pluginMessageType, String ... messageData) {
        this.clusterId = HuskHomes.getSettings().getClusterId();
        this.messageType = pluginMessageType;
        StringJoiner newMessageData = new StringJoiner(MESSAGE_DATA_SEPARATOR);
        for (String dataItem : messageData) {
            newMessageData.add(dataItem);
        }
        this.messageData = newMessageData.toString();
        this.targetPlayerName = null;
    }

    public Message(int clusterId, String targetPlayerName, String pluginMessageType, String ... messageData) {
        this(clusterId, targetPlayerName, MessageType.valueOf(pluginMessageType.toUpperCase(Locale.ENGLISH)), messageData);
    }

    public Message(int clusterId, String targetPlayerName, MessageType pluginMessageType, String ... messageData) {
        this.clusterId = clusterId;
        this.messageType = pluginMessageType;
        StringJoiner newMessageData = new StringJoiner(MESSAGE_DATA_SEPARATOR);
        for (String dataItem : messageData) {
            newMessageData.add(dataItem);
        }
        this.messageData = newMessageData.toString();
        this.targetPlayerName = targetPlayerName;
    }

    protected String getPluginMessageString(MessageType type) {
        return type.name().toLowerCase(Locale.ENGLISH);
    }

    public int getClusterId() {
        return this.clusterId;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public String getTargetPlayerName() {
        return this.targetPlayerName;
    }

    public String getMessageData() {
        return this.messageData;
    }

    public String[] getMessageDataItems() {
        return this.messageData.split("\\$");
    }

    public abstract void send(Player var1);

    public abstract void sendToAllServers(Player var1);

    public abstract void sendToServer(Player var1, String var2);

    public static enum MessageType {
        SET_TP_DESTINATION,
        CONFIRM_DESTINATION_SET,
        TPA_REQUEST,
        TPA_HERE_REQUEST,
        TPA_REQUEST_ANSWER,
        TPA_HERE_REQUEST_ANSWER,
        TPA_REQUEST_REPLY,
        TPA_HERE_REQUEST_REPLY,
        TELEPORT_TO_ME,
        UPDATE_PLAYER_LIST(false);

        private final boolean requiresPlayer;

        private MessageType() {
            this(true);
        }

        private MessageType(boolean requiresPlayer) {
            this.requiresPlayer = requiresPlayer;
        }

        public boolean requiresPlayer() {
            return this.requiresPlayer;
        }
    }
}

