/*
 * Decompiled with CFR 0.152.
 */
package me.william278.huskhomes2.data.message.pluginmessage;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import me.william278.huskhomes2.HuskHomes;
import me.william278.huskhomes2.data.message.CrossServerMessageHandler;
import me.william278.huskhomes2.data.message.pluginmessage.PluginMessage;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.jetbrains.annotations.NotNull;

public class PluginMessageReceiver
implements PluginMessageListener {
    public void onPluginMessageReceived(String channel, @NotNull Player player, byte[] message) {
        int clusterID;
        if (!channel.equals("BungeeCord")) {
            return;
        }
        ByteArrayDataInput input = ByteStreams.newDataInput((byte[])message);
        String messageType = input.readUTF();
        if (!messageType.contains("HuskHomes:")) {
            return;
        }
        try {
            clusterID = Integer.parseInt(messageType.split(":")[1]);
        }
        catch (Exception e) {
            HuskHomes.getInstance().getLogger().warning("Received a HuskHomes plugin message with an invalid server Cluster ID! \nPlease ensure that the cluster ID is set to a valid integer on all servers.");
            return;
        }
        if (HuskHomes.getSettings().getClusterId() != clusterID) {
            return;
        }
        String messageData = "";
        short messageLength = input.readShort();
        byte[] messageBytes = new byte[messageLength];
        input.readFully(messageBytes);
        DataInputStream messageIn = new DataInputStream(new ByteArrayInputStream(messageBytes));
        try {
            messageData = messageIn.readUTF();
        }
        catch (IOException e) {
            Bukkit.getLogger().warning("An error occurred trying to read a plugin message (" + e.getCause() + ")");
            e.printStackTrace();
        }
        CrossServerMessageHandler.handlePluginMessage(new PluginMessage(clusterID, player.getName(), messageType.split(":")[2], messageData), player);
    }
}

