/*
 * Decompiled with CFR 0.152.
 */
package me.william278.huskhomes2.data.message.redis;

import me.william278.huskhomes2.HuskHomes;
import me.william278.huskhomes2.data.message.Message;
import me.william278.huskhomes2.data.message.redis.RedisReceiver;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import redis.clients.jedis.Jedis;

public class RedisMessage
extends Message {
    public static final String REDIS_MESSAGE_HEADER_SEPARATOR = "\u00a3";
    private static final HuskHomes plugin = HuskHomes.getInstance();

    public RedisMessage(String targetPlayerName, Message.MessageType pluginMessageType, String ... messageData) {
        super(targetPlayerName, pluginMessageType, messageData);
    }

    public RedisMessage(Message.MessageType pluginMessageType, String ... messageData) {
        super(pluginMessageType, messageData);
    }

    public RedisMessage(int clusterId, String targetPlayerName, Message.MessageType pluginMessageType, String ... messageData) {
        super(clusterId, targetPlayerName, pluginMessageType, messageData);
    }

    private void dispatchRedisMessage(String target) {
        Runnable runnable = () -> {
            try (Jedis publisher = RedisReceiver.getJedis();){
                publisher.publish("HuskHomes", this.getClusterId() + ":" + this.getPluginMessageString(this.getMessageType()) + ":" + target + REDIS_MESSAGE_HEADER_SEPARATOR + this.getMessageData());
            }
        };
        if (Bukkit.isPrimaryThread()) {
            runnable.run();
        } else {
            Bukkit.getScheduler().runTask((Plugin)plugin, runnable);
        }
    }

    @Override
    public void send(Player sender) {
        this.dispatchRedisMessage(this.getTargetPlayerName());
    }

    @Override
    public void sendToAllServers(Player sender) {
        this.dispatchRedisMessage("-all-");
    }

    @Override
    public void sendToServer(Player sender, String server) {
        this.dispatchRedisMessage("server-" + server);
    }
}

