/*
 * Decompiled with CFR 0.152.
 */
package me.william278.huskhomes2.data.message.redis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.logging.Level;
import me.william278.huskhomes2.HuskHomes;
import me.william278.huskhomes2.data.message.CrossServerMessageHandler;
import me.william278.huskhomes2.data.message.Message;
import me.william278.huskhomes2.data.message.redis.RedisMessage;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisPubSub;

public class RedisReceiver {
    private static JedisPool jedisPool;
    private static final HuskHomes plugin;
    public static final String REDIS_CHANNEL = "HuskHomes";

    public static Jedis getJedis() {
        return jedisPool.getResource();
    }

    public static void initialize() {
        jedisPool = HuskHomes.getSettings().getRedisPassword().isEmpty() ? new JedisPool((GenericObjectPoolConfig)new JedisPoolConfig(), HuskHomes.getSettings().getRedisHost(), HuskHomes.getSettings().getRedisPort(), 0, HuskHomes.getSettings().getRedisSSL()) : new JedisPool((GenericObjectPoolConfig)new JedisPoolConfig(), HuskHomes.getSettings().getRedisHost(), HuskHomes.getSettings().getRedisPort(), 0, HuskHomes.getSettings().getRedisPassword(), HuskHomes.getSettings().getRedisSSL());
    }

    public static void terminate() {
        jedisPool.close();
    }

    private static Player getRandomReceiver() {
        ArrayList players = new ArrayList(Bukkit.getOnlinePlayers());
        if (players.isEmpty()) {
            return null;
        }
        Collections.shuffle(players);
        return (Player)players.get(0);
    }

    public static void listen() {
        new Thread(() -> {
            try (Jedis jedis = RedisReceiver.getJedis();){
                jedis.subscribe(new JedisPubSub(){

                    public void onMessage(String channel, String message) {
                        int clusterID;
                        if (!channel.equals(RedisReceiver.REDIS_CHANNEL)) {
                            return;
                        }
                        String[] splitMessage = message.split("\u00a3");
                        String messageHeader = splitMessage[0];
                        try {
                            clusterID = Integer.parseInt(messageHeader.split(":")[0]);
                        }
                        catch (Exception e) {
                            HuskHomes.getInstance().getLogger().warning("Received a Redis message on the HuskHomes channel with an invalid server Cluster ID! \nPlease ensure that the cluster ID is set to a valid integer on all servers.");
                            return;
                        }
                        if (HuskHomes.getSettings().getClusterId() != clusterID) {
                            return;
                        }
                        Message.MessageType messageType = Message.MessageType.valueOf(messageHeader.split(":")[1].toUpperCase(Locale.ENGLISH));
                        String target = messageHeader.split(":")[2];
                        plugin.getServer().getScheduler().runTask((Plugin)plugin, () -> {
                            Player receiver = Bukkit.getPlayerExact((String)target);
                            if (target.equalsIgnoreCase("-all-")) {
                                receiver = RedisReceiver.getRandomReceiver();
                            } else if (target.contains("server-")) {
                                if (target.split("-")[1].equalsIgnoreCase(HuskHomes.getSettings().getServerID())) {
                                    receiver = RedisReceiver.getRandomReceiver();
                                } else {
                                    return;
                                }
                            }
                            if (messageType.requiresPlayer() && (receiver == null || !receiver.isOnline())) {
                                return;
                            }
                            String messageData = splitMessage[1];
                            CrossServerMessageHandler.handlePluginMessage(new RedisMessage(clusterID, receiver != null ? receiver.getName() : null, messageType, messageData), receiver);
                        });
                    }
                }, new String[]{REDIS_CHANNEL});
            }
            catch (Exception e) {
                plugin.getLogger().log(Level.SEVERE, "An exception occurred in the Jedis subscriber", e);
            }
        }, "Redis Subscriber").start();
    }

    static {
        plugin = HuskHomes.getInstance();
    }
}

