/*
 * Decompiled with CFR 0.152.
 */
package me.william278.huskhomes2.data.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import me.william278.huskhomes2.HuskHomes;
import me.william278.huskhomes2.data.sql.Database;
import me.william278.huskhomes2.libraries.hikari.HikariDataSource;

public class MySQL
extends Database {
    static final String[] SQL_SETUP_STATEMENTS = new String[]{"CREATE TABLE IF NOT EXISTS " + HuskHomes.getSettings().getLocationsDataTable() + " (`location_id` integer AUTO_INCREMENT,`server` text NOT NULL,`world` text NOT NULL,`x` double NOT NULL,`y` double NOT NULL,`z` double NOT NULL,`yaw` float NOT NULL,`pitch` float NOT NULL,PRIMARY KEY (`location_id`));", "CREATE TABLE IF NOT EXISTS " + HuskHomes.getSettings().getPlayerDataTable() + " (`player_id` integer AUTO_INCREMENT,`user_uuid` char(36) NOT NULL UNIQUE,`username` varchar(16) NOT NULL,`home_slots` integer NOT NULL,`rtp_cooldown` integer NOT NULL DEFAULT 0,`is_teleporting` boolean NOT NULL DEFAULT 0,`dest_location_id` integer NULL,`last_location_id` integer NULL,`offline_location_id` integer NULL,`is_ignoring_requests` boolean NOT NULL DEFAULT 0,PRIMARY KEY (`player_id`),FOREIGN KEY (`offline_location_id`) REFERENCES " + HuskHomes.getSettings().getLocationsDataTable() + " (`location_id`) ON DELETE SET NULL ON UPDATE NO ACTION,FOREIGN KEY (`dest_location_id`) REFERENCES " + HuskHomes.getSettings().getLocationsDataTable() + " (`location_id`) ON DELETE SET NULL ON UPDATE NO ACTION,FOREIGN KEY (`last_location_id`) REFERENCES " + HuskHomes.getSettings().getLocationsDataTable() + " (`location_id`) ON DELETE SET NULL ON UPDATE NO ACTION);", "CREATE TABLE IF NOT EXISTS " + HuskHomes.getSettings().getHomesDataTable() + " (`player_id` integer NOT NULL,`location_id` integer NOT NULL,`name` varchar(16) NOT NULL,`description` varchar(255) NOT NULL,`public` boolean NOT NULL,`creation_time` timestamp NULL,PRIMARY KEY (`player_id`, `name`),FOREIGN KEY (`player_id`) REFERENCES " + HuskHomes.getSettings().getPlayerDataTable() + " (`player_id`) ON DELETE CASCADE ON UPDATE NO ACTION,FOREIGN KEY (`location_id`) REFERENCES " + HuskHomes.getSettings().getLocationsDataTable() + " (`location_id`) ON DELETE CASCADE ON UPDATE NO ACTION);", "CREATE TABLE IF NOT EXISTS " + HuskHomes.getSettings().getWarpsDataTable() + " (`location_id` integer NOT NULL,`name` varchar(16) NOT NULL UNIQUE,`description` varchar(255) NOT NULL,`creation_time` timestamp NULL,PRIMARY KEY (`location_id`),FOREIGN KEY (`location_id`) REFERENCES " + HuskHomes.getSettings().getLocationsDataTable() + " (`location_id`) ON DELETE CASCADE ON UPDATE NO ACTION);"};
    final String host = HuskHomes.getSettings().getMySQLHost();
    final int port = HuskHomes.getSettings().getMySQLPort();
    final String database = HuskHomes.getSettings().getMySQLDatabase();
    final String username = HuskHomes.getSettings().getMySQLUsername();
    final String password = HuskHomes.getSettings().getMySQLPassword();
    final String params = HuskHomes.getSettings().getMySQLParams();
    private HikariDataSource dataSource;

    public MySQL(HuskHomes instance) {
        super(instance);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    @Override
    public void load() {
        String jdbcUrl = "jdbc:mysql://" + this.host + ":" + this.port + "/" + this.database + this.params;
        this.dataSource = new HikariDataSource();
        this.dataSource.setJdbcUrl(jdbcUrl);
        this.dataSource.setUsername(this.username);
        this.dataSource.setPassword(this.password);
        this.dataSource.setMaximumPoolSize(this.hikariMaximumPoolSize);
        this.dataSource.setMinimumIdle(this.hikariMinimumIdle);
        this.dataSource.setMaxLifetime(this.hikariMaximumLifetime);
        this.dataSource.setKeepaliveTime(this.hikariKeepAliveTime);
        this.dataSource.setConnectionTimeout(this.hikariConnectionTimeOut);
        this.dataSource.setPoolName("HuskHomesHikariPool");
        try (Connection connection = this.dataSource.getConnection();
             Statement statement = connection.createStatement();){
            for (String tableCreationStatement : SQL_SETUP_STATEMENTS) {
                statement.execute(tableCreationStatement);
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "An error occurred creating tables on the MySQL database: ", e);
        }
    }

    @Override
    public void close() {
        if (this.dataSource != null) {
            this.dataSource.close();
        }
    }

    @Override
    public void backup() {
        this.plugin.getLogger().info("Remember to make backups of your HuskHomes Database before updating the plugin!");
    }
}

