/*
 * Decompiled with CFR 0.152.
 */
package me.william278.huskhomes2.data.sql;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.logging.Level;
import me.william278.huskhomes2.HuskHomes;
import me.william278.huskhomes2.data.sql.Database;
import me.william278.huskhomes2.libraries.hikari.HikariDataSource;

public class SQLite
extends Database {
    static final String[] SQL_SETUP_STATEMENTS = new String[]{"PRAGMA foreign_keys = ON;", "PRAGMA encoding = 'UTF-8';", "CREATE TABLE IF NOT EXISTS " + HuskHomes.getSettings().getLocationsDataTable() + " (`location_id` integer PRIMARY KEY,`server` text NOT NULL,`world` text NOT NULL,`x` double NOT NULL,`y` double NOT NULL,`z` double NOT NULL,`yaw` float NOT NULL,`pitch` float NOT NULL);", "CREATE TABLE IF NOT EXISTS " + HuskHomes.getSettings().getPlayerDataTable() + " (`player_id` integer NOT NULL,`user_uuid` char(36) NOT NULL UNIQUE,`username` varchar(16) NOT NULL,`home_slots` integer NOT NULL,`rtp_cooldown` integer NOT NULL DEFAULT 0,`is_teleporting` boolean NOT NULL DEFAULT 0,`dest_location_id` integer NULL,`last_location_id` integer NULL,`offline_location_id` integer NULL,`is_ignoring_requests` boolean NOT NULL DEFAULT 0,PRIMARY KEY (`player_id`),FOREIGN KEY (`offline_location_id`) REFERENCES " + HuskHomes.getSettings().getLocationsDataTable() + " (`location_id`) ON DELETE SET NULL ON UPDATE NO ACTION,FOREIGN KEY (`dest_location_id`) REFERENCES " + HuskHomes.getSettings().getLocationsDataTable() + " (`location_id`) ON DELETE SET NULL ON UPDATE NO ACTION,FOREIGN KEY (`last_location_id`) REFERENCES " + HuskHomes.getSettings().getLocationsDataTable() + " (`location_id`) ON DELETE SET NULL ON UPDATE NO ACTION);", "CREATE TABLE IF NOT EXISTS " + HuskHomes.getSettings().getHomesDataTable() + " (`player_id` integer NOT NULL,`location_id` integer NOT NULL,`name` varchar(16) NOT NULL,`description` varchar(255) NOT NULL,`public` boolean NOT NULL,`creation_time` timestamp NULL,PRIMARY KEY (`player_id`, `name`),FOREIGN KEY (`player_id`) REFERENCES " + HuskHomes.getSettings().getPlayerDataTable() + " (`player_id`) ON DELETE CASCADE ON UPDATE NO ACTION,FOREIGN KEY (`location_id`) REFERENCES " + HuskHomes.getSettings().getLocationsDataTable() + " (`location_id`) ON DELETE CASCADE ON UPDATE NO ACTION);", "CREATE TABLE IF NOT EXISTS " + HuskHomes.getSettings().getWarpsDataTable() + " (`location_id` integer NOT NULL,`name` varchar(16) NOT NULL UNIQUE,`description` varchar(255) NOT NULL,`creation_time` timestamp NULL,PRIMARY KEY (`location_id`),FOREIGN KEY (`location_id`) REFERENCES " + HuskHomes.getSettings().getLocationsDataTable() + " (`location_id`) ON DELETE CASCADE ON UPDATE NO ACTION);"};
    private static final String DATABASE_NAME = "HuskHomesData";
    private HikariDataSource dataSource;

    public SQLite(HuskHomes instance) {
        super(instance);
    }

    private void createDatabaseFileIfNotExist() {
        File databaseFile = new File(this.plugin.getDataFolder(), "HuskHomesData.db");
        if (!databaseFile.exists()) {
            try {
                if (!databaseFile.createNewFile()) {
                    this.plugin.getLogger().log(Level.SEVERE, "Failed to write new file: HuskHomesData.db (file already exists)");
                }
            }
            catch (IOException e) {
                this.plugin.getLogger().log(Level.SEVERE, "An error occurred writing a file: HuskHomesData.db (" + e.getCause() + ")");
            }
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    @Override
    public void load() {
        this.createDatabaseFileIfNotExist();
        String jdbcUrl = "jdbc:sqlite:" + this.plugin.getDataFolder().getAbsolutePath() + "/HuskHomesData.db";
        this.dataSource = new HikariDataSource();
        this.dataSource.setJdbcUrl(jdbcUrl);
        this.dataSource.setMaximumPoolSize(this.hikariMaximumPoolSize);
        this.dataSource.setMinimumIdle(this.hikariMinimumIdle);
        this.dataSource.setMaxLifetime(this.hikariMaximumLifetime);
        this.dataSource.setKeepaliveTime(this.hikariKeepAliveTime);
        this.dataSource.setConnectionTimeout(this.hikariConnectionTimeOut);
        this.dataSource.setPoolName("HuskHomesHikariPool");
        try (Connection connection = this.dataSource.getConnection();
             Statement statement = connection.createStatement();){
            for (String tableCreationStatement : SQL_SETUP_STATEMENTS) {
                statement.execute(tableCreationStatement);
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "An error occurred creating tables on the SQLite database: ", e);
        }
    }

    @Override
    public void close() {
        if (this.dataSource != null) {
            this.dataSource.close();
        }
    }

    @Override
    public void backup() {
        String BACKUPS_FOLDER_NAME = "database-backups";
        String backupFileName = "HuskHomesDataBackup_" + DateTimeFormatter.ofPattern("yyyy-MM-dd_HH-mm-ss-SS").withLocale(Locale.getDefault()).withZone(ZoneId.systemDefault()).format(Instant.now()).replaceAll(" ", "-") + ".db";
        File databaseFile = new File(this.plugin.getDataFolder(), "HuskHomesData.db");
        if (new File(this.plugin.getDataFolder(), "database-backups").mkdirs()) {
            this.plugin.getLogger().info("Created backups directory in HuskHomes plugin data folder.");
        }
        File backUpFile = new File(this.plugin.getDataFolder(), "database-backups" + File.separator + backupFileName);
        try {
            Files.copy(databaseFile.toPath(), backUpFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            this.plugin.getLogger().info("Created a backup of your database.");
        }
        catch (IOException iox) {
            this.plugin.getLogger().log(Level.WARNING, "An error occurred making a database backup", iox);
        }
    }
}

