/*
 * Decompiled with CFR 0.152.
 */
package me.william278.huskhomes2.integrations;

import de.themoep.connectorplugin.LocationInfo;
import de.themoep.connectorplugin.bukkit.BukkitConnectorPlugin;
import java.util.function.Consumer;
import me.william278.huskhomes2.HuskHomes;
import me.william278.huskhomes2.teleport.points.TeleportationPoint;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ConnectorPluginIntegration {
    private static final HuskHomes plugin = HuskHomes.getInstance();
    private static BukkitConnectorPlugin connectorPlugin;

    public static void teleportPlayer(Player player, TeleportationPoint point) {
        connectorPlugin.getBridge().teleport(player.getName(), ConnectorPluginIntegration.getLocationInfoFromTeleportationPoint(point), new Consumer[]{executed -> plugin.getLogger().info("Teleported " + player.getName() + " successfully")}).thenAccept(success -> {
            if (!success.booleanValue()) {
                plugin.getLogger().warning("Failed to teleport " + player.getName());
            }
            HuskHomes.setNotTeleporting(player.getUniqueId());
        });
    }

    public static LocationInfo getLocationInfoFromTeleportationPoint(TeleportationPoint point) {
        return new LocationInfo(point.getServer(), point.getWorldName(), point.getX(), point.getY(), point.getZ(), point.getYaw(), point.getPitch());
    }

    public static boolean initializeConnectorPlugin() {
        Plugin plugin = Bukkit.getPluginManager().getPlugin("ConnectorPlugin");
        if (plugin == null) {
            return false;
        }
        if (!plugin.isEnabled()) {
            return false;
        }
        connectorPlugin = (BukkitConnectorPlugin)plugin;
        return true;
    }
}

