/*
 * Decompiled with CFR 0.152.
 */
package me.william278.huskhomes2.integrations.map;

import de.bluecolored.bluemap.api.BlueMapAPI;
import de.bluecolored.bluemap.api.BlueMapMap;
import de.bluecolored.bluemap.api.marker.MarkerAPI;
import de.bluecolored.bluemap.api.marker.MarkerSet;
import de.bluecolored.bluemap.api.marker.POIMarker;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.logging.Level;
import me.william278.huskhomes2.HuskHomes;
import me.william278.huskhomes2.data.DataManager;
import me.william278.huskhomes2.integrations.map.Map;
import me.william278.huskhomes2.teleport.points.Home;
import me.william278.huskhomes2.teleport.points.Warp;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;

public class BlueMap
extends Map {
    private static final HuskHomes plugin = HuskHomes.getInstance();
    private static final HashMap<String, Boolean> queuedWarps = new HashMap();
    private static final HashMap<String, Boolean> queuedPublicHomes = new HashMap();
    private static String warpMarkerImageAddress;
    private static String publicHomeMarkerImageAddress;

    private void executeQueuedOperations() {
        try (Connection connection = HuskHomes.getConnection();){
            boolean add;
            for (String warpName : queuedWarps.keySet()) {
                add = queuedWarps.get(warpName);
                if (add) {
                    Warp warpToAdd = DataManager.getWarp(warpName, connection);
                    if (warpToAdd == null) continue;
                    this.addWarpMarker(warpToAdd);
                    continue;
                }
                this.removeWarpMarker(warpName);
            }
            for (String fullHomeName : queuedPublicHomes.keySet()) {
                add = queuedPublicHomes.get(fullHomeName);
                String ownerName = fullHomeName.split("\\.")[0];
                String homeName = fullHomeName.split("\\.")[1];
                if (add) {
                    Home homeToAdd = DataManager.getHome(ownerName, homeName, connection);
                    if (homeToAdd == null) continue;
                    this.addPublicHomeMarker(homeToAdd);
                    continue;
                }
                this.removePublicHomeMarker(homeName, ownerName);
            }
        }
        catch (SQLException e) {
            plugin.getLogger().log(Level.WARNING, "An SQL exception occurred retrieving warp and home data when updating the BlueMap.", e);
        }
    }

    @Override
    public void addWarpMarker(Warp warp) {
        World world = warp.getLocation().getWorld();
        if (world == null) {
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> BlueMapAPI.getInstance().ifPresentOrElse(api -> {
            try {
                MarkerAPI markerAPI = api.getMarkerAPI();
                markerAPI.getMarkerSet("huskhomes.warps").ifPresent(markerSet -> api.getWorld(world.getUID()).ifPresent(blueMapWorld -> {
                    String markerId = this.getWarpMarkerName(warp.getName());
                    for (BlueMapMap map : blueMapWorld.getMaps()) {
                        POIMarker marker = markerSet.createPOIMarker(markerId, map, warp.getX(), warp.getY(), warp.getZ());
                        marker.setLabel(this.getWarpInfoMenu(warp));
                        if (warpMarkerImageAddress == null) continue;
                        marker.setIcon(warpMarkerImageAddress, marker.getAnchor());
                    }
                    try {
                        markerAPI.save();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }, () -> queuedWarps.put(warp.getName(), true)));
    }

    @Override
    public void removeWarpMarker(String warpName) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> BlueMapAPI.getInstance().ifPresentOrElse(api -> {
            try {
                MarkerAPI markerAPI = api.getMarkerAPI();
                markerAPI.getMarkerSet("huskhomes.warps").ifPresent(markerSet -> {
                    String markerId = this.getWarpMarkerName(warpName);
                    markerSet.removeMarker(markerId);
                    try {
                        markerAPI.save();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                });
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }, () -> queuedWarps.put(warpName, false)));
    }

    @Override
    public void addPublicHomeMarker(Home home) {
        World world = home.getLocation().getWorld();
        if (world == null) {
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> BlueMapAPI.getInstance().ifPresentOrElse(api -> {
            try {
                MarkerAPI markerAPI = api.getMarkerAPI();
                markerAPI.getMarkerSet("huskhomes.public_homes").ifPresent(markerSet -> api.getWorld(world.getUID()).ifPresent(blueMapWorld -> {
                    String markerId = this.getPublicHomeMarkerName(home.getOwnerUsername(), home.getName());
                    for (BlueMapMap map : blueMapWorld.getMaps()) {
                        POIMarker marker = markerSet.createPOIMarker(markerId, map, home.getX(), home.getY(), home.getZ());
                        marker.setLabel(this.getPublicHomeInfoMenu(home));
                        if (publicHomeMarkerImageAddress == null) continue;
                        marker.setIcon(publicHomeMarkerImageAddress, marker.getAnchor());
                    }
                    try {
                        markerAPI.save();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }, () -> queuedPublicHomes.put(home.getOwnerUsername() + "." + home.getName(), true)));
    }

    @Override
    public void removePublicHomeMarker(String homeName, String ownerName) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> BlueMapAPI.getInstance().ifPresentOrElse(api -> {
            try {
                MarkerAPI markerAPI = api.getMarkerAPI();
                markerAPI.getMarkerSet("huskhomes.public_homes").ifPresent(markerSet -> {
                    String markerId = this.getPublicHomeMarkerName(ownerName, homeName);
                    markerSet.removeMarker(markerId);
                    try {
                        markerAPI.save();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                });
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }, () -> queuedPublicHomes.put(ownerName + "." + homeName, false)));
    }

    @Override
    public void initialize() {
        plugin.getLogger().info("Initializing BlueMap integration");
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            try (Connection connection = HuskHomes.getConnection();){
                for (Home home : DataManager.getPublicHomes(connection)) {
                    if (HuskHomes.getSettings().doBungee() && !home.getServer().equals(HuskHomes.getSettings().getServerID())) continue;
                    this.addPublicHomeMarker(home);
                }
                for (Warp warp : DataManager.getWarps(connection)) {
                    if (HuskHomes.getSettings().doBungee() && !warp.getServer().equals(HuskHomes.getSettings().getServerID())) continue;
                    this.addWarpMarker(warp);
                }
            }
            catch (SQLException e) {
                plugin.getLogger().log(Level.WARNING, "An SQL exception occurred initialising homes and warps onto the BlueMap");
            }
            BlueMapAPI.onEnable(api -> {
                try {
                    publicHomeMarkerImageAddress = api.createImage(this.getPublicHomeIcon(), "huskhomes/public_home");
                    warpMarkerImageAddress = api.createImage(this.getWarpIcon(), "huskhomes/warp");
                    MarkerAPI markerAPI = api.getMarkerAPI();
                    MarkerSet publicHomeMarkerSet = markerAPI.getMarkerSet("huskhomes.public_homes").orElse(markerAPI.createMarkerSet("huskhomes.public_homes"));
                    publicHomeMarkerSet.setLabel(HuskHomes.getSettings().getMapPublicHomeMarkerSet());
                    MarkerSet warpsMarkerSet = markerAPI.getMarkerSet("huskhomes.warps").orElse(markerAPI.createMarkerSet("huskhomes.warps"));
                    warpsMarkerSet.setLabel(HuskHomes.getSettings().getMapWarpMarkerSet());
                    markerAPI.save();
                    plugin.getLogger().info("Enabled BlueMap integration!");
                    this.executeQueuedOperations();
                }
                catch (IOException e) {
                    plugin.getLogger().warning("An exception occurred initialising BlueMap.");
                }
            });
        });
    }
}

