/*
 * Decompiled with CFR 0.152.
 */
package me.william278.huskhomes2.integrations.map;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.logging.Level;
import me.william278.huskhomes2.HuskHomes;
import me.william278.huskhomes2.data.DataManager;
import me.william278.huskhomes2.integrations.map.Map;
import me.william278.huskhomes2.teleport.points.Home;
import me.william278.huskhomes2.teleport.points.Warp;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.plugin.Plugin;
import xyz.jpenilla.squaremap.api.BukkitAdapter;
import xyz.jpenilla.squaremap.api.Key;
import xyz.jpenilla.squaremap.api.MapWorld;
import xyz.jpenilla.squaremap.api.Point;
import xyz.jpenilla.squaremap.api.SimpleLayerProvider;
import xyz.jpenilla.squaremap.api.Squaremap;
import xyz.jpenilla.squaremap.api.SquaremapProvider;
import xyz.jpenilla.squaremap.api.marker.Icon;
import xyz.jpenilla.squaremap.api.marker.Marker;
import xyz.jpenilla.squaremap.api.marker.MarkerOptions;

public class SquareMap
extends Map {
    private final HashMap<String, SimpleLayerProvider> publicHomeProviders = new HashMap();
    private final HashMap<String, SimpleLayerProvider> warpProviders = new HashMap();
    private static final int MARKER_SIZE = 20;
    private static final HuskHomes plugin = HuskHomes.getInstance();

    @Override
    public void addWarpMarker(Warp warp) {
        World world = Bukkit.getWorld((String)warp.getWorldName());
        if (world != null && this.warpProviders.containsKey(world.getName())) {
            Icon marker = Marker.icon((Point)Point.of((double)warp.getX(), (double)warp.getZ()), (Key)Key.of((String)"warp"), (int)20);
            marker.markerOptions(MarkerOptions.builder().hoverTooltip(warp.getName()).clickTooltip(this.getWarpInfoMenu(warp)).build());
            this.warpProviders.get(world.getName()).addMarker(Key.of((String)this.getWarpMarkerName(warp.getName())), (Marker)marker);
        }
    }

    @Override
    public void removeWarpMarker(String warpName) {
        Key warpMarkerKey = Key.of((String)this.getWarpMarkerName(warpName));
        this.removeMarker(warpMarkerKey, this.warpProviders);
    }

    @Override
    public void addPublicHomeMarker(Home home) {
        World world = Bukkit.getWorld((String)home.getWorldName());
        if (world != null && this.publicHomeProviders.containsKey(world.getName())) {
            Icon marker = Marker.icon((Point)Point.of((double)home.getX(), (double)home.getZ()), (Key)Key.of((String)"public_home"), (int)20);
            marker.markerOptions(MarkerOptions.builder().hoverTooltip(home.getName()).clickTooltip(this.getPublicHomeInfoMenu(home)).build());
            this.publicHomeProviders.get(world.getName()).addMarker(Key.of((String)this.getPublicHomeMarkerName(home.getOwnerUsername(), home.getName())), (Marker)marker);
        }
    }

    @Override
    public void removePublicHomeMarker(String homeName, String ownerName) {
        Key publicHomeMarkerKey = Key.of((String)this.getPublicHomeMarkerName(ownerName, homeName));
        this.removeMarker(publicHomeMarkerKey, this.publicHomeProviders);
    }

    @Override
    public void initialize() {
        Squaremap mapAPI = SquaremapProvider.get();
        plugin.getServer().getPluginManager().registerEvents((Listener)new SquareMapWorldLoadListener(), (Plugin)plugin);
        plugin.getLogger().info("Initializing Squaremap integration");
        Key publicHomeMarkerIconKey = Key.of((String)"public_home");
        Key warpMarkerIconKey = Key.of((String)"warp");
        if (SquaremapProvider.get().iconRegistry().hasEntry(publicHomeMarkerIconKey)) {
            SquaremapProvider.get().iconRegistry().unregister(publicHomeMarkerIconKey);
        }
        SquaremapProvider.get().iconRegistry().register(publicHomeMarkerIconKey, (Object)this.getPublicHomeIcon());
        if (SquaremapProvider.get().iconRegistry().hasEntry(warpMarkerIconKey)) {
            SquaremapProvider.get().iconRegistry().unregister(warpMarkerIconKey);
        }
        SquaremapProvider.get().iconRegistry().register(warpMarkerIconKey, (Object)this.getWarpIcon());
        for (MapWorld world : mapAPI.mapWorlds()) {
            this.loadWorld(world);
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            try (Connection connection = HuskHomes.getConnection();){
                if (HuskHomes.getSettings().showPublicHomesOnMap()) {
                    for (Home home : DataManager.getPublicHomes(connection)) {
                        if (HuskHomes.getSettings().doBungee() && !home.getServer().equals(HuskHomes.getSettings().getServerID())) continue;
                        Bukkit.getScheduler().runTask((Plugin)plugin, () -> this.addPublicHomeMarker(home));
                    }
                }
                if (HuskHomes.getSettings().showWarpsOnMap()) {
                    for (Warp warp : DataManager.getWarps(connection)) {
                        if (HuskHomes.getSettings().doBungee() && !warp.getServer().equals(HuskHomes.getSettings().getServerID())) continue;
                        Bukkit.getScheduler().runTask((Plugin)plugin, () -> this.addWarpMarker(warp));
                    }
                }
            }
            catch (SQLException e) {
                plugin.getLogger().log(Level.WARNING, "An SQL exception occurred adding homes and warps to the Squaremap");
            }
        });
    }

    private void removeMarker(Key markerKey, HashMap<String, SimpleLayerProvider> layerProviders) {
        String markerWorld = null;
        for (String worldName : layerProviders.keySet()) {
            SimpleLayerProvider warpProvider = layerProviders.get(worldName);
            if (!warpProvider.hasMarker(markerKey)) continue;
            markerWorld = worldName;
            break;
        }
        if (markerWorld != null) {
            layerProviders.get(markerWorld).removeMarker(markerKey);
        }
    }

    private void loadWorld(MapWorld world) {
        SimpleLayerProvider publicHomeProvider = SimpleLayerProvider.builder((String)HuskHomes.getSettings().getMapPublicHomeMarkerSet()).showControls(true).defaultHidden(false).layerPriority(6).zIndex(250).build();
        world.layerRegistry().register(Key.of((String)"huskhomes.public_homes"), (Object)publicHomeProvider);
        this.publicHomeProviders.put(BukkitAdapter.bukkitWorld((MapWorld)world).getName(), publicHomeProvider);
        SimpleLayerProvider warpProvider = SimpleLayerProvider.builder((String)HuskHomes.getSettings().getMapWarpMarkerSet()).showControls(true).defaultHidden(false).layerPriority(7).zIndex(250).build();
        world.layerRegistry().register(Key.of((String)"huskhomes.warps"), (Object)warpProvider);
        this.warpProviders.put(BukkitAdapter.bukkitWorld((MapWorld)world).getName(), warpProvider);
    }

    public class SquareMapWorldLoadListener
    implements Listener {
        @EventHandler
        public void onWorldLoad(WorldLoadEvent e) {
            Squaremap mapAPI = SquaremapProvider.get();
            mapAPI.getWorldIfEnabled(BukkitAdapter.worldIdentifier((World)e.getWorld())).ifPresent(SquareMap.this::loadWorld);
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
                try (Connection connection = HuskHomes.getConnection();){
                    if (HuskHomes.getSettings().showPublicHomesOnMap()) {
                        for (Home home : DataManager.getPublicHomes(connection)) {
                            if (!home.getWorldName().equals(e.getWorld().getName()) || HuskHomes.getSettings().doBungee() && !home.getServer().equals(HuskHomes.getSettings().getServerID())) continue;
                            Bukkit.getScheduler().runTask((Plugin)plugin, () -> SquareMap.this.addPublicHomeMarker(home));
                        }
                    }
                    if (HuskHomes.getSettings().showWarpsOnMap()) {
                        for (Warp warp : DataManager.getWarps(connection)) {
                            if (!warp.getWorldName().equals(e.getWorld().getName()) || HuskHomes.getSettings().doBungee() && !warp.getServer().equals(HuskHomes.getSettings().getServerID())) continue;
                            Bukkit.getScheduler().runTask((Plugin)plugin, () -> SquareMap.this.addWarpMarker(warp));
                        }
                    }
                }
                catch (SQLException exception) {
                    plugin.getLogger().log(Level.WARNING, "An SQL exception occurred adding homes and warps to the Squaremap");
                }
            });
        }
    }
}

