/*
 * Decompiled with CFR 0.152.
 */
package me.william278.huskhomes2.teleport;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import me.william278.huskhomes2.HuskHomes;
import me.william278.huskhomes2.api.events.PlayerDeleteHomeEvent;
import me.william278.huskhomes2.api.events.PlayerDeleteWarpEvent;
import me.william278.huskhomes2.api.events.PlayerSetHomeEvent;
import me.william278.huskhomes2.api.events.PlayerSetWarpEvent;
import me.william278.huskhomes2.commands.HomeCommand;
import me.william278.huskhomes2.commands.PublicHomeCommand;
import me.william278.huskhomes2.commands.WarpCommand;
import me.william278.huskhomes2.data.DataManager;
import me.william278.huskhomes2.integrations.VaultIntegration;
import me.william278.huskhomes2.teleport.TeleportManager;
import me.william278.huskhomes2.teleport.points.Home;
import me.william278.huskhomes2.teleport.points.TeleportationPoint;
import me.william278.huskhomes2.teleport.points.Warp;
import me.william278.huskhomes2.util.MessageManager;
import me.william278.huskhomes2.util.RegexUtil;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class SettingHandler {
    private static final HuskHomes plugin = HuskHomes.getInstance();

    public static void setHome(Location location, Player player, String name) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            try (Connection connection = HuskHomes.getConnection();){
                SetHomeConditions setHomeConditions = new SetHomeConditions(player, name, connection);
                if (setHomeConditions.areConditionsMet()) {
                    Home home = new Home(location, HuskHomes.getSettings().getServerID(), player, name, false);
                    Bukkit.getScheduler().runTask((Plugin)plugin, () -> {
                        PlayerSetHomeEvent event = new PlayerSetHomeEvent(player, home);
                        Bukkit.getPluginManager().callEvent((Event)event);
                        if (event.isCancelled()) {
                            return;
                        }
                        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
                            try (Connection connection1 = HuskHomes.getConnection();){
                                DataManager.addHome(home, player, connection1);
                                MessageManager.sendMessage(player, "set_home_success", name);
                                HomeCommand.Tab.updatePlayerHomeCache(player);
                            }
                            catch (SQLException e) {
                                plugin.getLogger().log(Level.SEVERE, "An SQL exception occurred!", e);
                            }
                        });
                    });
                    return;
                }
                switch (setHomeConditions.getConditionsNotMetReason()) {
                    case "error_set_home_maximum_homes": {
                        MessageManager.sendMessage(player, "error_set_home_maximum_homes", Integer.toString(Home.getSetHomeLimit(player)));
                        return;
                    }
                    case "error_insufficient_funds": {
                        MessageManager.sendMessage(player, "error_insufficient_funds", VaultIntegration.format(HuskHomes.getSettings().getSetHomeCost()));
                        return;
                    }
                    default: {
                        MessageManager.sendMessage(player, setHomeConditions.getConditionsNotMetReason());
                        return;
                    }
                }
            }
            catch (SQLException e) {
                plugin.getLogger().log(Level.SEVERE, "An SQL exception occurred!", e);
            }
        });
    }

    public static void updateCrossServerSpawnWarp(Player p) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            try (Connection connection = HuskHomes.getConnection();){
                if (SettingHandler.setCrossServerSpawnWarp(p.getLocation(), p, connection)) {
                    SettingHandler.setSpawnLocation(p.getLocation());
                    p.getWorld().setSpawnLocation(p.getLocation());
                    MessageManager.sendMessage(p, "set_spawn_success");
                }
            }
            catch (SQLException e) {
                plugin.getLogger().log(Level.SEVERE, "An SQL exception occurred!", e);
            }
        });
    }

    public static boolean setCrossServerSpawnWarp(Location location, Player player, Connection connection) throws SQLException {
        SetWarpConditions setWarpConditions;
        String spawnWarpName = HuskHomes.getSettings().getSpawnWarpName();
        if (DataManager.warpExists(spawnWarpName, connection)) {
            DataManager.deleteWarp(spawnWarpName, connection);
            if (HuskHomes.getSettings().doMapIntegration() && HuskHomes.getSettings().showWarpsOnMap()) {
                HuskHomes.getMap().removeWarpMarker(spawnWarpName);
            }
        }
        if ((setWarpConditions = new SetWarpConditions(spawnWarpName, connection)).areConditionsMet()) {
            Warp spawnWarp = new Warp(location, HuskHomes.getSettings().getServerID(), spawnWarpName);
            spawnWarp.setDescription(MessageManager.getRawMessage("spawn_warp_default_description"));
            DataManager.addWarp(spawnWarp, connection);
            if (HuskHomes.getSettings().doMapIntegration() && HuskHomes.getSettings().showWarpsOnMap()) {
                HuskHomes.getMap().addWarpMarker(spawnWarp);
            }
        } else {
            MessageManager.sendMessage(player, setWarpConditions.getConditionsNotMetReason());
            return false;
        }
        WarpCommand.Tab.updateWarpsTabCache();
        return true;
    }

    public static void setWarp(Location location, Player player, String name) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            try (Connection connection = HuskHomes.getConnection();){
                SetWarpConditions setWarpConditions = new SetWarpConditions(name, connection);
                if (setWarpConditions.areConditionsMet()) {
                    Warp warp = new Warp(location, HuskHomes.getSettings().getServerID(), name);
                    Bukkit.getScheduler().runTask((Plugin)plugin, () -> {
                        PlayerSetWarpEvent event = new PlayerSetWarpEvent(player, warp);
                        Bukkit.getPluginManager().callEvent((Event)event);
                        if (event.isCancelled()) {
                            return;
                        }
                        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
                            try (Connection connection1 = HuskHomes.getConnection();){
                                DataManager.addWarp(warp, connection1);
                                MessageManager.sendMessage(player, "set_warp_success", name);
                                if (HuskHomes.getSettings().doMapIntegration() && HuskHomes.getSettings().showWarpsOnMap()) {
                                    HuskHomes.getMap().addWarpMarker(warp);
                                }
                                WarpCommand.Tab.updateWarpsTabCache();
                            }
                            catch (SQLException e) {
                                plugin.getLogger().log(Level.SEVERE, "An SQL exception occurred!", e);
                            }
                        });
                    });
                } else {
                    MessageManager.sendMessage(player, setWarpConditions.getConditionsNotMetReason());
                }
            }
            catch (SQLException e) {
                plugin.getLogger().log(Level.SEVERE, "An SQL exception occurred!", e);
            }
        });
    }

    public static void deleteAllHomes(Player player) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            try (Connection connection = HuskHomes.getConnection();){
                int homesDeleted = 0;
                for (Home home : DataManager.getPlayerHomes(player.getName(), connection)) {
                    if (home != null) {
                        Bukkit.getScheduler().runTask((Plugin)plugin, () -> {
                            PlayerDeleteHomeEvent event = new PlayerDeleteHomeEvent(player, home);
                            Bukkit.getPluginManager().callEvent((Event)event);
                            if (!event.isCancelled()) {
                                Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
                                    try (Connection connection1 = HuskHomes.getConnection();){
                                        SettingHandler.deleteHomeData(player, home, connection1);
                                    }
                                    catch (SQLException e) {
                                        plugin.getLogger().log(Level.SEVERE, "An SQL exception occurred!", e);
                                    }
                                });
                            }
                        });
                    }
                    ++homesDeleted;
                }
                if (homesDeleted == 0) {
                    MessageManager.sendMessage(player, "error_no_homes_set");
                    return;
                }
                HomeCommand.Tab.updatePlayerHomeCache(player);
                MessageManager.sendMessage(player, "delete_all_homes_success", Integer.toString(homesDeleted));
            }
            catch (SQLException e) {
                plugin.getLogger().log(Level.SEVERE, "An SQL exception occurred!", e);
            }
        });
    }

    public static void deleteHome(Player player, String homeName) {
        SettingHandler.deleteHome(player, player.getName(), homeName);
    }

    public static void deleteHome(Player player, String ownerName, String homeName) {
        if (!ownerName.equalsIgnoreCase(player.getName()) && !player.hasPermission("huskhomes.delhome.other")) {
            MessageManager.sendMessage(player, "error_no_permission");
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            try (Connection connection = HuskHomes.getConnection();){
                if (DataManager.homeExists(ownerName, homeName, connection).booleanValue()) {
                    Home home = DataManager.getHome(ownerName, homeName, connection);
                    if (home != null) {
                        Bukkit.getScheduler().runTask((Plugin)plugin, () -> {
                            PlayerDeleteHomeEvent event = new PlayerDeleteHomeEvent(player, home);
                            Bukkit.getPluginManager().callEvent((Event)event);
                            if (!event.isCancelled()) {
                                Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
                                    try (Connection connection1 = HuskHomes.getConnection();){
                                        SettingHandler.deleteHomeData(player, home, connection1);
                                        if (home.getOwnerUsername().equalsIgnoreCase(player.getName())) {
                                            HomeCommand.Tab.updatePlayerHomeCache(player);
                                            MessageManager.sendMessage(player, "home_deleted", homeName);
                                        } else {
                                            Player homeOwner = Bukkit.getPlayerExact((String)ownerName);
                                            if (homeOwner != null) {
                                                HomeCommand.Tab.updatePlayerHomeCache(homeOwner);
                                            }
                                            MessageManager.sendMessage(player, "home_deleted_other", ownerName, homeName);
                                        }
                                    }
                                    catch (SQLException e) {
                                        plugin.getLogger().log(Level.SEVERE, "An SQL exception occurred!", e);
                                    }
                                });
                            }
                        });
                    } else if (!ownerName.equalsIgnoreCase(player.getName())) {
                        MessageManager.sendMessage(player, "error_home_invalid_other", ownerName, homeName);
                    } else {
                        MessageManager.sendMessage(player, "error_home_invalid", homeName);
                    }
                } else {
                    if (homeName.equalsIgnoreCase("all")) {
                        if (!player.hasPermission("huskhomes.delhome.all")) {
                            MessageManager.sendMessage(player, "error_no_permission");
                            return;
                        }
                        if (DataManager.getPlayerHomes(ownerName, connection).size() == 0) {
                            MessageManager.sendMessage(player, "error_no_homes_set");
                            return;
                        }
                        MessageManager.sendMessage(player, "delete_all_homes_confirm");
                        return;
                    }
                    MessageManager.sendMessage(player, "error_home_invalid", homeName);
                }
            }
            catch (SQLException e) {
                plugin.getLogger().log(Level.SEVERE, "An SQL exception occurred!", e);
            }
        });
    }

    private static void deleteHomeData(Player player, Home home, Connection connection) throws SQLException {
        if (home.isPublic()) {
            if (HuskHomes.getSettings().doMapIntegration() && HuskHomes.getSettings().showPublicHomesOnMap()) {
                HuskHomes.getMap().removePublicHomeMarker(home.getName(), home.getOwnerUsername());
            }
            DataManager.deleteHome(player, home.getOwnerUsername(), home.getName(), connection);
            PublicHomeCommand.updatePublicHomeTabCache();
        } else {
            DataManager.deleteHome(player, home.getOwnerUsername(), home.getName(), connection);
        }
    }

    public static void deleteAllWarps(Player player) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            try (Connection connection = HuskHomes.getConnection();){
                int warpsDeleted = 0;
                for (Warp warp : DataManager.getWarps(connection)) {
                    if (warp != null) {
                        String warpName = warp.getName();
                        Bukkit.getScheduler().runTask((Plugin)plugin, () -> {
                            PlayerDeleteWarpEvent event = new PlayerDeleteWarpEvent(player, warp);
                            Bukkit.getPluginManager().callEvent((Event)event);
                            if (!event.isCancelled()) {
                                Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
                                    try (Connection connection1 = HuskHomes.getConnection();){
                                        DataManager.deleteWarp(warpName, connection1);
                                        if (HuskHomes.getSettings().doMapIntegration() && HuskHomes.getSettings().showWarpsOnMap()) {
                                            HuskHomes.getMap().removeWarpMarker(warpName);
                                        }
                                    }
                                    catch (SQLException e) {
                                        plugin.getLogger().log(Level.SEVERE, "An SQL exception occurred!", e);
                                    }
                                });
                            }
                        });
                        WarpCommand.Tab.updateWarpsTabCache();
                    }
                    ++warpsDeleted;
                }
                if (warpsDeleted == 0) {
                    MessageManager.sendMessage(player, "error_no_warps_set");
                    return;
                }
                HomeCommand.Tab.updatePlayerHomeCache(player);
                MessageManager.sendMessage(player, "delete_all_warps_success", Integer.toString(warpsDeleted));
            }
            catch (SQLException e) {
                plugin.getLogger().log(Level.SEVERE, "An SQL exception occurred!", e);
            }
        });
    }

    public static void deleteWarp(Player player, String warpName) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            try (Connection connection = HuskHomes.getConnection();){
                if (DataManager.warpExists(warpName, connection)) {
                    Warp warp = DataManager.getWarp(warpName, connection);
                    Bukkit.getScheduler().runTask((Plugin)plugin, () -> {
                        PlayerDeleteWarpEvent event = new PlayerDeleteWarpEvent(player, warp);
                        Bukkit.getPluginManager().callEvent((Event)event);
                        if (!event.isCancelled()) {
                            Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
                                try (Connection connection1 = HuskHomes.getConnection();){
                                    DataManager.deleteWarp(warpName, connection1);
                                    MessageManager.sendMessage(player, "warp_deleted", warpName);
                                    if (HuskHomes.getSettings().doMapIntegration() && HuskHomes.getSettings().showWarpsOnMap()) {
                                        HuskHomes.getMap().removeWarpMarker(warpName);
                                    }
                                    WarpCommand.Tab.updateWarpsTabCache();
                                }
                                catch (SQLException e) {
                                    plugin.getLogger().log(Level.SEVERE, "An SQL exception occurred!", e);
                                }
                            });
                        }
                    });
                } else {
                    if (warpName.equalsIgnoreCase("all")) {
                        if (!player.hasPermission("huskhomes.delwarp.all")) {
                            MessageManager.sendMessage(player, "error_no_permission");
                            return;
                        }
                        if (DataManager.getWarps(connection).size() == 0) {
                            MessageManager.sendMessage(player, "error_no_warps_set");
                            return;
                        }
                        MessageManager.sendMessage(player, "delete_all_warps_confirm");
                        return;
                    }
                    MessageManager.sendMessage(player, "error_warp_invalid", warpName);
                }
            }
            catch (SQLException e) {
                plugin.getLogger().log(Level.SEVERE, "An SQL exception occurred!", e);
            }
        });
    }

    public static void setSpawnLocation(Location location) {
        if (location.getWorld() == null) {
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            FileConfiguration config = plugin.getConfig();
            config.set("spawn_command.position.world", (Object)location.getWorld().getName());
            config.set("spawn_command.position.x", (Object)location.getX());
            config.set("spawn_command.position.y", (Object)location.getY());
            config.set("spawn_command.position.z", (Object)location.getZ());
            config.set("spawn_command.position.yaw", (Object)location.getYaw());
            config.set("spawn_command.position.pitch", (Object)location.getPitch());
            plugin.saveConfig();
            TeleportManager.setSpawnLocation(new TeleportationPoint(location, HuskHomes.getSettings().getServerID()));
        });
    }

    public static void fetchSpawnLocation() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> TeleportManager.setSpawnLocation(SettingHandler.getSpawnLocation()));
    }

    private static TeleportationPoint getSpawnLocation() {
        String server = HuskHomes.getSettings().getServerID();
        try {
            FileConfiguration config = plugin.getConfig();
            String worldName = config.getString("spawn_command.position.world");
            if (worldName == null || worldName.equals("")) {
                return null;
            }
            double x = config.getDouble("spawn_command.position.x");
            double y = config.getDouble("spawn_command.position.y");
            double z = config.getDouble("spawn_command.position.z");
            float yaw = (float)config.getDouble("spawn_command.position.yaw");
            float pitch = (float)config.getDouble("spawn_command.position.pitch");
            return new TeleportationPoint(worldName, x, y, z, yaw, pitch, server);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static class SetWarpConditions {
        private boolean conditionsMet = false;
        private String conditionsNotMetReason;

        public SetWarpConditions(String warpName, Connection connection) throws SQLException {
            if (DataManager.warpExists(warpName, connection)) {
                this.conditionsNotMetReason = "error_set_warp_name_taken";
                return;
            }
            if (warpName.length() > 16) {
                this.conditionsNotMetReason = "error_set_warp_invalid_length";
                return;
            }
            if (!RegexUtil.NAME_PATTERN.matcher(warpName).matches()) {
                this.conditionsNotMetReason = "error_set_warp_invalid_characters";
                return;
            }
            this.conditionsMet = true;
        }

        public boolean areConditionsMet() {
            return this.conditionsMet;
        }

        public String getConditionsNotMetReason() {
            return this.conditionsNotMetReason;
        }
    }

    private static class SetHomeConditions {
        private boolean conditionsMet = false;
        private String conditionsNotMetReason;

        public SetHomeConditions(Player player, String homeName, Connection connection) throws SQLException {
            double setHomeCost;
            int currentHomeCount = DataManager.getPlayerHomeCount(player, connection);
            if (DataManager.homeExists(player, homeName, connection).booleanValue()) {
                this.conditionsNotMetReason = "error_set_home_name_taken";
                return;
            }
            if (currentHomeCount > Home.getSetHomeLimit(player) - 1) {
                this.conditionsNotMetReason = "error_set_home_maximum_homes";
                return;
            }
            if (homeName.length() > 16) {
                this.conditionsNotMetReason = "error_set_home_invalid_length";
                return;
            }
            if (!RegexUtil.NAME_PATTERN.matcher(homeName).matches()) {
                this.conditionsNotMetReason = "error_set_home_invalid_characters";
                return;
            }
            if (HuskHomes.getSettings().doEconomy() && (setHomeCost = HuskHomes.getSettings().getSetHomeCost()) > 0.0) {
                int currentPlayerHomeSlots = DataManager.getPlayerHomeSlots(player, connection);
                if (currentHomeCount > currentPlayerHomeSlots - 1) {
                    if (!VaultIntegration.takeMoney(player, setHomeCost)) {
                        this.conditionsNotMetReason = "error_insufficient_funds";
                        return;
                    }
                    DataManager.incrementPlayerHomeSlots(player, connection);
                    MessageManager.sendMessage(player, "set_home_spent_money", VaultIntegration.format(setHomeCost));
                } else if (currentHomeCount == currentPlayerHomeSlots - 1) {
                    MessageManager.sendMessage(player, "set_home_used_free_slots", Integer.toString(Home.getFreeHomes(player)), VaultIntegration.format(setHomeCost));
                }
            }
            this.conditionsMet = true;
        }

        public boolean areConditionsMet() {
            return this.conditionsMet;
        }

        public String getConditionsNotMetReason() {
            return this.conditionsNotMetReason;
        }
    }
}

