/*
 * Decompiled with CFR 0.152.
 */
package me.william278.huskhomes2.teleport;

import java.sql.Connection;
import java.sql.SQLException;
import java.time.Instant;
import java.util.logging.Level;
import me.william278.huskhomes2.HuskHomes;
import me.william278.huskhomes2.api.events.PlayerPreTeleportEvent;
import me.william278.huskhomes2.api.events.PlayerTeleportBackEvent;
import me.william278.huskhomes2.data.DataManager;
import me.william278.huskhomes2.data.message.CrossServerMessageHandler;
import me.william278.huskhomes2.data.message.Message;
import me.william278.huskhomes2.integrations.ConnectorPluginIntegration;
import me.william278.huskhomes2.integrations.VaultIntegration;
import me.william278.huskhomes2.libraries.paperlib.PaperLib;
import me.william278.huskhomes2.teleport.TimedTeleport;
import me.william278.huskhomes2.teleport.points.RandomPoint;
import me.william278.huskhomes2.teleport.points.TeleportationPoint;
import me.william278.huskhomes2.util.MessageManager;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class TeleportManager {
    private static final HuskHomes plugin = HuskHomes.getInstance();
    private static TeleportationPoint spawnLocation;

    private static PlayerPreTeleportEvent getPreTeleportEvent(Player player, TeleportationPoint targetPoint) {
        PlayerPreTeleportEvent preTeleportEvent = new PlayerPreTeleportEvent(player, targetPoint);
        Bukkit.getPluginManager().callEvent((Event)preTeleportEvent);
        return preTeleportEvent;
    }

    public static void teleportPlayer(Player player, String targetPlayerName) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            try (Connection connection = HuskHomes.getConnection();){
                DataManager.setPlayerLastPosition(player, new TeleportationPoint(player.getLocation(), HuskHomes.getSettings().getServerID()), connection);
            }
            catch (SQLException e) {
                plugin.getLogger().log(Level.SEVERE, "An SQL exception occurred saving the last position of player " + player.getName(), e);
            }
        });
        Player targetPlayer = Bukkit.getPlayerExact((String)targetPlayerName);
        if (targetPlayer != null) {
            if (player.getUniqueId() != targetPlayer.getUniqueId()) {
                TeleportManager.teleportPlayer(player, new TeleportationPoint(targetPlayer.getLocation(), HuskHomes.getSettings().getServerID()));
            } else {
                MessageManager.sendMessage(player, "error_tp_self");
            }
        } else {
            if (HuskHomes.getSettings().doBungee()) {
                HuskHomes.setTeleporting(player.getUniqueId());
                TeleportManager.setTeleportationDestinationCrossServer(player, targetPlayerName);
                return;
            }
            MessageManager.sendMessage(player, "error_player_not_found", targetPlayerName);
        }
    }

    public static void teleportPlayer(Player player, TeleportationPoint point) {
        TeleportationPoint playerLocation = new TeleportationPoint(player.getLocation(), HuskHomes.getSettings().getServerID());
        PlayerPreTeleportEvent preTeleportEvent = TeleportManager.getPreTeleportEvent(player, point);
        if (preTeleportEvent.isCancelled()) {
            HuskHomes.setNotTeleporting(player.getUniqueId());
            return;
        }
        point = preTeleportEvent.getTargetPoint();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            try (Connection connection = HuskHomes.getConnection();){
                DataManager.setPlayerLastPosition(player, playerLocation, connection);
            }
            catch (SQLException e) {
                plugin.getLogger().log(Level.SEVERE, "An SQL exception occurred saving the last position of player " + player.getName(), e);
            }
        });
        String server = point.getServer();
        if (!HuskHomes.getSettings().doBungee() || server.equals(HuskHomes.getSettings().getServerID())) {
            Location targetLocation = point.getLocation();
            if (!player.isEmpty()) {
                player.eject();
            }
            HuskHomes.setTeleporting(player.getUniqueId());
            PaperLib.teleportAsync((Entity)player, targetLocation).thenAccept(success -> {
                HuskHomes.setNotTeleporting(player.getUniqueId());
                if (success.booleanValue()) {
                    if (HuskHomes.getSettings().getTeleportationCompleteSound() != null) {
                        player.playSound(player.getLocation(), HuskHomes.getSettings().getTeleportationCompleteSound(), 1.0f, 1.0f);
                    }
                    MessageManager.sendMessage(player, "teleporting_complete");
                } else {
                    if (HuskHomes.getSettings().getTeleportCancelledSound() != null) {
                        player.playSound(player.getLocation(), HuskHomes.getSettings().getTeleportCancelledSound(), 1.0f, 1.0f);
                    }
                    MessageManager.sendMessage(player, "error_invalid_on_arrival");
                }
            });
        } else if (HuskHomes.getSettings().doBungee()) {
            HuskHomes.setTeleporting(player.getUniqueId());
            ConnectorPluginIntegration.teleportPlayer(player, point);
        }
    }

    public static void teleportPlayer(Player player) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            TeleportationPoint teleportationPoint = null;
            try (Connection connection = HuskHomes.getConnection();){
                teleportationPoint = DataManager.getPlayerDestination(player, connection);
                if (teleportationPoint != null) {
                    DataManager.deletePlayerDestination(player.getName(), connection);
                }
            }
            catch (SQLException sqlException) {
                plugin.getLogger().log(Level.SEVERE, "An SQL exception occurred fetching a player's destination", sqlException);
            }
            if (teleportationPoint != null) {
                TeleportationPoint[] targetPoint = new TeleportationPoint[]{teleportationPoint};
                HuskHomes.setTeleporting(player.getUniqueId());
                Bukkit.getScheduler().runTask((Plugin)plugin, () -> TeleportManager.teleportPlayer(player, targetPoint[0]));
            }
        });
    }

    public static void queueTimedTeleport(Player player, String targetPlayer) {
        if (player.hasPermission("huskhomes.bypass_timer")) {
            if (Bukkit.isPrimaryThread()) {
                TeleportManager.teleportPlayer(player, targetPlayer);
            } else {
                HuskHomes.setTeleporting(player.getUniqueId());
                Bukkit.getScheduler().runTask((Plugin)plugin, () -> TeleportManager.teleportPlayer(player, targetPlayer));
            }
            return;
        }
        new TimedTeleport(player, targetPlayer).begin();
    }

    public static void queueTimedTeleport(Player player, TeleportationPoint point) {
        if (player.hasPermission("huskhomes.bypass_timer")) {
            if (Bukkit.isPrimaryThread()) {
                TeleportManager.teleportPlayer(player, point);
            } else {
                HuskHomes.setTeleporting(player.getUniqueId());
                Bukkit.getScheduler().runTask((Plugin)plugin, () -> TeleportManager.teleportPlayer(player, point));
            }
            return;
        }
        new TimedTeleport(player, point, TimedTeleport.TargetType.POINT).begin();
    }

    public static void teleportToOfflinePlayer(Player player, String targetPlayer, Connection connection) throws SQLException {
        Integer playerID = DataManager.getPlayerId(targetPlayer, connection);
        if (playerID == null) {
            MessageManager.sendMessage(player, "error_player_not_found", targetPlayer);
            return;
        }
        TeleportationPoint offlinePoint = DataManager.getPlayerOfflinePosition(playerID, connection);
        if (offlinePoint == null) {
            MessageManager.sendMessage(player, "error_no_offline_position", targetPlayer);
            return;
        }
        MessageManager.sendMessage(player, "teleporting_offline_player", targetPlayer);
        HuskHomes.setTeleporting(player.getUniqueId());
        Bukkit.getScheduler().runTask((Plugin)plugin, () -> TeleportManager.teleportPlayer(player, offlinePoint));
    }

    public static void queueBackTeleport(Player player, Connection connection) throws SQLException {
        try {
            TeleportationPoint lastPosition = DataManager.getPlayerLastPosition(player, connection);
            if (lastPosition != null) {
                Bukkit.getScheduler().runTask((Plugin)plugin, () -> {
                    double backCost;
                    PlayerTeleportBackEvent backEvent = new PlayerTeleportBackEvent(player, lastPosition);
                    Bukkit.getPluginManager().callEvent((Event)backEvent);
                    if (backEvent.isCancelled()) {
                        return;
                    }
                    if (HuskHomes.getSettings().doEconomy() && (backCost = HuskHomes.getSettings().getBackCost()) > 0.0 && !VaultIntegration.hasMoney(player, backCost)) {
                        MessageManager.sendMessage(player, "error_insufficient_funds", VaultIntegration.format(backCost));
                        return;
                    }
                    if (player.hasPermission("huskhomes.bypass_timer")) {
                        if (HuskHomes.getSettings().doEconomy() && (backCost = HuskHomes.getSettings().getRtpCost()) > 0.0) {
                            VaultIntegration.takeMoney(player, backCost);
                            MessageManager.sendMessage(player, "back_spent_money", VaultIntegration.format(backCost));
                        }
                        TeleportManager.teleportPlayer(player, lastPosition);
                        return;
                    }
                    new TimedTeleport(player, lastPosition, TimedTeleport.TargetType.BACK).begin();
                });
            } else {
                MessageManager.sendMessage(player, "error_no_last_position");
            }
        }
        catch (IllegalArgumentException e) {
            MessageManager.sendMessage(player, "error_no_last_position");
        }
    }

    public static void queueRandomTeleport(Player player, Connection connection) throws SQLException {
        double rtpCost;
        long coolDownTime;
        long currentTime;
        if (!player.hasPermission("huskhomes.rtp.bypass_cooldown") && (currentTime = Instant.now().getEpochSecond()) < (coolDownTime = DataManager.getPlayerRtpCoolDown(player, connection).longValue())) {
            long timeRemaining = coolDownTime - currentTime;
            long timeRemainingMinutes = timeRemaining / 60L;
            MessageManager.sendMessage(player, "error_rtp_cooldown", Long.toString(timeRemainingMinutes));
            return;
        }
        if (HuskHomes.getSettings().doEconomy() && (rtpCost = HuskHomes.getSettings().getRtpCost()) > 0.0 && !VaultIntegration.hasMoney(player, rtpCost)) {
            MessageManager.sendMessage(player, "error_insufficient_funds", VaultIntegration.format(rtpCost));
            return;
        }
        if (player.hasPermission("huskhomes.bypass_timer")) {
            double rtpCost2;
            RandomPoint randomPoint = new RandomPoint(player);
            if (randomPoint.hasFailed()) {
                return;
            }
            if (HuskHomes.getSettings().doEconomy() && (rtpCost2 = HuskHomes.getSettings().getRtpCost()) > 0.0) {
                VaultIntegration.takeMoney(player, rtpCost2);
                MessageManager.sendMessage(player, "rtp_spent_money", VaultIntegration.format(rtpCost2));
            }
            HuskHomes.setTeleporting(player.getUniqueId());
            Bukkit.getScheduler().runTask((Plugin)plugin, () -> TeleportManager.teleportPlayer(player, randomPoint));
            DataManager.updateRtpCoolDown(player, connection);
            return;
        }
        new TimedTeleport(player).begin();
    }

    public static void teleportAllHere(Player requester) {
        for (String playerName : HuskHomes.getPlayerList().getPlayers()) {
            if (playerName.equals(requester.getName())) continue;
            Player targetPlayer = Bukkit.getPlayerExact((String)playerName);
            if (targetPlayer != null) {
                TeleportManager.teleportPlayer(targetPlayer, requester.getName());
                continue;
            }
            if (!HuskHomes.getSettings().doBungee()) continue;
            TeleportManager.teleportHereCrossServer(requester, playerName);
        }
    }

    public static void teleportHere(Player requester, String targetPlayerName) throws SQLException {
        Player targetPlayer = Bukkit.getPlayerExact((String)targetPlayerName);
        if (targetPlayer != null) {
            if (targetPlayer.getUniqueId() != requester.getUniqueId()) {
                TeleportManager.teleportPlayer(targetPlayer, requester.getName());
            } else {
                MessageManager.sendMessage(requester, "error_tp_self");
            }
        } else {
            if (HuskHomes.getSettings().doBungee()) {
                TeleportManager.teleportHereCrossServer(requester, targetPlayerName);
                return;
            }
            MessageManager.sendMessage(requester, "error_player_not_found", targetPlayerName);
        }
    }

    private static void teleportHereCrossServer(Player requester, String targetPlayerName) {
        CrossServerMessageHandler.getMessage(targetPlayerName, Message.MessageType.TELEPORT_TO_ME, requester.getName()).send(requester);
    }

    private static void setTeleportationDestinationCrossServer(Player requester, String targetPlayerName) {
        CrossServerMessageHandler.getMessage(targetPlayerName, Message.MessageType.SET_TP_DESTINATION, requester.getName()).send(requester);
    }

    public static TeleportationPoint getSpawnLocation() {
        return spawnLocation;
    }

    public static void setSpawnLocation(TeleportationPoint spawnLocation) {
        TeleportManager.spawnLocation = spawnLocation;
    }
}

