/*
 * Decompiled with CFR 0.152.
 */
package me.william278.huskhomes2.teleport;

import java.util.HashMap;
import me.william278.huskhomes2.HuskHomes;
import me.william278.huskhomes2.api.events.PlayerTeleportRequestAcceptEvent;
import me.william278.huskhomes2.api.events.PlayerTeleportRequestSendEvent;
import me.william278.huskhomes2.data.message.CrossServerMessageHandler;
import me.william278.huskhomes2.data.message.Message;
import me.william278.huskhomes2.integrations.VanishChecker;
import me.william278.huskhomes2.teleport.TeleportManager;
import me.william278.huskhomes2.teleport.TeleportRequest;
import me.william278.huskhomes2.util.MessageManager;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class TeleportRequestHandler {
    private static final HuskHomes plugin = HuskHomes.getInstance();
    public static HashMap<Player, HashMap<String, TeleportRequest>> teleportRequests = new HashMap();

    private static void sendTeleportRequestCrossServer(Player requester, String targetPlayerName, TeleportRequest.RequestType requestType) {
        if (TeleportRequestHandler.callRequestSendEvent(requester.getName(), targetPlayerName, requestType).isCancelled()) {
            return;
        }
        if (requestType == TeleportRequest.RequestType.TPA) {
            CrossServerMessageHandler.getMessage(targetPlayerName, Message.MessageType.TPA_REQUEST, requester.getName()).send(requester);
        } else if (requestType == TeleportRequest.RequestType.TPA_HERE) {
            CrossServerMessageHandler.getMessage(targetPlayerName, Message.MessageType.TPA_HERE_REQUEST, requester.getName()).send(requester);
        }
    }

    private static void replyTeleportRequestCrossServer(Player replier, String requesterName, TeleportRequest.RequestType requestType, boolean accepted) {
        if (requestType == TeleportRequest.RequestType.TPA) {
            CrossServerMessageHandler.getMessage(requesterName, Message.MessageType.TPA_REQUEST_REPLY, replier.getName(), Boolean.toString(accepted)).send(replier);
        } else if (requestType == TeleportRequest.RequestType.TPA_HERE) {
            CrossServerMessageHandler.getMessage(requesterName, Message.MessageType.TPA_HERE_REQUEST_REPLY, replier.getName(), Boolean.toString(accepted)).send(replier);
        }
    }

    public static void sendTeleportToRequest(Player requester, String targetPlayerName) {
        Player targetPlayer = Bukkit.getPlayerExact((String)targetPlayerName);
        if (targetPlayer != null) {
            if (targetPlayer.getUniqueId() != requester.getUniqueId()) {
                if (!VanishChecker.isVanished(targetPlayer)) {
                    if (TeleportRequestHandler.isDuplicateRequest(requester.getName(), targetPlayer)) {
                        MessageManager.sendMessage(requester, "error_tpa_duplicate_request", targetPlayerName);
                        return;
                    }
                    if (!HuskHomes.isIgnoringTeleportRequests(targetPlayer.getUniqueId())) {
                        if (TeleportRequestHandler.callRequestSendEvent(requester.getName(), targetPlayer.getName(), TeleportRequest.RequestType.TPA).isCancelled()) {
                            return;
                        }
                        teleportRequests.get(targetPlayer).put(requester.getName(), new TeleportRequest(requester.getName(), TeleportRequest.RequestType.TPA));
                        MessageManager.sendMessage(targetPlayer, "tpa_request_ask", requester.getName());
                        MessageManager.sendMessage(targetPlayer, "teleport_request_options", requester.getName());
                    }
                    MessageManager.sendMessage(requester, "tpa_request_sent", targetPlayerName);
                } else {
                    MessageManager.sendMessage(requester, "error_player_not_found", targetPlayerName);
                }
            } else {
                MessageManager.sendMessage(requester, "error_tp_self");
            }
        } else if (HuskHomes.getSettings().doBungee() && HuskHomes.getPlayerList().hasVisiblePlayer(targetPlayerName)) {
            TeleportRequestHandler.sendTeleportRequestCrossServer(requester, targetPlayerName, TeleportRequest.RequestType.TPA);
        } else {
            MessageManager.sendMessage(requester, "error_player_not_found", targetPlayerName);
        }
    }

    public static void sendTeleportAllHereRequest(Player requester) {
        if (HuskHomes.getPlayerList().getPlayers().size() <= 1) {
            MessageManager.sendMessage(requester, "error_no_other_online_players");
            return;
        }
        for (String playerName : HuskHomes.getPlayerList().getPlayers()) {
            if (playerName.equals(requester.getName())) continue;
            Player targetPlayer = Bukkit.getPlayerExact((String)playerName);
            if (targetPlayer != null) {
                TeleportRequestHandler.sendLocalTpaHereRequest(requester, playerName, targetPlayer);
                continue;
            }
            if (!HuskHomes.getSettings().doBungee()) continue;
            TeleportRequestHandler.sendTeleportRequestCrossServer(requester, playerName, TeleportRequest.RequestType.TPA_HERE);
        }
        MessageManager.sendMessage(requester, "tpaall_request_sent");
    }

    private static void sendLocalTpaHereRequest(Player requester, String playerName, Player targetPlayer) {
        if (!HuskHomes.isIgnoringTeleportRequests(targetPlayer.getUniqueId())) {
            if (TeleportRequestHandler.isDuplicateRequest(requester.getName(), targetPlayer)) {
                return;
            }
            if (TeleportRequestHandler.callRequestSendEvent(requester.getName(), targetPlayer.getName(), TeleportRequest.RequestType.TPA_HERE).isCancelled()) {
                return;
            }
            teleportRequests.get(targetPlayer).put(requester.getName(), new TeleportRequest(requester.getName(), TeleportRequest.RequestType.TPA_HERE));
            MessageManager.sendMessage(targetPlayer, "tpahere_request_ask", requester.getName());
            MessageManager.sendMessage(targetPlayer, "teleport_request_options", requester.getName());
        }
    }

    public static void sendTeleportHereRequest(Player requester, String targetPlayerName) {
        Player targetPlayer = Bukkit.getPlayerExact((String)targetPlayerName);
        if (targetPlayer != null) {
            if (!VanishChecker.isVanished(targetPlayer)) {
                if (targetPlayer.getUniqueId() != requester.getUniqueId()) {
                    if (TeleportRequestHandler.isDuplicateRequest(requester.getName(), targetPlayer)) {
                        MessageManager.sendMessage(requester, "error_tpahere_duplicate_request", targetPlayer.getName());
                        return;
                    }
                    TeleportRequestHandler.sendLocalTpaHereRequest(requester, targetPlayerName, targetPlayer);
                    MessageManager.sendMessage(requester, "tpahere_request_sent", targetPlayerName);
                } else {
                    MessageManager.sendMessage(requester, "error_tp_self");
                }
            } else {
                MessageManager.sendMessage(requester, "error_player_not_found", targetPlayerName);
            }
        } else if (HuskHomes.getSettings().doBungee() && HuskHomes.getPlayerList().hasVisiblePlayer(targetPlayerName)) {
            TeleportRequestHandler.sendTeleportRequestCrossServer(requester, targetPlayerName, TeleportRequest.RequestType.TPA_HERE);
        } else {
            MessageManager.sendMessage(requester, "error_player_not_found", targetPlayerName);
        }
    }

    private static void handleRequestReply(Player p, TeleportRequest teleportRequest, boolean accepted) {
        if (accepted && TeleportRequestHandler.callRequestAcceptEvent(p.getName(), teleportRequest.getSenderName(), teleportRequest.getRequestType()).isCancelled()) {
            return;
        }
        if (teleportRequest.isExpired()) {
            teleportRequests.get(p).remove(teleportRequest.getSenderName());
            if (teleportRequests.get(p).isEmpty()) {
                teleportRequests.remove(p);
            }
            MessageManager.sendMessage(p, "error_tp_request_expired");
            return;
        }
        String requesterName = teleportRequest.getSenderName();
        TeleportRequest.RequestType requestType = teleportRequest.getRequestType();
        Player requester = Bukkit.getPlayer((String)requesterName);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            if (requester != null) {
                if (accepted) {
                    MessageManager.sendMessage(p, "tpa_you_accepted", requesterName);
                    MessageManager.sendMessage(requester, "tpa_has_accepted", p.getName());
                    if (requestType == TeleportRequest.RequestType.TPA) {
                        TeleportManager.queueTimedTeleport(requester, p.getName());
                    } else if (requestType == TeleportRequest.RequestType.TPA_HERE) {
                        TeleportManager.queueTimedTeleport(p, requesterName);
                    }
                } else {
                    MessageManager.sendMessage(p, "tpa_you_declined", requesterName);
                    MessageManager.sendMessage(requester, "tpa_has_declined", p.getName());
                }
            } else if (HuskHomes.getSettings().doBungee() && HuskHomes.getPlayerList().hasVisiblePlayer(requesterName)) {
                if (accepted) {
                    MessageManager.sendMessage(p, "tpa_you_accepted", requesterName);
                    TeleportRequestHandler.replyTeleportRequestCrossServer(p, requesterName, requestType, true);
                    if (requestType == TeleportRequest.RequestType.TPA_HERE) {
                        TeleportManager.queueTimedTeleport(p, requesterName);
                    }
                } else {
                    TeleportRequestHandler.replyTeleportRequestCrossServer(p, requesterName, requestType, false);
                    MessageManager.sendMessage(p, "tpa_you_declined", requesterName);
                }
            } else {
                MessageManager.sendMessage(p, "error_player_not_found", requesterName);
            }
            teleportRequests.get(p).remove(teleportRequest.getSenderName());
            if (teleportRequests.get(p).isEmpty()) {
                teleportRequests.remove(p);
            }
        });
    }

    public static void replyTpRequest(Player p, boolean accepted) {
        if (!teleportRequests.containsKey(p)) {
            MessageManager.sendMessage(p, "error_tpa_no_pending_request");
            return;
        }
        if (teleportRequests.get(p).isEmpty()) {
            MessageManager.sendMessage(p, "error_tpa_no_pending_request");
            return;
        }
        if (HuskHomes.isIgnoringTeleportRequests(p.getUniqueId())) {
            MessageManager.sendMessage(p, "error_ignoring_teleport_requests");
            return;
        }
        HashMap<String, TeleportRequest> playerRequests = teleportRequests.get(p);
        long firstRequestTime = Long.MAX_VALUE;
        TeleportRequest targetRequest = null;
        for (String playerName : playerRequests.keySet()) {
            TeleportRequest request = playerRequests.get(playerName);
            if (request.getRequestTime() >= firstRequestTime) continue;
            targetRequest = request;
            firstRequestTime = targetRequest.getRequestTime();
        }
        if (targetRequest == null) {
            MessageManager.sendMessage(p, "error_tpa_no_pending_request");
            return;
        }
        TeleportRequestHandler.handleRequestReply(p, targetRequest, accepted);
    }

    public static void replyTpRequest(Player p, String requesterName, boolean accepted) {
        if (!teleportRequests.containsKey(p)) {
            MessageManager.sendMessage(p, "error_tpa_no_pending_request");
            return;
        }
        if (teleportRequests.get(p).isEmpty()) {
            MessageManager.sendMessage(p, "error_tpa_no_pending_request");
            return;
        }
        if (HuskHomes.isIgnoringTeleportRequests(p.getUniqueId())) {
            MessageManager.sendMessage(p, "error_ignoring_teleport_requests");
            return;
        }
        HashMap<String, TeleportRequest> playerRequests = teleportRequests.get(p);
        TeleportRequest targetRequest = null;
        for (String playerName : playerRequests.keySet()) {
            TeleportRequest request = playerRequests.get(playerName);
            if (!request.getSenderName().equalsIgnoreCase(requesterName)) continue;
            targetRequest = request;
            break;
        }
        if (targetRequest == null) {
            MessageManager.sendMessage(p, "error_invalid_player");
            return;
        }
        TeleportRequestHandler.handleRequestReply(p, targetRequest, accepted);
    }

    public static boolean isDuplicateRequest(String senderName, Player recipient) {
        if (teleportRequests.containsKey(recipient)) {
            if (teleportRequests.get(recipient).containsKey(senderName)) {
                TeleportRequest request = teleportRequests.get(recipient).get(senderName);
                if (!request.isExpired()) {
                    return true;
                }
                teleportRequests.get(recipient).remove(senderName);
            }
        } else {
            teleportRequests.put(recipient, new HashMap());
        }
        return false;
    }

    public static PlayerTeleportRequestSendEvent callRequestSendEvent(String requester, String target, TeleportRequest.RequestType requestType) {
        return TeleportRequestHandler.callEvent(new PlayerTeleportRequestSendEvent(requester, target, requestType));
    }

    public static PlayerTeleportRequestAcceptEvent callRequestAcceptEvent(String sender, String target, TeleportRequest.RequestType requestType) {
        return TeleportRequestHandler.callEvent(new PlayerTeleportRequestAcceptEvent(sender, target, requestType));
    }

    private static <E extends Event> E callEvent(E event) {
        Bukkit.getPluginManager().callEvent(event);
        return event;
    }
}

