/*
 * Decompiled with CFR 0.152.
 */
package me.william278.huskhomes2.teleport.points;

import java.util.UUID;
import java.util.regex.PatternSyntaxException;
import me.william278.huskhomes2.HuskHomes;
import me.william278.huskhomes2.teleport.points.SetPoint;
import me.william278.huskhomes2.teleport.points.TeleportationPoint;
import me.william278.huskhomes2.util.MessageManager;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionAttachmentInfo;

public class Home
extends SetPoint {
    private boolean isPublic;
    private UUID ownerUUID;
    private String ownerUsername;

    public Home(Location location, String server, Player homeOwner, String name, boolean isPublic) {
        super(location, server, name, MessageManager.getRawMessage("home_default_description", homeOwner.getName()));
        this.ownerUUID = homeOwner.getUniqueId();
        this.ownerUsername = homeOwner.getName();
        this.isPublic = isPublic;
    }

    public Home(TeleportationPoint teleportationPoint, String ownerUsername, String ownerUUID, String name, String description, boolean isPublic, long creationTime) throws IllegalArgumentException {
        super(teleportationPoint.worldName, teleportationPoint.x, teleportationPoint.y, teleportationPoint.z, teleportationPoint.yaw, teleportationPoint.pitch, teleportationPoint.server, name, description, creationTime);
        this.ownerUsername = ownerUsername;
        this.ownerUUID = UUID.fromString(ownerUUID);
        this.isPublic = isPublic;
    }

    public Home(TeleportationPoint teleportationPoint, String ownerUsername, UUID ownerUUID, String name, String description, boolean isPublic, long creationTime) {
        super(teleportationPoint.worldName, teleportationPoint.x, teleportationPoint.y, teleportationPoint.z, teleportationPoint.yaw, teleportationPoint.pitch, teleportationPoint.server, name, description, creationTime);
        this.ownerUsername = ownerUsername;
        this.ownerUUID = ownerUUID;
        this.isPublic = isPublic;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public void setPublic(boolean isPublic) {
        this.isPublic = isPublic;
    }

    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public String getOwnerUsername() {
        return this.ownerUsername;
    }

    public Player getOwner() {
        Player player = Bukkit.getPlayer((UUID)this.ownerUUID);
        if (player != null) {
            return player;
        }
        throw new IllegalStateException("The home owner is not online");
    }

    public void setOwner(Player player) {
        this.ownerUUID = player.getUniqueId();
        this.ownerUsername = player.getName();
    }

    public static int getSetHomeLimit(Player player) {
        int maxSetHomes = Home.getLimitFromPermissions(player, "huskhomes.max_sethomes.");
        if (maxSetHomes != -1) {
            return maxSetHomes;
        }
        return HuskHomes.getSettings().getMaximumHomes();
    }

    public static int getFreeHomes(Player player) {
        int freeSetHomes = Home.getLimitFromPermissions(player, "huskhomes.free_sethomes.");
        if (freeSetHomes != -1) {
            return freeSetHomes;
        }
        return HuskHomes.getSettings().getFreeHomeSlots();
    }

    public static int getPublicHomeLimit(Player player) {
        int maxPublicHomes = Home.getLimitFromPermissions(player, "huskhomes.max_public_homes.");
        if (maxPublicHomes != -1) {
            return maxPublicHomes;
        }
        return Integer.MAX_VALUE;
    }

    private static int getLimitFromPermissions(Player player, String permissionPrefix) {
        player.recalculatePermissions();
        int limit = -1;
        for (PermissionAttachmentInfo permissionAI : player.getEffectivePermissions()) {
            String permission = permissionAI.getPermission();
            if (!permission.contains(permissionPrefix)) continue;
            try {
                int value = Integer.parseInt(permission.split("\\.")[2]);
                if (HuskHomes.getSettings().doHomeLimitPermissionStacking()) {
                    if (limit == -1) {
                        ++limit;
                    }
                    limit += value;
                    continue;
                }
                if (value <= limit) continue;
                limit = value;
            }
            catch (NumberFormatException | PatternSyntaxException illegalArgumentException) {}
        }
        return limit;
    }
}

