/*
 * Decompiled with CFR 0.152.
 */
package me.william278.huskhomes2.teleport.points;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Locale;
import me.william278.huskhomes2.teleport.points.TeleportationPoint;
import org.bukkit.Location;

public class SetPoint
extends TeleportationPoint {
    private String name;
    private String description;
    private final long creationTime;

    public SetPoint(String worldName, double x, double y, double z, float yaw, float pitch, String server, String name, String description, long creationTime) {
        super(worldName, x, y, z, yaw, pitch, server);
        this.name = name;
        this.description = description;
        this.creationTime = creationTime;
    }

    public SetPoint(Location location, String serverName, String name, String description) {
        super(location, serverName);
        this.name = name;
        this.description = description;
        this.creationTime = Instant.now().getEpochSecond();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getFormattedCreationTime() {
        if (this.creationTime == 0L) {
            return "N/A";
        }
        return DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM, FormatStyle.SHORT).withLocale(Locale.getDefault()).withZone(ZoneId.systemDefault()).format(Instant.ofEpochSecond(this.creationTime));
    }
}

