/*
 * Decompiled with CFR 0.152.
 */
package me.william278.huskhomes2.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import me.william278.huskhomes2.HuskHomes;
import me.william278.huskhomes2.data.message.CrossServerMessageHandler;
import me.william278.huskhomes2.integrations.VanishChecker;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PlayerList {
    private static final HuskHomes plugin = HuskHomes.getInstance();
    private static final long playerListUpdateTime = (long)HuskHomes.getSettings().getCrossServerTabUpdateDelay() * 20L;
    private static Map<String, Map<String, Boolean>> players;

    public PlayerList() {
        players = new HashMap<String, Map<String, Boolean>>();
    }

    public void initialize() {
        Bukkit.getScheduler().runTaskTimer((Plugin)plugin, () -> this.sendUpdate(), 1L, playerListUpdateTime);
    }

    public void sendUpdate() {
        if (HuskHomes.getSettings().doBungee() && HuskHomes.getSettings().doCrossServerTabCompletion()) {
            CrossServerMessageHandler.getPlayerListMessage().sendToAllServers(null);
        }
    }

    public void updateList() {
        HuskHomes.getPlayerList().sendUpdate();
        if (Bukkit.getOnlinePlayers().isEmpty()) {
            players.remove(HuskHomes.getSettings().getServerID());
            return;
        }
        HashMap<String, Boolean> localPlayers = new HashMap<String, Boolean>();
        for (Player player : Bukkit.getOnlinePlayers()) {
            localPlayers.put(player.getName(), VanishChecker.isVanished(player));
        }
        players.put(HuskHomes.getSettings().getServerID(), localPlayers);
    }

    public Set<String> getPlayers() {
        return players.keySet();
    }

    public Map<String, Boolean> getPlayerInfo() {
        HashMap<String, Boolean> allPlayers = new HashMap<String, Boolean>();
        for (Map<String, Boolean> map : players.values()) {
            allPlayers.putAll(map);
        }
        return allPlayers;
    }

    public void addPlayers(String server, String[] playerList) {
        if (playerList.length == 0) {
            players.remove(server);
            return;
        }
        HashMap<String, Boolean> serverPlayers = new HashMap<String, Boolean>();
        for (String playerInfo : playerList) {
            String[] parts = playerInfo.split("\\|", 2);
            serverPlayers.put(parts[0], "true".equals(parts[1]));
        }
        players.put(server, serverPlayers);
    }

    public boolean hasVisiblePlayer(String playerName) {
        for (Map<String, Boolean> map : players.values()) {
            Boolean isVanished = map.get(playerName);
            if (isVanished != null) {
                return isVanished == false;
            }
            for (Map.Entry<String, Boolean> entry : map.entrySet()) {
                if (!entry.getKey().equalsIgnoreCase(playerName)) continue;
                return entry.getValue() == false;
            }
        }
        return false;
    }
}

