/*
 * Decompiled with CFR 0.152.
 */
package me.william278.huskhomes2.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import me.william278.huskhomes2.HuskHomes;

public class UpdateChecker {
    private static final int SPIGOT_PROJECT_ID = 83767;
    private final String currentVersion;
    private String latestVersion;
    private final HuskHomes plugin;

    public UpdateChecker(HuskHomes plugin) {
        this.plugin = plugin;
        this.currentVersion = this.plugin.getDescription().getVersion();
        try {
            URL url = new URL("https://api.spigotmc.org/legacy/update.php?resource=83767");
            URLConnection urlConnection = url.openConnection();
            this.latestVersion = new BufferedReader(new InputStreamReader(urlConnection.getInputStream())).readLine();
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.WARNING, "An IOException occurred when trying to check for updates.");
            this.latestVersion = "Unknown";
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "An exception occurred when trying to check for updates.");
            this.latestVersion = "Unknown";
        }
    }

    public boolean isUpToDate() {
        if (this.latestVersion.equalsIgnoreCase("Unknown")) {
            return true;
        }
        return this.latestVersion.equals(this.currentVersion);
    }

    public String getLatestVersion() {
        return this.latestVersion;
    }

    public String getCurrentVersion() {
        return this.currentVersion;
    }

    public void logToConsole() {
        if (!this.isUpToDate()) {
            this.plugin.getLogger().log(Level.WARNING, "A new version of HuskHomes is available: Version " + this.latestVersion + " (Currently running: " + this.currentVersion + ")");
        }
    }
}

