/*
 * Decompiled with CFR 0.152.
 */
package me.william278.huskhomes2;

import de.themoep.connectorplugin.connector.ConnectingPlugin;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.UUID;
import java.util.logging.Level;
import me.william278.huskhomes2.api.HuskHomesAPI;
import me.william278.huskhomes2.commands.BackCommand;
import me.william278.huskhomes2.commands.CommandBase;
import me.william278.huskhomes2.commands.DelHomeCommand;
import me.william278.huskhomes2.commands.DelWarpCommand;
import me.william278.huskhomes2.commands.EditHomeCommand;
import me.william278.huskhomes2.commands.EditWarpCommand;
import me.william278.huskhomes2.commands.HomeCommand;
import me.william278.huskhomes2.commands.HomeListCommand;
import me.william278.huskhomes2.commands.HuskHomesCommand;
import me.william278.huskhomes2.commands.PublicHomeCommand;
import me.william278.huskhomes2.commands.PublicHomeListCommand;
import me.william278.huskhomes2.commands.RtpCommand;
import me.william278.huskhomes2.commands.SetHomeCommand;
import me.william278.huskhomes2.commands.SetSpawnCommand;
import me.william278.huskhomes2.commands.SetWarpCommand;
import me.william278.huskhomes2.commands.SpawnCommand;
import me.william278.huskhomes2.commands.TpAcceptCommand;
import me.william278.huskhomes2.commands.TpAllCommand;
import me.william278.huskhomes2.commands.TpCommand;
import me.william278.huskhomes2.commands.TpDenyCommand;
import me.william278.huskhomes2.commands.TpHereCommand;
import me.william278.huskhomes2.commands.TpIgnoreCommand;
import me.william278.huskhomes2.commands.TpOfflineCommand;
import me.william278.huskhomes2.commands.TpaAllCommand;
import me.william278.huskhomes2.commands.TpaCommand;
import me.william278.huskhomes2.commands.TpaHereCommand;
import me.william278.huskhomes2.commands.WarpCommand;
import me.william278.huskhomes2.commands.WarpListCommand;
import me.william278.huskhomes2.config.Settings;
import me.william278.huskhomes2.data.message.pluginmessage.PluginMessageReceiver;
import me.william278.huskhomes2.data.message.redis.RedisReceiver;
import me.william278.huskhomes2.data.sql.Database;
import me.william278.huskhomes2.data.sql.MySQL;
import me.william278.huskhomes2.data.sql.SQLite;
import me.william278.huskhomes2.integrations.ConnectorPluginIntegration;
import me.william278.huskhomes2.integrations.DeluxeCombatIntegration;
import me.william278.huskhomes2.integrations.VaultIntegration;
import me.william278.huskhomes2.integrations.map.BlueMap;
import me.william278.huskhomes2.integrations.map.DynMap;
import me.william278.huskhomes2.integrations.map.Map;
import me.william278.huskhomes2.integrations.map.SquareMap;
import me.william278.huskhomes2.libraries.bstats.bukkit.Metrics;
import me.william278.huskhomes2.libraries.bstats.charts.SimplePie;
import me.william278.huskhomes2.listeners.PlayerListener;
import me.william278.huskhomes2.migrators.UpgradeDatabase;
import me.william278.huskhomes2.teleport.SettingHandler;
import me.william278.huskhomes2.util.MessageManager;
import me.william278.huskhomes2.util.PlayerList;
import me.william278.huskhomes2.util.UpdateChecker;
import org.bukkit.Bukkit;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.PluginMessageListener;

public final class HuskHomes
extends JavaPlugin
implements ConnectingPlugin {
    private static HuskHomes instance;
    private static Database database;
    private static Map map;
    private static DeluxeCombatIntegration deluxeCombatIntegration;
    private static Settings settings;
    private static PlayerList playerList;
    private static final HashSet<UUID> ignoringTeleportRequests;
    private static final HashSet<UUID> teleportingPlayers;
    private static final int METRICS_PLUGIN_ID = 8430;

    public static HuskHomes getInstance() {
        return instance;
    }

    public static Connection getConnection() throws SQLException {
        return database.getConnection();
    }

    public static void backupDatabase() {
        database.backup();
    }

    public static Map getMap() {
        return map;
    }

    public static DeluxeCombatIntegration getDeluxeCombatIntegration() {
        return deluxeCombatIntegration;
    }

    public static Settings getSettings() {
        return settings;
    }

    public static PlayerList getPlayerList() {
        return playerList;
    }

    public static boolean isIgnoringTeleportRequests(UUID uuid) {
        return ignoringTeleportRequests.contains(uuid);
    }

    public static void setIgnoringTeleportRequests(UUID uuid) {
        ignoringTeleportRequests.add(uuid);
    }

    public static void setNotIgnoringTeleportRequests(UUID uuid) {
        ignoringTeleportRequests.remove(uuid);
    }

    public static boolean isTeleporting(UUID uuid) {
        return teleportingPlayers.contains(uuid);
    }

    public static void setTeleporting(UUID uuid) {
        teleportingPlayers.add(uuid);
    }

    public static void setNotTeleporting(UUID uuid) {
        teleportingPlayers.remove(uuid);
    }

    public HuskHomesAPI getAPI() {
        return HuskHomesAPI.getInstance();
    }

    public static void disablePlugin(String reason) {
        instance.getLogger().severe("Disabling HuskHomes plugin because:\n" + reason);
        Bukkit.getPluginManager().disablePlugin((Plugin)instance);
    }

    private void initializeDatabase() {
        String dataStorageType;
        switch (dataStorageType = HuskHomes.getSettings().getDatabaseType().toLowerCase()) {
            case "mysql": {
                database = new MySQL(HuskHomes.getInstance());
                database.load();
                break;
            }
            case "sqlite": {
                database = new SQLite(HuskHomes.getInstance());
                database.load();
                break;
            }
            default: {
                this.getLogger().log(Level.WARNING, "An invalid data storage type was specified in config.yml; defaulting to SQLite");
                database = new SQLite(HuskHomes.getInstance());
                database.load();
            }
        }
    }

    private void setupMessagingChannels() {
        Bukkit.getMessenger().registerOutgoingPluginChannel((Plugin)this, "BungeeCord");
        if (HuskHomes.getSettings().getMessengerType().equalsIgnoreCase("pluginmessage")) {
            Bukkit.getMessenger().registerIncomingPluginChannel((Plugin)this, "BungeeCord", (PluginMessageListener)new PluginMessageReceiver());
        } else {
            RedisReceiver.listen();
        }
    }

    private void registerCommands() {
        HomeCommand.Tab homeTab = new HomeCommand.Tab();
        new HomeCommand().register(this.getCommand("home")).setTabCompleter((TabCompleter)homeTab);
        new DelHomeCommand().register(this.getCommand("delhome")).setTabCompleter((TabCompleter)homeTab);
        WarpCommand.Tab warpTab = new WarpCommand.Tab();
        new WarpCommand().register(this.getCommand("warp")).setTabCompleter((TabCompleter)warpTab);
        new DelWarpCommand().register(this.getCommand("delwarp")).setTabCompleter((TabCompleter)warpTab);
        new PublicHomeCommand().register(this.getCommand("publichome"));
        new EditHomeCommand().register(this.getCommand("edithome"));
        new EditWarpCommand().register(this.getCommand("editwarp"));
        new HuskHomesCommand().register(this.getCommand("huskhomes"));
        TpCommand.Tab tpTab = new TpCommand.Tab();
        new TpCommand().register(this.getCommand("tp")).setTabCompleter((TabCompleter)tpTab);
        new TpaCommand().register(this.getCommand("tpa")).setTabCompleter((TabCompleter)tpTab);
        new TpHereCommand().register(this.getCommand("tphere")).setTabCompleter((TabCompleter)tpTab);
        new TpaHereCommand().register(this.getCommand("tpahere")).setTabCompleter((TabCompleter)tpTab);
        CommandBase.EmptyTab emptyTab = new CommandBase.EmptyTab();
        new TpAcceptCommand().register(this.getCommand("tpaccept")).setTabCompleter((TabCompleter)emptyTab);
        new TpDenyCommand().register(this.getCommand("tpdeny")).setTabCompleter((TabCompleter)emptyTab);
        new TpIgnoreCommand().register(this.getCommand("tpignore")).setTabCompleter((TabCompleter)emptyTab);
        new WarpListCommand().register(this.getCommand("warplist")).setTabCompleter((TabCompleter)emptyTab);
        new HomeListCommand().register(this.getCommand("homelist")).setTabCompleter((TabCompleter)emptyTab);
        new PublicHomeListCommand().register(this.getCommand("publichomelist")).setTabCompleter((TabCompleter)emptyTab);
        new RtpCommand().register(this.getCommand("rtp")).setTabCompleter((TabCompleter)emptyTab);
        new SpawnCommand().register(this.getCommand("spawn")).setTabCompleter((TabCompleter)emptyTab);
        new SetSpawnCommand().register(this.getCommand("setspawn")).setTabCompleter((TabCompleter)emptyTab);
        new SetHomeCommand().register(this.getCommand("sethome")).setTabCompleter((TabCompleter)emptyTab);
        new SetWarpCommand().register(this.getCommand("setwarp")).setTabCompleter((TabCompleter)emptyTab);
        new BackCommand().register(this.getCommand("back")).setTabCompleter((TabCompleter)emptyTab);
        new TpOfflineCommand().register(this.getCommand("tpoffline")).setTabCompleter((TabCompleter)emptyTab);
        new TpaAllCommand().register(this.getCommand("tpaall")).setTabCompleter((TabCompleter)emptyTab);
        new TpAllCommand().register(this.getCommand("tpall")).setTabCompleter((TabCompleter)emptyTab);
        PublicHomeCommand.updatePublicHomeTabCache();
        WarpCommand.Tab.updateWarpsTabCache();
    }

    private static void registerEvents(HuskHomes plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(), (Plugin)plugin);
    }

    public void onLoad() {
        instance = this;
        settings = new Settings((Plugin)this);
    }

    public void onEnable() {
        if (!ConnectorPluginIntegration.initializeConnectorPlugin()) {
            this.getLogger().severe("Failed to load required ConnectorPlugin dependency!");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.getLogger().info("Initialized ConnectorPlugin dependency.");
        this.saveDefaultConfig();
        this.getConfig().options().copyDefaults(true);
        this.saveConfig();
        settings.reload();
        MessageManager.loadMessages(HuskHomes.getSettings().getLanguage());
        if (HuskHomes.getSettings().doStartupUpdateChecks()) {
            new UpdateChecker(this).logToConsole();
        }
        this.initializeDatabase();
        UpgradeDatabase.upgradeDatabase();
        SettingHandler.fetchSpawnLocation();
        if (HuskHomes.getSettings().doMapIntegration()) {
            String mapPlugin;
            switch (mapPlugin = HuskHomes.getSettings().getMapPlugin()) {
                case "dynmap": {
                    map = new DynMap();
                    break;
                }
                case "bluemap": {
                    map = new BlueMap();
                    break;
                }
                case "squaremap": {
                    map = new SquareMap();
                }
            }
            map.initialize();
        }
        if (HuskHomes.getSettings().doEconomy()) {
            VaultIntegration.initializeEconomy();
        }
        if (this.getServer().getPluginManager().isPluginEnabled("DeluxeCombat")) {
            deluxeCombatIntegration = new DeluxeCombatIntegration(this);
            this.getLogger().info("Initialized DeluxeCombat dependency.");
        }
        if (HuskHomes.getSettings().doBungee()) {
            this.setupMessagingChannels();
        }
        this.registerCommands();
        HuskHomes.registerEvents(this);
        try {
            Metrics metrics = new Metrics(this, 8430);
            metrics.addCustomChart(new SimplePie("bungee_mode", () -> Boolean.toString(HuskHomes.getSettings().doBungee())));
            if (HuskHomes.getSettings().doBungee()) {
                metrics.addCustomChart(new SimplePie("messenger_type", () -> HuskHomes.getSettings().getMessengerType().toLowerCase()));
            }
            metrics.addCustomChart(new SimplePie("language", () -> HuskHomes.getSettings().getLanguage()));
            metrics.addCustomChart(new SimplePie("database_type", () -> HuskHomes.getSettings().getDatabaseType().toLowerCase()));
            metrics.addCustomChart(new SimplePie("using_economy", () -> Boolean.toString(HuskHomes.getSettings().doEconomy())));
            metrics.addCustomChart(new SimplePie("using_map", () -> Boolean.toString(HuskHomes.getSettings().doMapIntegration())));
            if (HuskHomes.getSettings().doMapIntegration()) {
                metrics.addCustomChart(new SimplePie("map_type", () -> HuskHomes.getSettings().getMapPlugin()));
            }
        }
        catch (Exception e) {
            this.getLogger().warning("An exception occurred initialising metrics; skipping.");
        }
        playerList = new PlayerList();
        playerList.initialize();
        this.getLogger().info("Enabled HuskHomes version " + this.getDescription().getVersion());
    }

    public void onDisable() {
        if (HuskHomes.getSettings().doBungee() && !HuskHomes.getSettings().getMessengerType().equalsIgnoreCase("pluginmessage")) {
            playerList.sendUpdate();
        }
        database.close();
        Bukkit.getServer().getScheduler().cancelTasks((Plugin)this);
        this.getLogger().info("Disabled HuskHomes version " + this.getDescription().getVersion());
    }

    static {
        deluxeCombatIntegration = null;
        ignoringTeleportRequests = new HashSet();
        teleportingPlayers = new HashSet();
    }
}

