/*
 * Decompiled with CFR 0.152.
 */
package me.william278.huskhomes2.api;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import me.william278.huskhomes2.HuskHomes;
import me.william278.huskhomes2.api.events.PlayerSetLastLocationEvent;
import me.william278.huskhomes2.data.DataManager;
import me.william278.huskhomes2.teleport.TeleportManager;
import me.william278.huskhomes2.teleport.points.Home;
import me.william278.huskhomes2.teleport.points.TeleportationPoint;
import me.william278.huskhomes2.teleport.points.Warp;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class HuskHomesAPI {
    private static HuskHomesAPI instance;
    private final HuskHomes huskHomes = HuskHomes.getInstance();

    private HuskHomesAPI() {
    }

    public static HuskHomesAPI getInstance() {
        if (instance == null) {
            instance = new HuskHomesAPI();
        }
        return instance;
    }

    public Home getHome(Player player, String homeName) {
        return this.getHome(player.getName(), homeName);
    }

    public Home getHome(String ownerUsername, String homeName) {
        Home home;
        block8: {
            Connection connection = HuskHomes.getConnection();
            try {
                home = DataManager.getHome(ownerUsername, homeName, connection);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    this.huskHomes.getLogger().log(Level.WARNING, "An SQL exception occurred retrieving data for API access", e);
                    return null;
                }
            }
            connection.close();
        }
        return home;
    }

    public Warp getWarp(String warpName) {
        Warp warp;
        block8: {
            Connection connection = HuskHomes.getConnection();
            try {
                warp = DataManager.getWarp(warpName, connection);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    this.huskHomes.getLogger().log(Level.WARNING, "An SQL exception occurred retrieving data for API access", e);
                    return null;
                }
            }
            connection.close();
        }
        return warp;
    }

    public List<Home> getHomes(Player player) {
        return this.getHomes(player.getName());
    }

    public List<Home> getHomes(String ownerUsername) {
        List<Home> list;
        block8: {
            Connection connection = HuskHomes.getConnection();
            try {
                list = DataManager.getPlayerHomes(ownerUsername, connection);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    this.huskHomes.getLogger().log(Level.WARNING, "An SQL exception occurred retrieving data for API access", e);
                    return null;
                }
            }
            connection.close();
        }
        return list;
    }

    public int getHomeCount(Player player) {
        return this.getHomes(player).size();
    }

    @Deprecated
    public int getMaxSethomes(Player player) {
        return this.getMaxSetHomes(player);
    }

    public int getMaxSetHomes(Player player) {
        return Home.getSetHomeLimit(player);
    }

    @Deprecated
    public int getFreeSethomes(Player player) {
        return this.getFreeSetHomes(player);
    }

    public int getFreeSetHomes(Player player) {
        return Home.getFreeHomes(player);
    }

    public List<Home> getPublicHomes() {
        List<Home> list;
        block8: {
            Connection connection = HuskHomes.getConnection();
            try {
                list = DataManager.getPublicHomes(connection);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    this.huskHomes.getLogger().log(Level.WARNING, "An SQL exception occurred retrieving data for API access", e);
                    return null;
                }
            }
            connection.close();
        }
        return list;
    }

    public int getPublicHomeCount() {
        return this.getPublicHomes().size();
    }

    public List<Warp> getWarps() {
        List<Warp> list;
        block8: {
            Connection connection = HuskHomes.getConnection();
            try {
                list = DataManager.getWarps(connection);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    this.huskHomes.getLogger().log(Level.WARNING, "An SQL exception occurred retrieving data for API access", e);
                    return null;
                }
            }
            connection.close();
        }
        return list;
    }

    public int getWarpCount() {
        return this.getWarps().size();
    }

    public TeleportationPoint getSpawnPosition() {
        return TeleportManager.getSpawnLocation();
    }

    public void updatePlayerLastPosition(Player player, TeleportationPoint point) {
        this.setPlayerLastPosition(player, point);
    }

    public PlayerSetLastLocationEvent setPlayerLastPosition(Player player, TeleportationPoint point) {
        PlayerSetLastLocationEvent event = new PlayerSetLastLocationEvent(player, point, true);
        Bukkit.getPluginManager().callEvent((Event)event);
        UUID playerId = player.getUniqueId();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.huskHomes, () -> {
            try (Connection connection = HuskHomes.getConnection();){
                if (event.isRemoveOld()) {
                    DataManager.deletePlayerLastPosition(playerId, connection);
                }
                if (!event.isCancelled()) {
                    DataManager.setTeleportationLastPositionData(playerId, event.getLastLocation(), connection);
                }
            }
            catch (SQLException e) {
                this.huskHomes.getLogger().severe("An SQL exception occurred updating player " + playerId + "'s last position via the API.");
            }
        });
        return event;
    }

    public void teleportPlayer(Player player, TeleportationPoint point, boolean timed) {
        Bukkit.getScheduler().runTask((Plugin)this.huskHomes, () -> {
            if (timed) {
                TeleportManager.queueTimedTeleport(player, point);
            } else {
                TeleportManager.teleportPlayer(player, point);
            }
        });
    }

    public void teleportPlayer(Player player, String targetPlayerName, boolean timed) {
        Bukkit.getScheduler().runTask((Plugin)this.huskHomes, () -> {
            if (timed) {
                TeleportManager.queueTimedTeleport(player, targetPlayerName);
            } else {
                TeleportManager.teleportPlayer(player, targetPlayerName);
            }
        });
    }
}

