/*
 * Decompiled with CFR 0.152.
 */
package me.william278.huskhomes2.commands;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import me.william278.huskhomes2.HuskHomes;
import me.william278.huskhomes2.api.events.PlayerChangeWarpDescriptionEvent;
import me.william278.huskhomes2.api.events.PlayerRelocateWarpEvent;
import me.william278.huskhomes2.api.events.PlayerRenameWarpEvent;
import me.william278.huskhomes2.commands.CommandBase;
import me.william278.huskhomes2.commands.EditHomeCommand;
import me.william278.huskhomes2.commands.WarpCommand;
import me.william278.huskhomes2.data.DataManager;
import me.william278.huskhomes2.libraries.minedown.MineDown;
import me.william278.huskhomes2.teleport.points.TeleportationPoint;
import me.william278.huskhomes2.teleport.points.Warp;
import me.william278.huskhomes2.util.EditingHandler;
import me.william278.huskhomes2.util.MessageManager;
import me.william278.huskhomes2.util.RegexUtil;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;

public class EditWarpCommand
extends CommandBase
implements TabCompleter {
    private static final HuskHomes plugin = HuskHomes.getInstance();

    @Override
    protected boolean onCommand(Player p, Command command, String label, String[] args) {
        if (args.length == 0) {
            return false;
        }
        String warpName = args[0];
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            try (Connection connection = HuskHomes.getConnection();){
                if (!DataManager.warpExists(warpName, connection)) {
                    MessageManager.sendMessage(p, "error_warp_invalid", warpName);
                    return;
                }
                if (args.length == 1) {
                    Warp warp = DataManager.getWarp(warpName, connection);
                    assert (warp != null);
                    EditingHandler.showEditWarpOptions(p, warp);
                    return;
                }
                switch (args[1].toLowerCase(Locale.ENGLISH)) {
                    case "location": {
                        this.editWarpLocation(p, warpName, connection);
                        return;
                    }
                    case "description": {
                        if (args.length >= 3) {
                            this.editWarpDescription(p, warpName, EditHomeCommand.buildDescription(args), connection);
                            return;
                        } else {
                            this.sendInvalidSyntaxMessage(p, "editwarp_description", "/editwarp <warp> description <new description>");
                            return;
                        }
                    }
                    case "rename": {
                        if (args.length >= 3) {
                            this.editWarpName(p, warpName, args[2], connection);
                            return;
                        } else {
                            this.sendInvalidSyntaxMessage(p, "editwarp_rename", "/editwarp <warp> rename <new name>");
                            return;
                        }
                    }
                    default: {
                        this.sendInvalidSyntaxMessage(p, command.getName(), command.getUsage());
                        return;
                    }
                }
            }
            catch (SQLException e) {
                plugin.getLogger().log(Level.SEVERE, "An SQL exception occurred editing a warp.");
            }
        });
        return true;
    }

    private void editWarpLocation(Player p, String warpName, Connection connection) throws SQLException {
        Location newLocation = p.getLocation();
        TeleportationPoint newTeleportLocation = new TeleportationPoint(newLocation, HuskHomes.getSettings().getServerID());
        Warp locationMovedWarp = DataManager.getWarp(warpName, connection);
        assert (locationMovedWarp != null);
        PlayerRelocateWarpEvent relocateWarpEvent = new PlayerRelocateWarpEvent(p, locationMovedWarp, newTeleportLocation);
        Bukkit.getScheduler().runTask((Plugin)plugin, () -> {
            Bukkit.getPluginManager().callEvent((Event)relocateWarpEvent);
            if (relocateWarpEvent.isCancelled()) {
                return;
            }
            try (Connection connection1 = HuskHomes.getConnection();){
                if (HuskHomes.getSettings().doMapIntegration() && HuskHomes.getSettings().showWarpsOnMap()) {
                    HuskHomes.getMap().removeWarpMarker(warpName);
                }
                DataManager.updateWarpLocation(warpName, newLocation, connection1);
                MessageManager.sendMessage(p, "edit_warp_update_location", warpName);
                locationMovedWarp.setLocation(newLocation, HuskHomes.getSettings().getServerID());
                if (HuskHomes.getSettings().doMapIntegration() && HuskHomes.getSettings().showWarpsOnMap()) {
                    HuskHomes.getMap().addWarpMarker(locationMovedWarp);
                }
            }
            catch (SQLException e) {
                plugin.getLogger().log(Level.SEVERE, "An SQL exception occurred updating a warp's location.");
            }
        });
    }

    private void editWarpDescription(Player p, String warpName, String newDescriptionString, Connection connection) throws SQLException {
        Warp descriptionChangedWarp = DataManager.getWarp(warpName, connection);
        assert (descriptionChangedWarp != null);
        PlayerChangeWarpDescriptionEvent changeWarpDescriptionEvent = new PlayerChangeWarpDescriptionEvent(p, descriptionChangedWarp, newDescriptionString);
        Bukkit.getScheduler().runTask((Plugin)plugin, () -> {
            Bukkit.getPluginManager().callEvent((Event)changeWarpDescriptionEvent);
            if (changeWarpDescriptionEvent.isCancelled()) {
                return;
            }
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
                try (Connection connection1 = HuskHomes.getConnection();){
                    if (newDescriptionString.length() > 255) {
                        MessageManager.sendMessage(p, "error_edit_warp_description_length");
                        return;
                    }
                    if (!HuskHomes.getSettings().doUnicodeInDescriptions() && !RegexUtil.DESCRIPTION_PATTERN.matcher(newDescriptionString).matches()) {
                        MessageManager.sendMessage(p, "error_edit_warp_description_characters");
                        return;
                    }
                    if (HuskHomes.getSettings().doMapIntegration() && HuskHomes.getSettings().showWarpsOnMap()) {
                        HuskHomes.getMap().removeWarpMarker(warpName);
                    }
                    DataManager.updateWarpDescription(warpName, newDescriptionString, connection1);
                    descriptionChangedWarp.setDescription(newDescriptionString);
                    if (HuskHomes.getSettings().doMapIntegration() && HuskHomes.getSettings().showWarpsOnMap()) {
                        HuskHomes.getMap().addWarpMarker(descriptionChangedWarp);
                    }
                    MessageManager.sendMessage(p, "edit_warp_update_description", warpName, MineDown.escape(newDescriptionString).replace("]", "\\]").replace("[", "\\[").replace("(", "\\(").replace(")", "\\)"));
                }
                catch (SQLException e) {
                    plugin.getLogger().log(Level.SEVERE, "An SQL exception occurred editing a warp's description.");
                }
            });
        });
    }

    private void editWarpName(Player p, String warpName, String newName, Connection connection) throws SQLException {
        if (newName.length() > 16) {
            MessageManager.sendMessage(p, "error_set_warp_invalid_length");
            return;
        }
        if (!RegexUtil.NAME_PATTERN.matcher(newName).matches()) {
            MessageManager.sendMessage(p, "error_set_warp_invalid_characters");
            return;
        }
        if (DataManager.warpExists(newName, connection)) {
            MessageManager.sendMessage(p, "error_set_warp_name_taken");
            return;
        }
        Warp renamedWarp = DataManager.getWarp(warpName, connection);
        assert (renamedWarp != null);
        PlayerRenameWarpEvent renameWarpEvent = new PlayerRenameWarpEvent(p, renamedWarp, newName);
        Bukkit.getScheduler().runTask((Plugin)plugin, () -> {
            Bukkit.getPluginManager().callEvent((Event)renameWarpEvent);
            if (renameWarpEvent.isCancelled()) {
                return;
            }
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
                try (Connection connection1 = HuskHomes.getConnection();){
                    if (HuskHomes.getSettings().doMapIntegration() && HuskHomes.getSettings().showWarpsOnMap()) {
                        HuskHomes.getMap().removeWarpMarker(warpName);
                    }
                    DataManager.updateWarpName(warpName, newName, connection1);
                    WarpCommand.Tab.updateWarpsTabCache();
                    renamedWarp.setName(newName);
                    if (HuskHomes.getSettings().doMapIntegration() && HuskHomes.getSettings().showWarpsOnMap()) {
                        HuskHomes.getMap().addWarpMarker(renamedWarp);
                    }
                    MessageManager.sendMessage(p, "edit_warp_update_name", warpName, newName);
                }
                catch (SQLException e) {
                    plugin.getLogger().log(Level.SEVERE, "An SQL exception occurred editing a warp name.");
                }
            });
        });
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
        Player p = (Player)sender;
        if (!p.hasPermission("huskhomes.editwarp")) {
            return Collections.emptyList();
        }
        if (args.length == 1) {
            ArrayList<String> tabCompletions = new ArrayList<String>();
            StringUtil.copyPartialMatches((String)args[0], WarpCommand.Tab.warpsTabCache, tabCompletions);
            Collections.sort(tabCompletions);
            return tabCompletions;
        }
        if (args.length == 2) {
            ArrayList<String> editWarpOptions = new ArrayList<String>();
            editWarpOptions.add("rename");
            editWarpOptions.add("location");
            editWarpOptions.add("description");
            return editWarpOptions;
        }
        return Collections.emptyList();
    }
}

