/*
 * Decompiled with CFR 0.152.
 */
package me.william278.huskhomes2.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import me.william278.huskhomes2.HuskHomes;
import me.william278.huskhomes2.commands.CommandBase;
import me.william278.huskhomes2.libraries.minedown.MineDown;
import me.william278.huskhomes2.migrators.EssentialsMigrator;
import me.william278.huskhomes2.util.ChatList;
import me.william278.huskhomes2.util.MessageManager;
import me.william278.huskhomes2.util.UpdateChecker;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;

public class HuskHomesCommand
extends CommandBase
implements TabCompleter {
    private static final HuskHomes plugin = HuskHomes.getInstance();
    private static final StringBuilder PLUGIN_INFORMATION = new StringBuilder().append("[HuskHomes](#00fb9a bold) [| Version ").append(plugin.getDescription().getVersion()).append("](#00fb9a)\n").append("[").append(plugin.getDescription().getDescription()).append("](gray)\n").append("[\u2022 Author:](white) [William278](gray show_text=&7Click to visit website open_url=https://william278.net)\n").append("[\u2022 Contributors:](white) [imDaniX](gray show_text=&7Code, refactoring), [Log1x](gray show_text=&7Code)\n").append("[\u2022 Translators:](white) [SnivyJ](gray show_text=&7Simplified Chinese, zh-cn), [TonyPak](gray show_text=&7Traditional Chinese, zh-tw), [Villag3r_](gray show_text=&7Italian, it-it), [ReferTV](gray show_text=&7Polish, pl) \n").append("[\u2022 Help Wiki:](white) [[Link]](#00fb9a show_text=&7Click to open link open_url=https://github.com/WiIIiam278/HuskHomes2/wiki/)\n").append("[\u2022 Report Issues:](white) [[Link]](#00fb9a show_text=&7Click to open link open_url=https://github.com/WiIIiam278/HuskHomes2/issues)\n").append("[\u2022 Support Discord:](white) [[Link]](#00fb9a show_text=&7Click to join open_url=https://discord.gg/tVYhJfyDWG)");
    static final String[] COMMAND_TAB_ARGS = new String[]{"help", "about", "update", "reload"};

    public static void showHelpMenu(Player player, int pageNumber) {
        ArrayList<String> commandDisplay = new ArrayList<String>();
        for (String commandName : plugin.getDescription().getCommands().keySet()) {
            String permission;
            PluginCommand command = plugin.getCommand(commandName);
            if (command == null || commandName.equals("huskhomes") && HuskHomes.getSettings().hideHuskHomesCommandFromHelpMenu() || HuskHomes.getSettings().hideCommandsFromHelpMenuWithoutPermission() && (permission = command.getPermission()) != null && !player.hasPermission(permission)) continue;
            commandDisplay.add(MessageManager.getRawMessage("command_list_item", commandName, command.getUsage(), command.getDescription()));
        }
        MessageManager.sendMessage(player, "command_list_header");
        ChatList helpList = new ChatList(commandDisplay, 10, "/huskhomes help", "\n", false);
        if (helpList.doesNotContainPage(pageNumber)) {
            MessageManager.sendMessage(player, "error_invalid_page_number");
            return;
        }
        helpList.sendPage(player, pageNumber);
    }

    @Override
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (args.length == 0) {
            if (sender instanceof Player) {
                HuskHomesCommand.showHelpMenu((Player)sender, 1);
            } else {
                sender.spigot().sendMessage(new MineDown(PLUGIN_INFORMATION.toString()).toComponent());
            }
            return true;
        }
        switch (args[0]) {
            case "about": 
            case "info": {
                if (sender.hasPermission("huskhomes.about")) {
                    sender.spigot().sendMessage(new MineDown(PLUGIN_INFORMATION.toString()).toComponent());
                } else {
                    sender.spigot().sendMessage(new MineDown(MessageManager.getRawMessage("error_no_permission")).toComponent());
                }
                return true;
            }
            case "update": {
                if (sender.hasPermission("huskhomes.version_checker")) {
                    sender.spigot().sendMessage(new MineDown("[Checking for HuskHomes updates...](gray)").toComponent());
                    Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
                        UpdateChecker updateChecker = new UpdateChecker(plugin);
                        if (updateChecker.isUpToDate()) {
                            sender.spigot().sendMessage(new MineDown("[HuskHomes](#00fb9a bold) [| HuskHomes is up-to-date, running Version " + updateChecker.getLatestVersion() + "](#00fb9a)").toComponent());
                        } else {
                            sender.spigot().sendMessage(new MineDown("[HuskHomes](#00fb9a bold) [| A new update is available:](#00fb9a) [HuskHomes " + updateChecker.getLatestVersion() + "](#00fb9a bold)\n[\u2022](white) [Currently running:](#00fb9a) [Version " + updateChecker.getCurrentVersion() + "](gray)\n[\u2022](white) [Download links:](#00fb9a) [[\u23e9 Spigot]](gray open_url=https://www.spigotmc.org/resources/huskhomes.83767/updates) [\u2022](#262626) [[\u23e9 Polymart]](gray open_url=https://polymart.org/resource/huskhomes.284/updates)").toComponent());
                        }
                    });
                } else {
                    sender.spigot().sendMessage(new MineDown(MessageManager.getRawMessage("error_no_permission")).toComponent());
                }
                return true;
            }
            case "reload": {
                CommandSender commandSender = sender;
                if (commandSender instanceof Player) {
                    Player p = (Player)commandSender;
                    if (p.hasPermission("huskhomes.reload")) {
                        HuskHomes.getSettings().reload();
                        MessageManager.loadMessages(HuskHomes.getSettings().getLanguage());
                        sender.spigot().sendMessage(new MineDown("[HuskHomes](#00fb9a bold) &#00fb9a&| Reloaded config & message files.").toComponent());
                    } else {
                        MessageManager.sendMessage(p, "error_no_permission");
                    }
                    return true;
                }
                HuskHomes.getSettings().reload();
                MessageManager.loadMessages(HuskHomes.getSettings().getLanguage());
                plugin.getLogger().info("Reloaded config and message files.");
                return true;
            }
            case "migrate": {
                CommandSender commandSender = sender;
                if (commandSender instanceof Player) {
                    Player p = (Player)commandSender;
                    MessageManager.sendMessage(p, "error_console_only");
                    return true;
                }
                if (args.length >= 2) {
                    if (args[1].equalsIgnoreCase("essentialsx")) {
                        sender.spigot().sendMessage(new MineDown("[HuskHomes](#00fb9a bold) &#00fb9a&| Starting data migration from EssentialsX...").toComponent());
                        if (args.length == 4) {
                            EssentialsMigrator.migrate(args[2].toLowerCase(), args[3].toLowerCase());
                        } else if (args.length == 2) {
                            EssentialsMigrator.migrate();
                        } else {
                            sender.sendMessage(ChatColor.RED + "Invalid syntax! Usage: /huskhomes migrate essentialsX [world filter] [target server]");
                        }
                    } else {
                        sender.sendMessage(ChatColor.RED + "Invalid argument! Usage: /huskhomes migrate essentialsX");
                    }
                } else {
                    sender.sendMessage(ChatColor.RED + "Invalid syntax! Usage: /huskhomes migrate essentialsX");
                }
                return true;
            }
            case "help": {
                CommandSender commandSender = sender;
                if (commandSender instanceof Player) {
                    Player p = (Player)commandSender;
                    if (args.length == 2) {
                        try {
                            int pageNo = Integer.parseInt(args[1]);
                            HuskHomesCommand.showHelpMenu(p, pageNo);
                        }
                        catch (NumberFormatException ex) {
                            MessageManager.sendMessage(p, "error_invalid_page_number");
                        }
                    } else {
                        HuskHomesCommand.showHelpMenu(p, 1);
                    }
                }
                return true;
            }
        }
        if (sender instanceof Player) {
            HuskHomesCommand.showHelpMenu((Player)sender, 1);
        } else {
            sender.spigot().sendMessage(new MineDown(PLUGIN_INFORMATION.toString()).toComponent());
        }
        return true;
    }

    @Override
    protected boolean onCommand(Player player, Command command, String label, String[] args) {
        return true;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, Command command, @NotNull String alias, String[] args) {
        Player p = (Player)sender;
        if (command.getPermission() != null && !p.hasPermission(command.getPermission())) {
            return Collections.emptyList();
        }
        if (args.length == 1) {
            ArrayList<String> tabCompletions = new ArrayList<String>();
            StringUtil.copyPartialMatches((String)args[0], Arrays.asList(COMMAND_TAB_ARGS), tabCompletions);
            Collections.sort(tabCompletions);
            return tabCompletions;
        }
        return Collections.emptyList();
    }
}

