/*
 * Decompiled with CFR 0.152.
 */
package me.william278.huskhomes2.commands;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import me.william278.huskhomes2.HuskHomes;
import me.william278.huskhomes2.commands.CommandBase;
import me.william278.huskhomes2.data.DataManager;
import me.william278.huskhomes2.libraries.minedown.MineDown;
import me.william278.huskhomes2.teleport.points.Home;
import me.william278.huskhomes2.util.ChatList;
import me.william278.huskhomes2.util.MessageManager;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PublicHomeListCommand
extends CommandBase {
    private static final HuskHomes plugin = HuskHomes.getInstance();

    @Override
    protected boolean onCommand(Player p, Command command, String label, String[] args) {
        int pageNo = 1;
        if (args.length == 1) {
            try {
                pageNo = Integer.parseInt(args[0]);
            }
            catch (Exception e) {
                return false;
            }
        }
        PublicHomeListCommand.displayPublicHomeList(p, pageNo);
        return true;
    }

    public static void displayPublicHomeList(Player player, int pageNumber) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            try (Connection connection = HuskHomes.getConnection();){
                ChatList homeChatList;
                List<Home> homes = DataManager.getPublicHomes(connection);
                if (homes.isEmpty()) {
                    MessageManager.sendMessage(player, "error_no_public_homes_set");
                    return;
                }
                ArrayList<String> publicHomeList = new ArrayList<String>();
                for (Home home : homes) {
                    publicHomeList.add(MessageManager.getRawMessage("public_home_list_item", home.getName(), home.getOwnerUsername(), MineDown.escape(home.getDescription()).replace("]", "\\]").replace("[", "\\[").replace("(", "\\(").replace(")", "\\)")));
                }
                int itemsPerPage = HuskHomes.getSettings().getPublicHomesPerPage();
                int homeLowerBound = (pageNumber - 1) * itemsPerPage;
                int homeUpperBound = pageNumber * itemsPerPage;
                if (homeUpperBound > publicHomeList.size()) {
                    homeUpperBound = publicHomeList.size();
                }
                if ((homeChatList = new ChatList(publicHomeList, itemsPerPage, "/huskhomes:publichomelist", MessageManager.getRawMessage("list_item_divider"), true)).doesNotContainPage(pageNumber)) {
                    MessageManager.sendMessage(player, "error_invalid_page_number");
                    return;
                }
                MessageManager.sendMessage(player, "public_home_list_page_top", Integer.toString(homeLowerBound + 1), Integer.toString(homeUpperBound), Integer.toString(publicHomeList.size()));
                homeChatList.sendPage(player, pageNumber);
            }
            catch (SQLException e) {
                plugin.getLogger().log(Level.SEVERE, "An SQL exception occurred!", e);
            }
        });
    }
}

