/*
 * Decompiled with CFR 0.152.
 */
package me.william278.huskhomes2.commands;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import me.william278.huskhomes2.HuskHomes;
import me.william278.huskhomes2.commands.CommandBase;
import me.william278.huskhomes2.data.DataManager;
import me.william278.huskhomes2.teleport.TeleportManager;
import me.william278.huskhomes2.util.MessageManager;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class SpawnCommand
extends CommandBase {
    private static final HuskHomes plugin = HuskHomes.getInstance();

    @Override
    protected boolean onCommand(Player p, Command command, String label, String[] args) {
        if (HuskHomes.getSettings().doSpawnCommand()) {
            String spawnWarpName = HuskHomes.getSettings().getSpawnWarpName();
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
                try (Connection connection = HuskHomes.getConnection();){
                    if (HuskHomes.getSettings().doCrossServerSpawn()) {
                        if (DataManager.warpExists(spawnWarpName, connection)) {
                            TeleportManager.queueTimedTeleport(p, DataManager.getWarp(spawnWarpName, connection));
                        } else {
                            MessageManager.sendMessage(p, "error_spawn_undefined");
                        }
                        return;
                    }
                    if (TeleportManager.getSpawnLocation() != null) {
                        TeleportManager.queueTimedTeleport(p, TeleportManager.getSpawnLocation());
                    } else {
                        MessageManager.sendMessage(p, "error_spawn_undefined");
                    }
                }
                catch (SQLException e) {
                    plugin.getLogger().log(Level.SEVERE, "An exception occurred returning back to spawn");
                }
            });
        } else {
            MessageManager.sendMessage(p, "error_command_disabled");
        }
        return true;
    }
}

