/*
 * Decompiled with CFR 0.152.
 */
package me.william278.huskhomes2.commands;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import me.william278.huskhomes2.HuskHomes;
import me.william278.huskhomes2.commands.CommandBase;
import me.william278.huskhomes2.commands.WarpListCommand;
import me.william278.huskhomes2.data.DataManager;
import me.william278.huskhomes2.teleport.TeleportManager;
import me.william278.huskhomes2.teleport.points.Warp;
import me.william278.huskhomes2.util.MessageManager;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;

public class WarpCommand
extends CommandBase {
    private static final HuskHomes plugin = HuskHomes.getInstance();

    @Override
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        CommandSender commandSender = sender;
        if (!(commandSender instanceof Player)) {
            WarpCommand.handleConsoleWarp(sender, args);
            return true;
        }
        Player p = (Player)commandSender;
        if (!HuskHomes.getSettings().doWarpCommand()) {
            MessageManager.sendMessage(p, "error_command_disabled");
            return true;
        }
        if (args.length == 1) {
            String warpName = args[0];
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
                try (Connection connection = HuskHomes.getConnection();){
                    if (DataManager.warpExists(warpName, connection)) {
                        if (Warp.getWarpCanUse(p, warpName)) {
                            Warp warp = DataManager.getWarp(warpName, connection);
                            TeleportManager.queueTimedTeleport(p, warp);
                        } else {
                            MessageManager.sendMessage(p, "error_permission_restricted_warp", warpName);
                        }
                    } else {
                        MessageManager.sendMessage(p, "error_warp_invalid", warpName);
                    }
                }
                catch (SQLException e) {
                    plugin.getLogger().log(Level.SEVERE, "An SQL exception occurred using /tphere");
                }
            });
        } else {
            WarpListCommand.displayWarpList(p, 1);
        }
        return true;
    }

    @Override
    protected boolean onCommand(Player player, Command command, String label, String[] args) {
        return true;
    }

    public static void handleConsoleWarp(CommandSender sender, String[] args) {
        if (args.length == 2) {
            String warpName = args[0];
            Player targetPlayer = Bukkit.getPlayer((String)args[1]);
            if (targetPlayer != null) {
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
                    try (Connection connection = HuskHomes.getConnection();){
                        if (DataManager.warpExists(warpName, connection)) {
                            Warp warp = DataManager.getWarp(warpName, connection);
                            Bukkit.getScheduler().runTask((Plugin)plugin, () -> {
                                TeleportManager.teleportPlayer(targetPlayer, warp);
                                sender.sendMessage("Successfully warped player!");
                                MessageManager.sendMessage(targetPlayer, "teleporting_complete_console", warpName);
                            });
                        } else {
                            sender.sendMessage("Error: Invalid warp \"" + warpName + "\" specified");
                        }
                    }
                    catch (SQLException e) {
                        plugin.getLogger().log(Level.SEVERE, "An SQL exception occurred using /tphere");
                    }
                });
            } else {
                sender.sendMessage("Error: Invalid player specified (are they online?)");
            }
        } else {
            sender.sendMessage("Console Warp Usage: /warp <warp> <player>");
        }
    }

    public static class Tab
    implements TabCompleter {
        public static final Set<String> warpsTabCache = new HashSet<String>();

        public static void updateWarpsTabCache() {
            warpsTabCache.clear();
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
                try (Connection connection = HuskHomes.getConnection();){
                    for (Warp warp : DataManager.getWarps(connection)) {
                        warpsTabCache.add(warp.getName());
                    }
                }
                catch (SQLException e) {
                    plugin.getLogger().log(Level.WARNING, "An SQL exception occurred updating the warp cache", e);
                }
            });
        }

        public List<String> onTabComplete(CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
            if (!sender.hasPermission("huskhomes.warp")) {
                return Collections.emptyList();
            }
            if (args.length == 1) {
                ArrayList<String> tabCompletions = new ArrayList<String>();
                HashSet<String> cachedWarps = new HashSet<String>(warpsTabCache);
                CommandSender commandSender = sender;
                if (commandSender instanceof Player) {
                    Player player = (Player)commandSender;
                    if (HuskHomes.getSettings().doPermissionRestrictedWarps() && HuskHomes.getSettings().doHideRestrictedWarps()) {
                        cachedWarps.clear();
                        for (String warp : warpsTabCache) {
                            if (!Warp.getWarpCanUse(player, warp)) continue;
                            cachedWarps.add(warp);
                        }
                    }
                }
                StringUtil.copyPartialMatches((String)args[0], cachedWarps, tabCompletions);
                Collections.sort(tabCompletions);
                return tabCompletions;
            }
            return Collections.emptyList();
        }
    }
}

