/*
 * Decompiled with CFR 0.152.
 */
package me.william278.huskhomes2.commands;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import me.william278.huskhomes2.HuskHomes;
import me.william278.huskhomes2.commands.CommandBase;
import me.william278.huskhomes2.data.DataManager;
import me.william278.huskhomes2.libraries.minedown.MineDown;
import me.william278.huskhomes2.teleport.points.Warp;
import me.william278.huskhomes2.util.ChatList;
import me.william278.huskhomes2.util.MessageManager;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class WarpListCommand
extends CommandBase {
    private static final HuskHomes plugin = HuskHomes.getInstance();

    @Override
    protected boolean onCommand(Player p, Command command, String label, String[] args) {
        int pageNo = 1;
        if (args.length == 1) {
            try {
                pageNo = Integer.parseInt(args[0]);
            }
            catch (Exception e) {
                return false;
            }
        }
        WarpListCommand.displayWarpList(p, pageNo);
        return true;
    }

    public static void displayWarpList(Player player, int pageNumber) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            try (Connection connection = HuskHomes.getConnection();){
                ChatList homeChatList;
                List<Warp> warps = DataManager.getWarps(connection);
                ArrayList<String> warpList = new ArrayList<String>();
                for (Warp warp : warps) {
                    if (HuskHomes.getSettings().doPermissionRestrictedWarps() && HuskHomes.getSettings().doHideRestrictedWarps() && !warp.canUse(player)) continue;
                    warpList.add(MessageManager.getRawMessage("warp_list_item", warp.getName(), MineDown.escape(warp.getDescription()).replace("]", "\\]").replace("[", "\\[").replace("(", "\\(").replace(")", "\\)")));
                }
                if (warpList.isEmpty()) {
                    MessageManager.sendMessage(player, "error_no_warps_set");
                    return;
                }
                int itemsPerPage = HuskHomes.getSettings().getWarpsPerPage();
                int homeLowerBound = (pageNumber - 1) * itemsPerPage;
                int warpsUpperBound = pageNumber * itemsPerPage;
                if (warpsUpperBound > warpList.size()) {
                    warpsUpperBound = warpList.size();
                }
                if ((homeChatList = new ChatList(warpList, itemsPerPage, "/huskhomes:warplist", MessageManager.getRawMessage("list_item_divider"), true)).doesNotContainPage(pageNumber)) {
                    MessageManager.sendMessage(player, "error_invalid_page_number");
                    return;
                }
                MessageManager.sendMessage(player, "warp_list_page_top", Integer.toString(homeLowerBound + 1), Integer.toString(warpsUpperBound), Integer.toString(warpList.size()));
                homeChatList.sendPage(player, pageNumber);
            }
            catch (SQLException e) {
                plugin.getLogger().log(Level.SEVERE, "An SQL exception occurred!", e);
            }
        });
    }
}

