/*
 * Decompiled with CFR 0.152.
 */
package me.william278.huskhomes2.data;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import me.william278.huskhomes2.HuskHomes;
import me.william278.huskhomes2.teleport.points.Home;
import me.william278.huskhomes2.teleport.points.TeleportationPoint;
import me.william278.huskhomes2.teleport.points.Warp;
import me.william278.huskhomes2.util.MessageManager;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class DataManager {
    private static Integer getPlayerId(UUID uuid, Connection connection) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement("SELECT * FROM " + HuskHomes.getSettings().getPlayerDataTable() + " WHERE `user_uuid`=?;");){
            statement.setString(1, uuid.toString());
            ResultSet resultSet = statement.executeQuery();
            if (resultSet.next()) {
                int playerID = resultSet.getInt("player_id");
                statement.close();
                Integer n = playerID;
                return n;
            }
        }
        return null;
    }

    public static Integer getPlayerId(String playerUsername, Connection connection) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement("SELECT * FROM " + HuskHomes.getSettings().getPlayerDataTable() + " WHERE `username`=?;");){
            statement.setString(1, playerUsername);
            ResultSet resultSet = statement.executeQuery();
            if (resultSet.next()) {
                int playerID = resultSet.getInt("player_id");
                statement.close();
                Integer n = playerID;
                return n;
            }
        }
        return null;
    }

    private static Integer getPlayerInteger(Integer playerID, String column, Connection connection) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement("SELECT * FROM " + HuskHomes.getSettings().getPlayerDataTable() + " WHERE `player_id`=?;");){
            statement.setInt(1, playerID);
            ResultSet resultSet = statement.executeQuery();
            if (resultSet.next()) {
                int playerInteger = resultSet.getInt(column);
                statement.close();
                Integer n = playerInteger;
                return n;
            }
        }
        return null;
    }

    private static Integer getPlayerInteger(Player p, String column, Connection connection) throws SQLException {
        return DataManager.getPlayerInteger(DataManager.getPlayerId(p.getUniqueId(), connection), column, connection);
    }

    private static String getPlayerString(Integer playerID, String column, Connection connection) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement("SELECT * FROM " + HuskHomes.getSettings().getPlayerDataTable() + " WHERE `player_id`=?;");){
            statement.setInt(1, playerID);
            ResultSet resultSet = statement.executeQuery();
            if (resultSet.next()) {
                String playerString = resultSet.getString(column);
                statement.close();
                String string = playerString;
                return string;
            }
        }
        return null;
    }

    public static Boolean isPlayerIgnoringRequests(UUID uuid, Connection connection) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement("SELECT * FROM " + HuskHomes.getSettings().getPlayerDataTable() + " WHERE `user_uuid`=?;");){
            statement.setString(1, uuid.toString());
            ResultSet resultSet = statement.executeQuery();
            if (resultSet.next()) {
                boolean isIgnoringRequests = resultSet.getBoolean("is_ignoring_requests");
                statement.close();
                Boolean bl = isIgnoringRequests;
                return bl;
            }
        }
        return null;
    }

    public static UUID getPlayerUUID(int playerID, Connection connection) throws SQLException {
        String uuidString = DataManager.getPlayerString(playerID, "user_uuid", connection);
        if (uuidString != null) {
            return UUID.fromString(uuidString);
        }
        return null;
    }

    public static String getPlayerUsername(int playerID, Connection connection) throws SQLException {
        return DataManager.getPlayerString(playerID, "username", connection);
    }

    public static int getPlayerHomeCount(Player p, Connection connection) throws SQLException {
        return DataManager.getPlayerHomes(p.getName(), connection).size();
    }

    public static void incrementPlayerHomeSlots(Player p, Connection connection) throws SQLException {
        DataManager.setPlayerHomeSlots(p.getUniqueId(), DataManager.getPlayerHomeSlots(p, connection) + 1, connection);
    }

    public static Integer getPlayerHomeSlots(Player p, Connection connection) throws SQLException {
        return DataManager.getPlayerInteger(p, "home_slots", connection);
    }

    public static Long getPlayerRtpCoolDown(Player p, Connection connection) throws SQLException {
        return (long)DataManager.getPlayerInteger(p, "rtp_cooldown", connection);
    }

    public static List<Home> getPlayerHomes(String playerName, Connection connection) throws SQLException {
        ArrayList<Home> playerHomes = new ArrayList<Home>();
        try (PreparedStatement statement = connection.prepareStatement("SELECT * FROM " + HuskHomes.getSettings().getHomesDataTable() + " WHERE `player_id`=(SELECT `player_id` FROM " + HuskHomes.getSettings().getPlayerDataTable() + " WHERE `username`=?);");){
            statement.setString(1, playerName);
            ResultSet resultSet = statement.executeQuery();
            while (resultSet.next()) {
                int locationID = resultSet.getInt("location_id");
                TeleportationPoint teleportationPoint = DataManager.getTeleportationPoint(locationID, connection);
                long epochTime = 0L;
                Timestamp timestamp = resultSet.getTimestamp("creation_time");
                if (timestamp != null) {
                    epochTime = timestamp.getTime();
                }
                playerHomes.add(new Home(teleportationPoint, playerName, DataManager.getPlayerUUID(resultSet.getInt("player_id"), connection), resultSet.getString("name"), resultSet.getString("description"), resultSet.getBoolean("public"), epochTime));
            }
        }
        return playerHomes;
    }

    public static List<Home> getPublicHomes(Connection connection) throws SQLException {
        ArrayList<Home> publicHomes = new ArrayList<Home>();
        try (PreparedStatement statement = connection.prepareStatement("SELECT * FROM " + HuskHomes.getSettings().getHomesDataTable() + " WHERE `public`;");){
            ResultSet resultSet = statement.executeQuery();
            while (resultSet.next()) {
                int playerID = resultSet.getInt("player_id");
                int locationID = resultSet.getInt("location_id");
                TeleportationPoint teleportationPoint = DataManager.getTeleportationPoint(locationID, connection);
                long epochTime = 0L;
                Timestamp timestamp = resultSet.getTimestamp("creation_time");
                if (timestamp != null) {
                    epochTime = timestamp.getTime();
                }
                publicHomes.add(new Home(teleportationPoint, DataManager.getPlayerUsername(playerID, connection), DataManager.getPlayerUUID(playerID, connection), resultSet.getString("name"), resultSet.getString("description"), true, epochTime));
            }
        }
        return publicHomes;
    }

    public static List<Warp> getWarps(Connection connection) throws SQLException {
        ArrayList<Warp> warps = new ArrayList<Warp>();
        try (PreparedStatement statement = connection.prepareStatement("SELECT * FROM " + HuskHomes.getSettings().getWarpsDataTable() + " ORDER BY `name` ASC;");){
            ResultSet resultSet = statement.executeQuery();
            if (resultSet != null) {
                while (resultSet.next()) {
                    int locationID = resultSet.getInt("location_id");
                    TeleportationPoint teleportationPoint = DataManager.getTeleportationPoint(locationID, connection);
                    long epochTime = 0L;
                    Timestamp timestamp = resultSet.getTimestamp("creation_time");
                    if (timestamp != null) {
                        epochTime = timestamp.getTime();
                    }
                    warps.add(new Warp(teleportationPoint, resultSet.getString("name"), resultSet.getString("description"), epochTime));
                }
            } else {
                Bukkit.getLogger().severe("Result set of warps returned null!");
            }
        }
        return warps;
    }

    public static Warp getWarp(String name, Connection connection) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement("SELECT * FROM " + HuskHomes.getSettings().getWarpsDataTable() + " WHERE `name`=?;");){
            statement.setString(1, name);
            ResultSet resultSet = statement.executeQuery();
            if (resultSet.next()) {
                int locationID = resultSet.getInt("location_id");
                TeleportationPoint teleportationPoint = DataManager.getTeleportationPoint(locationID, connection);
                long epochTime = 0L;
                Timestamp timestamp = resultSet.getTimestamp("creation_time");
                if (timestamp != null) {
                    epochTime = timestamp.getTime();
                }
                Warp warp = new Warp(teleportationPoint, resultSet.getString("name"), resultSet.getString("description"), epochTime);
                return warp;
            }
        }
        return null;
    }

    public static Integer getHomeLocationID(int ownerID, String homeName, Connection connection) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement("SELECT * FROM " + HuskHomes.getSettings().getHomesDataTable() + " WHERE `player_id`=? AND `name`=?;");){
            statement.setInt(1, ownerID);
            statement.setString(2, homeName);
            ResultSet resultSet = statement.executeQuery();
            if (resultSet != null) {
                if (resultSet.next()) {
                    int locationID = resultSet.getInt("location_id");
                    statement.close();
                    Integer n = locationID;
                    return n;
                }
            } else {
                Bukkit.getLogger().severe("Failed to obtain home teleportation location ID");
            }
        }
        return null;
    }

    public static void deleteHomeTeleportLocation(int ownerID, String homeName, Connection connection) throws SQLException {
        Integer locationID = DataManager.getHomeLocationID(ownerID, homeName, connection);
        if (locationID != null) {
            DataManager.deleteTeleportationPoint(locationID, connection);
        }
    }

    public static void updateHomeTeleportLocation(int ownerID, String homeName, TeleportationPoint teleportationPoint, Connection connection) throws SQLException {
        Integer oldLocationID = DataManager.getHomeLocationID(ownerID, homeName, connection);
        DataManager.setHomeTeleportPoint(homeName, ownerID, teleportationPoint, connection);
        if (oldLocationID != null) {
            DataManager.deleteTeleportationPoint(oldLocationID, connection);
        }
    }

    public static Integer getWarpLocationID(String warpName, Connection connection) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement("SELECT * FROM " + HuskHomes.getSettings().getWarpsDataTable() + " WHERE `name`=?;");){
            statement.setString(1, warpName);
            ResultSet resultSet = statement.executeQuery();
            if (resultSet != null && resultSet.next()) {
                int locationID = resultSet.getInt("location_id");
                statement.close();
                Integer n = locationID;
                return n;
            }
        }
        return null;
    }

    public static void deleteWarp(String warpName, Connection connection) throws SQLException {
        Integer warpLocationID = DataManager.getWarpLocationID(warpName, connection);
        if (warpLocationID != null) {
            DataManager.deleteTeleportationPoint(warpLocationID, connection);
            try (PreparedStatement statement = connection.prepareStatement("DELETE FROM " + HuskHomes.getSettings().getWarpsDataTable() + " WHERE `name`=?;");){
                statement.setString(1, warpName);
                statement.executeUpdate();
            }
        }
    }

    public static void deleteHome(String homeName, String ownerUsername, Connection connection) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement("DELETE FROM " + HuskHomes.getSettings().getHomesDataTable() + " WHERE `name`=? AND `player_id`=(SELECT `player_id` FROM " + HuskHomes.getSettings().getPlayerDataTable() + " WHERE `username`=?);");){
            statement.setString(1, homeName);
            statement.setString(2, ownerUsername);
            statement.executeUpdate();
        }
    }

    public static void addPlayer(Player p, Connection connection) throws SQLException {
        DataManager.addPlayer(p.getUniqueId(), p.getName(), connection);
    }

    public static void addPlayer(UUID playerUUID, String playerName, Connection connection) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement("INSERT INTO " + HuskHomes.getSettings().getPlayerDataTable() + " (user_uuid,username,home_slots,rtp_cooldown,is_teleporting) VALUES(?,?,?,0,?);");){
            statement.setString(1, playerUUID.toString());
            statement.setString(2, playerName);
            statement.setInt(3, HuskHomes.getSettings().getFreeHomeSlots());
            statement.setBoolean(4, false);
            statement.executeUpdate();
        }
    }

    public static void updatePlayerUsername(UUID uuid, String newName, Connection connection) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement("UPDATE " + HuskHomes.getSettings().getPlayerDataTable() + " SET `username`=? WHERE `user_uuid`=?;");){
            statement.setString(1, newName);
            statement.setString(2, uuid.toString());
            statement.executeUpdate();
        }
    }

    private static void setPlayerTeleportingData(UUID uuid, boolean value, Connection connection) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement("UPDATE " + HuskHomes.getSettings().getPlayerDataTable() + " SET `is_teleporting`=? WHERE `user_uuid`=?;");){
            statement.setBoolean(1, value);
            statement.setString(2, uuid.toString());
            statement.executeUpdate();
        }
    }

    private static void setPlayerIgnoringRequestsData(UUID uuid, boolean value, Connection connection) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement("UPDATE " + HuskHomes.getSettings().getPlayerDataTable() + " SET `is_ignoring_requests`=? WHERE `user_uuid`=?;");){
            statement.setBoolean(1, value);
            statement.setString(2, uuid.toString());
            statement.executeUpdate();
        }
    }

    public static void setPlayerHomeSlots(UUID uuid, int newValue, Connection connection) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement("UPDATE " + HuskHomes.getSettings().getPlayerDataTable() + " SET `home_slots`=? WHERE `user_uuid`=?;");){
            statement.setInt(1, newValue);
            statement.setString(2, uuid.toString());
            statement.executeUpdate();
        }
    }

    public static void setRtpCoolDown(UUID uuid, int newTime, Connection connection) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement("UPDATE " + HuskHomes.getSettings().getPlayerDataTable() + " SET `rtp_cooldown`=? WHERE `user_uuid`=?;");){
            statement.setInt(1, newTime);
            statement.setString(2, uuid.toString());
            statement.executeUpdate();
        }
    }

    public static void setHomePrivacy(String homeName, String ownerName, boolean isPublic, Connection connection) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement("UPDATE " + HuskHomes.getSettings().getHomesDataTable() + " SET `public`=? WHERE `name`=? AND `player_id`=(SELECT `player_id` FROM " + HuskHomes.getSettings().getPlayerDataTable() + " WHERE `username`=?);");){
            statement.setBoolean(1, isPublic);
            statement.setString(2, homeName);
            statement.setString(3, ownerName);
            statement.executeUpdate();
        }
    }

    public static void setWarpTeleportPoint(String warpName, TeleportationPoint point, Connection connection) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement("UPDATE " + HuskHomes.getSettings().getWarpsDataTable() + " SET `location_id`=? WHERE `name`=?;");){
            statement.setInt(1, DataManager.addTeleportationPoint(point, connection));
            statement.setString(2, warpName);
            statement.executeUpdate();
        }
    }

    public static void setHomeDescription(String homeName, String ownerName, String newDescription, Connection connection) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement("UPDATE " + HuskHomes.getSettings().getHomesDataTable() + " SET `description`=? WHERE `name`=? AND `player_id`=(SELECT `player_id` FROM " + HuskHomes.getSettings().getPlayerDataTable() + " WHERE `username`=?);");){
            statement.setString(1, newDescription);
            statement.setString(2, homeName);
            statement.setString(3, ownerName);
            statement.executeUpdate();
        }
    }

    public static void setWarpDescription(String warpName, String newDescription, Connection connection) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement("UPDATE " + HuskHomes.getSettings().getWarpsDataTable() + " SET `description`=? WHERE `name`=?;");){
            statement.setString(1, newDescription);
            statement.setString(2, warpName);
            statement.executeUpdate();
        }
    }

    public static void setHomeName(String oldHomeName, String ownerName, String newHomeName, Connection connection) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement("UPDATE " + HuskHomes.getSettings().getHomesDataTable() + " SET `name`=? WHERE `name`=? AND `player_id`=(SELECT `player_id` FROM " + HuskHomes.getSettings().getPlayerDataTable() + " WHERE `username`=?);");){
            statement.setString(1, newHomeName);
            statement.setString(2, oldHomeName);
            statement.setString(3, ownerName);
            statement.executeUpdate();
        }
    }

    public static void setWarpName(String oldWarpName, String newWarpName, Connection connection) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement("UPDATE " + HuskHomes.getSettings().getWarpsDataTable() + " SET `name`=? WHERE `name`=?;");){
            statement.setString(1, newWarpName);
            statement.setString(2, oldWarpName);
            statement.executeUpdate();
        }
    }

    public static void setTeleportationDestinationData(String username, TeleportationPoint point, Connection connection) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement("UPDATE " + HuskHomes.getSettings().getPlayerDataTable() + " SET `dest_location_id`=? WHERE `username`=?;");){
            statement.setInt(1, DataManager.addTeleportationPoint(point, connection));
            statement.setString(2, username);
            statement.executeUpdate();
        }
    }

    public static void updateWarpTeleportLocation(String warpName, TeleportationPoint teleportationPoint, Connection connection) throws SQLException {
        Integer oldLocationID = DataManager.getWarpLocationID(warpName, connection);
        DataManager.setWarpTeleportPoint(warpName, teleportationPoint, connection);
        if (oldLocationID != null) {
            DataManager.deleteTeleportationPoint(oldLocationID, connection);
        }
    }

    public static void updateHomePrivacy(String ownerName, String homeName, boolean isPublic, Connection connection) throws SQLException {
        DataManager.setHomePrivacy(homeName, ownerName, isPublic, connection);
    }

    public static void updateHomeName(String ownerName, String homeName, String newName, Connection connection) throws SQLException {
        DataManager.setHomeName(homeName, ownerName, newName, connection);
    }

    public static void updateHomeDescription(String ownerName, String homeName, String newDescription, Connection connection) throws SQLException {
        DataManager.setHomeDescription(homeName, ownerName, newDescription, connection);
    }

    public static void updateHomeLocation(String ownerName, String homeName, Location newLocation, Connection connection) throws SQLException {
        Integer playerID = DataManager.getPlayerId(ownerName, connection);
        if (playerID != null) {
            DataManager.updateHomeTeleportLocation(playerID, homeName, new TeleportationPoint(newLocation, HuskHomes.getSettings().getServerID()), connection);
        }
    }

    public static void updateWarpName(String warpName, String newName, Connection connection) throws SQLException {
        DataManager.setWarpName(warpName, newName, connection);
    }

    public static void updateWarpDescription(String warpName, String newDescription, Connection connection) throws SQLException {
        DataManager.setWarpDescription(warpName, newDescription, connection);
    }

    public static void updateWarpLocation(String warpName, Location newLocation, Connection connection) throws SQLException {
        DataManager.updateWarpTeleportLocation(warpName, new TeleportationPoint(newLocation, HuskHomes.getSettings().getServerID()), connection);
    }

    public static Home getHome(String ownerUsername, String homeName, Connection connection) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement("SELECT * FROM " + HuskHomes.getSettings().getHomesDataTable() + " WHERE `player_id`=(SELECT `player_id` FROM " + HuskHomes.getSettings().getPlayerDataTable() + " WHERE `username`=?) AND `name`=?;");){
            statement.setString(1, ownerUsername);
            statement.setString(2, homeName);
            ResultSet resultSet = statement.executeQuery();
            if (resultSet != null && resultSet.next()) {
                int locationID = resultSet.getInt("location_id");
                TeleportationPoint teleportationPoint = DataManager.getTeleportationPoint(locationID, connection);
                long epochTime = 0L;
                Timestamp timestamp = resultSet.getTimestamp("creation_time");
                if (timestamp != null) {
                    epochTime = timestamp.getTime();
                }
                Home home = new Home(teleportationPoint, ownerUsername, DataManager.getPlayerUUID(resultSet.getInt("player_id"), connection), resultSet.getString("name"), resultSet.getString("description"), resultSet.getBoolean("public"), epochTime);
                statement.close();
                Home home2 = home;
                return home2;
            }
        }
        return null;
    }

    public static boolean warpExists(String warpName, Connection connection) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement("SELECT * FROM " + HuskHomes.getSettings().getWarpsDataTable() + " WHERE `name`=?;");){
            statement.setString(1, warpName);
            ResultSet resultSet = statement.executeQuery();
            boolean warpExists = resultSet.next();
            statement.close();
            boolean bl = warpExists;
            return bl;
        }
    }

    public static Boolean homeExists(Player owner, String homeName, Connection connection) throws SQLException {
        return DataManager.homeExists(owner.getName(), homeName, connection);
    }

    public static Boolean homeExists(String ownerName, String homeName, Connection connection) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement("SELECT * FROM " + HuskHomes.getSettings().getHomesDataTable() + " WHERE `player_id`=(SELECT `player_id` FROM " + HuskHomes.getSettings().getPlayerDataTable() + " WHERE `username`=?) AND `name`=?;");){
            statement.setString(1, ownerName);
            statement.setString(2, homeName);
            ResultSet resultSet = statement.executeQuery();
            boolean homeExists = resultSet.next();
            statement.close();
            Boolean bl = homeExists;
            return bl;
        }
    }

    public static Boolean playerExists(Player player, Connection connection) throws SQLException {
        return DataManager.playerExists(player.getUniqueId(), connection);
    }

    public static Boolean playerExists(UUID playerUUID, Connection connection) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement("SELECT * FROM " + HuskHomes.getSettings().getPlayerDataTable() + " WHERE `user_uuid`=?;");){
            statement.setString(1, playerUUID.toString());
            ResultSet resultSet = statement.executeQuery();
            boolean exists = resultSet.next();
            statement.close();
            Boolean bl = exists;
            return bl;
        }
    }

    public static Boolean playerExists(String username, Connection connection) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement("SELECT * FROM " + HuskHomes.getSettings().getPlayerDataTable() + " WHERE `username`=?;");){
            statement.setString(1, username);
            ResultSet resultSet = statement.executeQuery();
            boolean exists = resultSet.next();
            statement.close();
            Boolean bl = exists;
            return bl;
        }
    }

    public static TeleportationPoint getTeleportationPoint(Integer locationID, Connection connection) throws SQLException, IllegalArgumentException {
        try (PreparedStatement statement = connection.prepareStatement("SELECT * FROM " + HuskHomes.getSettings().getLocationsDataTable() + " WHERE `location_id`=?;");){
            statement.setInt(1, locationID);
            ResultSet resultSet = statement.executeQuery();
            if (resultSet.next()) {
                TeleportationPoint point = new TeleportationPoint(resultSet.getString("world"), resultSet.getDouble("x"), resultSet.getDouble("y"), resultSet.getDouble("z"), resultSet.getFloat("yaw"), resultSet.getFloat("pitch"), resultSet.getString("server"));
                statement.close();
                TeleportationPoint teleportationPoint = point;
                return teleportationPoint;
            }
            statement.close();
            throw new IllegalArgumentException("Could not return a teleportationPoint from the locations data table at (ID#" + locationID + ")");
        }
    }

    public static TeleportationPoint getPlayerDestination(Player p, Connection connection) throws SQLException {
        Integer locationID = DataManager.getPlayerInteger(p, "dest_location_id", connection);
        if (locationID != null) {
            return DataManager.getTeleportationPoint(locationID, connection);
        }
        return null;
    }

    public static TeleportationPoint getPlayerLastPosition(Player p, Connection connection) throws SQLException {
        Integer locationID = DataManager.getPlayerInteger(p, "last_location_id", connection);
        if (locationID != null) {
            return DataManager.getTeleportationPoint(locationID, connection);
        }
        return null;
    }

    public static TeleportationPoint getPlayerOfflinePosition(int playerID, Connection connection) throws SQLException {
        try {
            Integer locationID = DataManager.getPlayerInteger(playerID, "offline_location_id", connection);
            if (locationID != null) {
                return DataManager.getTeleportationPoint(locationID, connection);
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static Integer addTeleportationPoint(TeleportationPoint point, Connection connection) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement("INSERT INTO " + HuskHomes.getSettings().getLocationsDataTable() + " (world,server,x,y,z,yaw,pitch) VALUES(?,?,?,?,?,?,?);", 1);){
            statement.setString(1, point.getWorldName());
            statement.setString(2, point.getServer());
            statement.setDouble(3, point.getX());
            statement.setDouble(4, point.getY());
            statement.setDouble(5, point.getZ());
            statement.setFloat(6, point.getYaw());
            statement.setFloat(7, point.getPitch());
            statement.executeUpdate();
            ResultSet resultSet = statement.getGeneratedKeys();
            resultSet.next();
            int pointID = resultSet.getInt(1);
            statement.close();
            Integer n = pointID;
            return n;
        }
    }

    public static void setTeleportationOfflinePositionData(UUID uuid, TeleportationPoint point, Connection connection) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement("UPDATE " + HuskHomes.getSettings().getPlayerDataTable() + " SET `offline_location_id`=? WHERE `user_uuid`=?;");){
            statement.setInt(1, DataManager.addTeleportationPoint(point, connection));
            statement.setString(2, uuid.toString());
            statement.executeUpdate();
        }
    }

    public static void setPlayerOfflinePosition(UUID uuid, TeleportationPoint point, Connection connection) throws SQLException {
        DataManager.deletePlayerOfflinePosition(uuid, connection);
        DataManager.setTeleportationOfflinePositionData(uuid, point, connection);
    }

    public static void setTeleportationLastPositionData(UUID uuid, TeleportationPoint point, Connection connection) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement("UPDATE " + HuskHomes.getSettings().getPlayerDataTable() + " SET `last_location_id`=? WHERE `user_uuid`=?;");){
            statement.setInt(1, DataManager.addTeleportationPoint(point, connection));
            statement.setString(2, uuid.toString());
            statement.executeUpdate();
        }
    }

    public static void setPlayerDestinationLocation(String playerName, TeleportationPoint point, Connection connection) throws SQLException {
        DataManager.deletePlayerDestination(playerName, connection);
        DataManager.setTeleportationDestinationData(playerName, point, connection);
    }

    public static void setPlayerDestinationLocation(Player p, TeleportationPoint point, Connection connection) throws SQLException {
        DataManager.setPlayerDestinationLocation(p.getName(), point, connection);
    }

    public static void setPlayerIgnoringRequests(Player p, boolean ignoringRequests, Connection connection) throws SQLException {
        DataManager.setPlayerIgnoringRequestsData(p.getUniqueId(), ignoringRequests, connection);
    }

    public static void updateRtpCoolDown(Player p, Connection connection) throws SQLException {
        long currentTime = Instant.now().getEpochSecond();
        int newCoolDownTime = (int)currentTime + 60 * HuskHomes.getSettings().getRtpCoolDown();
        DataManager.setRtpCoolDown(p.getUniqueId(), newCoolDownTime, connection);
    }

    public static void deletePlayerDestination(String playerName, Connection connection) throws SQLException {
        Integer destinationID = DataManager.getPlayerInteger(DataManager.getPlayerId(playerName, connection), "dest_location_id", connection);
        if (destinationID != null) {
            DataManager.deleteTeleportationPoint(destinationID, connection);
            DataManager.clearPlayerDestData(playerName, connection);
        }
    }

    public static void deleteTeleportationPoint(int locationID, Connection connection) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement("DELETE FROM " + HuskHomes.getSettings().getLocationsDataTable() + " WHERE `location_id`=?;");){
            statement.setInt(1, locationID);
            statement.executeUpdate();
        }
    }

    public static void deletePlayerLastPosition(UUID uuid, Connection connection) throws SQLException {
        Integer lastPositionID = DataManager.getPlayerInteger(DataManager.getPlayerId(uuid, connection), "last_location_id", connection);
        if (lastPositionID != null) {
            DataManager.deleteTeleportationPoint(lastPositionID, connection);
            DataManager.clearPlayerLastData(uuid, connection);
        }
    }

    public static void deletePlayerOfflinePosition(UUID uuid, Connection connection) throws SQLException {
        Integer offlineLocationId = DataManager.getPlayerInteger(DataManager.getPlayerId(uuid, connection), "offline_location_id", connection);
        if (offlineLocationId != null) {
            DataManager.deleteTeleportationPoint(offlineLocationId, connection);
            DataManager.clearPlayerOfflineData(uuid, connection);
        }
    }

    public static void setHomeTeleportPoint(String homeName, int ownerID, TeleportationPoint point, Connection connection) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement("UPDATE " + HuskHomes.getSettings().getHomesDataTable() + " SET `location_id`=? WHERE `name`=? AND `player_id`=?;");){
            statement.setInt(1, DataManager.addTeleportationPoint(point, connection));
            statement.setString(2, homeName);
            statement.setInt(3, ownerID);
            statement.executeUpdate();
        }
    }

    public static void clearPlayerDestData(String playerName, Connection connection) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement("UPDATE " + HuskHomes.getSettings().getPlayerDataTable() + " SET `dest_location_id`=NULL WHERE `username`=?;");){
            statement.setString(1, playerName);
            statement.executeUpdate();
        }
    }

    public static void clearPlayerLastData(UUID uuid, Connection connection) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement("UPDATE " + HuskHomes.getSettings().getPlayerDataTable() + " SET `last_location_id`=NULL WHERE `user_uuid`=?;");){
            statement.setString(1, uuid.toString());
            statement.executeUpdate();
        }
    }

    public static void clearPlayerOfflineData(UUID uuid, Connection connection) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement("UPDATE " + HuskHomes.getSettings().getPlayerDataTable() + " SET `offline_location_id`=NULL WHERE `user_uuid`=?;");){
            statement.setString(1, uuid.toString());
            statement.executeUpdate();
        }
    }

    public static void addWarp(Warp warp, Connection connection) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement("INSERT INTO " + HuskHomes.getSettings().getWarpsDataTable() + " (location_id,name,description,creation_time) VALUES(?,?,?,?);");){
            statement.setInt(1, DataManager.addTeleportationPoint(warp, connection));
            statement.setString(2, warp.getName());
            statement.setString(3, warp.getDescription());
            statement.setTimestamp(4, new Timestamp(warp.getCreationTime()));
            statement.executeUpdate();
        }
    }

    public static void addHome(Home home, UUID playerUUID, Connection connection) throws SQLException {
        Integer playerID = DataManager.getPlayerId(playerUUID, connection);
        if (playerID != null) {
            try (PreparedStatement statement = connection.prepareStatement("INSERT INTO " + HuskHomes.getSettings().getHomesDataTable() + " (player_id,location_id,name,description,public,creation_time) VALUES(?,?,?,?,?,?);");){
                statement.setInt(1, playerID);
                statement.setInt(2, DataManager.addTeleportationPoint(home, connection));
                statement.setString(3, home.getName());
                statement.setString(4, home.getDescription());
                statement.setBoolean(5, home.isPublic());
                statement.setTimestamp(6, new Timestamp(home.getCreationTime()));
                statement.executeUpdate();
            }
        }
    }

    public static void addHome(Home home, Player p, Connection connection) throws SQLException {
        DataManager.addHome(home, p.getUniqueId(), connection);
    }

    public static void deleteHome(Player p, String homeName, Connection connection) throws SQLException {
        DataManager.deleteHome(p, p.getName(), homeName, connection);
    }

    public static void deleteHome(Player deleter, String ownerName, String homeName, Connection connection) throws SQLException {
        if (!DataManager.homeExists(ownerName, homeName, connection).booleanValue()) {
            MessageManager.sendMessage(deleter, "error_invalid_home");
            return;
        }
        Integer playerID = DataManager.getPlayerId(ownerName, connection);
        if (playerID != null) {
            DataManager.deleteHomeTeleportLocation(playerID, homeName, connection);
            DataManager.deleteHome(homeName, ownerName, connection);
        } else {
            MessageManager.sendMessage(deleter, "error_invalid_player");
        }
    }

    public static void createPlayer(Player p, Connection connection) throws SQLException {
        DataManager.addPlayer(p, connection);
    }

    public static void createPlayer(UUID playerUUID, String playerUsername, Connection connection) throws SQLException {
        DataManager.addPlayer(playerUUID, playerUsername, connection);
    }

    public static void checkPlayerNameChange(Player p, Connection connection) throws SQLException {
        Integer playerID = DataManager.getPlayerId(p.getUniqueId(), connection);
        if (playerID != null && !DataManager.getPlayerUsername(playerID, connection).equals(p.getName())) {
            DataManager.updatePlayerUsername(p.getUniqueId(), p.getName(), connection);
        }
    }
}

