/*
 * Decompiled with CFR 0.152.
 */
package me.william278.huskhomes2.data.message;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.StringJoiner;
import java.util.logging.Level;
import me.william278.huskhomes2.HuskHomes;
import me.william278.huskhomes2.data.DataManager;
import me.william278.huskhomes2.data.message.Message;
import me.william278.huskhomes2.data.message.pluginmessage.PluginMessage;
import me.william278.huskhomes2.data.message.redis.RedisMessage;
import me.william278.huskhomes2.integrations.VanishChecker;
import me.william278.huskhomes2.teleport.TeleportManager;
import me.william278.huskhomes2.teleport.TeleportRequest;
import me.william278.huskhomes2.teleport.TeleportRequestHandler;
import me.william278.huskhomes2.teleport.points.TeleportationPoint;
import me.william278.huskhomes2.util.MessageManager;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class CrossServerMessageHandler {
    private static final HuskHomes plugin = HuskHomes.getInstance();

    public static void handlePluginMessage(Message receivedMessage, Player recipient) {
        switch (receivedMessage.getMessageType()) {
            case SET_TP_DESTINATION: {
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
                    try (Connection connection = HuskHomes.getConnection();){
                        DataManager.setPlayerDestinationLocation(receivedMessage.getMessageData(), new TeleportationPoint(recipient.getLocation(), HuskHomes.getSettings().getServerID()), connection);
                        CrossServerMessageHandler.getMessage(receivedMessage.getMessageData(), Message.MessageType.CONFIRM_DESTINATION_SET, "confirmed").send(recipient);
                    }
                    catch (SQLException e) {
                        plugin.getLogger().log(Level.SEVERE, "An SQL exception occurred responding to a plugin message teleport destination update");
                    }
                });
                break;
            }
            case CONFIRM_DESTINATION_SET: {
                if (!receivedMessage.getMessageData().equals("confirmed")) break;
                TeleportManager.teleportPlayer(recipient);
                break;
            }
            case TPA_REQUEST: {
                if (VanishChecker.isVanished(recipient) || HuskHomes.isIgnoringTeleportRequests(recipient.getUniqueId())) break;
                if (TeleportRequestHandler.isDuplicateRequest(receivedMessage.getMessageData(), recipient)) {
                    CrossServerMessageHandler.getMessage(receivedMessage.getMessageData(), Message.MessageType.TPA_REQUEST_ANSWER, recipient.getName(), String.valueOf(false)).send(recipient);
                    return;
                }
                if (TeleportRequestHandler.callRequestSendEvent(receivedMessage.getMessageData(), recipient.getName(), TeleportRequest.RequestType.TPA).isCancelled()) {
                    return;
                }
                TeleportRequestHandler.teleportRequests.get(recipient).put(receivedMessage.getMessageData(), new TeleportRequest(receivedMessage.getMessageData(), TeleportRequest.RequestType.TPA));
                MessageManager.sendMessage(recipient, "tpa_request_ask", receivedMessage.getMessageData());
                MessageManager.sendMessage(recipient, "teleport_request_options", receivedMessage.getMessageData());
                CrossServerMessageHandler.getMessage(receivedMessage.getMessageData(), Message.MessageType.TPA_REQUEST_ANSWER, recipient.getName(), String.valueOf(true)).send(recipient);
                break;
            }
            case TPA_HERE_REQUEST: {
                if (VanishChecker.isVanished(recipient) || HuskHomes.isIgnoringTeleportRequests(recipient.getUniqueId())) break;
                if (TeleportRequestHandler.isDuplicateRequest(receivedMessage.getMessageData(), recipient)) {
                    CrossServerMessageHandler.getMessage(receivedMessage.getMessageData(), Message.MessageType.TPA_HERE_REQUEST_ANSWER, recipient.getName(), String.valueOf(false)).send(recipient);
                    return;
                }
                if (TeleportRequestHandler.callRequestSendEvent(receivedMessage.getMessageData(), recipient.getName(), TeleportRequest.RequestType.TPA_HERE).isCancelled()) {
                    return;
                }
                TeleportRequestHandler.teleportRequests.get(recipient).put(receivedMessage.getMessageData(), new TeleportRequest(receivedMessage.getMessageData(), TeleportRequest.RequestType.TPA_HERE));
                MessageManager.sendMessage(recipient, "tpahere_request_ask", receivedMessage.getMessageData());
                MessageManager.sendMessage(recipient, "teleport_request_options", receivedMessage.getMessageData());
                CrossServerMessageHandler.getMessage(receivedMessage.getMessageData(), Message.MessageType.TPA_HERE_REQUEST_ANSWER, recipient.getName(), String.valueOf(true)).send(recipient);
                break;
            }
            case TPA_REQUEST_ANSWER: {
                String targetPlayerName = receivedMessage.getMessageDataItems()[0];
                boolean tpaSent = Boolean.parseBoolean(receivedMessage.getMessageDataItems()[1]);
                if (tpaSent) {
                    MessageManager.sendMessage(recipient, "tpa_request_sent", targetPlayerName);
                    break;
                }
                MessageManager.sendMessage(recipient, "error_tpa_duplicate_request", targetPlayerName);
                break;
            }
            case TPA_HERE_REQUEST_ANSWER: {
                String targetPlayerName = receivedMessage.getMessageDataItems()[0];
                boolean tpaSent = Boolean.parseBoolean(receivedMessage.getMessageDataItems()[1]);
                if (tpaSent) {
                    MessageManager.sendMessage(recipient, "tpahere_request_sent", targetPlayerName);
                    break;
                }
                MessageManager.sendMessage(recipient, "error_tpahere_duplicate_request", targetPlayerName);
                break;
            }
            case TPA_REQUEST_REPLY: {
                String tpaReplierName = receivedMessage.getMessageDataItems()[0];
                boolean tpaAccepted = Boolean.parseBoolean(receivedMessage.getMessageDataItems()[1]);
                if (tpaAccepted) {
                    if (TeleportRequestHandler.callRequestAcceptEvent(tpaReplierName, recipient.getName(), TeleportRequest.RequestType.TPA).isCancelled()) {
                        return;
                    }
                    MessageManager.sendMessage(recipient, "tpa_has_accepted", tpaReplierName);
                    Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> TeleportManager.queueTimedTeleport(recipient, tpaReplierName));
                    break;
                }
                MessageManager.sendMessage(recipient, "tpa_has_declined", tpaReplierName);
                break;
            }
            case TPA_HERE_REQUEST_REPLY: {
                String tpaHereReplierName = receivedMessage.getMessageDataItems()[0];
                boolean tpaHereAccepted = Boolean.parseBoolean(receivedMessage.getMessageDataItems()[1]);
                if (tpaHereAccepted) {
                    MessageManager.sendMessage(recipient, "tpa_has_accepted", tpaHereReplierName);
                    break;
                }
                MessageManager.sendMessage(recipient, "tpa_has_declined", tpaHereReplierName);
                break;
            }
            case TELEPORT_TO_ME: {
                TeleportManager.teleportPlayer(recipient, receivedMessage.getMessageData());
                break;
            }
            case UPDATE_PLAYER_LIST: {
                String senderServer = receivedMessage.getMessageDataItems()[0];
                String[] returningPlayers = receivedMessage.getMessageDataItems().length > 1 ? receivedMessage.getMessageDataItems()[1].split("\u00a3") : new String[]{};
                HuskHomes.getPlayerList().addPlayers(senderServer, returningPlayers);
                break;
            }
            default: {
                HuskHomes.getInstance().getLogger().log(Level.WARNING, "Received a HuskHomes plugin message with an unrecognised type. Is your version of HuskHomes up to date?");
            }
        }
    }

    public static Message getPlayerListMessage() {
        StringJoiner playerList = new StringJoiner("\u00a3");
        for (Player p : Bukkit.getOnlinePlayers()) {
            playerList.add(p.getName() + "|" + VanishChecker.isVanished(p));
        }
        return CrossServerMessageHandler.getMessage(Message.MessageType.UPDATE_PLAYER_LIST, HuskHomes.getSettings().getServerID(), playerList.toString());
    }

    public static Message getMessage(String targetPlayerName, Message.MessageType pluginMessageType, String ... messageData) {
        return switch (HuskHomes.getSettings().getMessengerType().toLowerCase()) {
            case "pluginmessage" -> new PluginMessage(targetPlayerName, pluginMessageType, messageData);
            case "redis" -> new RedisMessage(targetPlayerName, pluginMessageType, messageData);
            default -> null;
        };
    }

    public static Message getMessage(Message.MessageType pluginMessageType, String ... messageData) {
        return switch (HuskHomes.getSettings().getMessengerType().toLowerCase()) {
            case "pluginmessage" -> new PluginMessage(pluginMessageType, messageData);
            case "redis" -> new RedisMessage(pluginMessageType, messageData);
            default -> null;
        };
    }
}

