/*
 * Decompiled with CFR 0.152.
 */
package me.william278.huskhomes2.data.message.pluginmessage;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import me.william278.huskhomes2.HuskHomes;
import me.william278.huskhomes2.data.message.Message;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PluginMessage
extends Message {
    private static final HuskHomes plugin = HuskHomes.getInstance();

    public PluginMessage(String targetPlayerName, Message.MessageType pluginMessageType, String ... messageData) {
        super(targetPlayerName, pluginMessageType, messageData);
    }

    public PluginMessage(Message.MessageType pluginMessageType, String ... messageData) {
        super(pluginMessageType, messageData);
    }

    public PluginMessage(int clusterID, String targetPlayerName, String pluginMessageType, String ... messageData) {
        super(clusterID, targetPlayerName, pluginMessageType, messageData);
    }

    @Override
    public void send(Player sender) {
        Bukkit.getScheduler().runTask((Plugin)plugin, () -> {
            ByteArrayDataOutput out = ByteStreams.newDataOutput();
            out.writeUTF("ForwardToPlayer");
            out.writeUTF(this.getTargetPlayerName());
            out.writeUTF("HuskHomes:" + this.getClusterId() + ":" + this.getPluginMessageString(this.getMessageType()));
            ByteArrayOutputStream messageBytes = new ByteArrayOutputStream();
            DataOutputStream messageOut = new DataOutputStream(messageBytes);
            try {
                messageOut.writeUTF(this.getMessageData());
            }
            catch (IOException e) {
                plugin.getLogger().warning("An error occurred trying to send a plugin message (" + e.getCause() + ")");
                e.printStackTrace();
            }
            out.writeShort(messageBytes.toByteArray().length);
            out.write(messageBytes.toByteArray());
            sender.sendPluginMessage((Plugin)plugin, "BungeeCord", out.toByteArray());
        });
    }

    @Override
    public void sendToAllServers(Player sender) {
        this.sendToServer(sender, "ALL");
    }

    @Override
    public void sendToServer(Player sender, String server) {
        if (sender == null && !plugin.getServer().getOnlinePlayers().isEmpty()) {
            sender = (Player)plugin.getServer().getOnlinePlayers().iterator().next();
        }
        if (sender == null) {
            plugin.getLogger().warning("Unable to send " + this.getMessageType() + " to " + server + " as no player was online! Data: " + this.getMessageData());
            return;
        }
        Player finalSender = sender;
        Bukkit.getScheduler().runTask((Plugin)plugin, () -> {
            ByteArrayDataOutput out = ByteStreams.newDataOutput();
            out.writeUTF("Forward");
            out.writeUTF(server);
            out.writeUTF("HuskHomes:" + this.getClusterId() + ":" + this.getPluginMessageString(this.getMessageType()));
            ByteArrayOutputStream messageBytes = new ByteArrayOutputStream();
            DataOutputStream messageOut = new DataOutputStream(messageBytes);
            try {
                messageOut.writeUTF(this.getMessageData());
            }
            catch (IOException e) {
                plugin.getLogger().warning("An error occurred trying to send a plugin message to a server (" + e.getCause() + ")");
                e.printStackTrace();
            }
            out.writeShort(messageBytes.toByteArray().length);
            out.write(messageBytes.toByteArray());
            finalSender.sendPluginMessage((Plugin)plugin, "BungeeCord", out.toByteArray());
        });
    }
}

