/*
 * Decompiled with CFR 0.152.
 */
package me.william278.huskhomes2.data.message.redis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import me.william278.huskhomes2.HuskHomes;
import me.william278.huskhomes2.data.message.CrossServerMessageHandler;
import me.william278.huskhomes2.data.message.Message;
import me.william278.huskhomes2.data.message.redis.RedisMessage;
import me.william278.huskhomes2.integrations.ConnectorPluginIntegration;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class RedisReceiver {
    private static final HuskHomes plugin = HuskHomes.getInstance();
    public static final String REDIS_CHANNEL = "HuskHomes";

    private static Player getRandomReceiver() {
        ArrayList players = new ArrayList(Bukkit.getOnlinePlayers());
        if (players.isEmpty()) {
            return null;
        }
        Collections.shuffle(players);
        return (Player)players.get(0);
    }

    public static void listen() {
        ConnectorPluginIntegration.listenForMessage(REDIS_CHANNEL, message -> {
            int clusterID;
            String[] splitMessage = message.split("\u00a3", 2);
            String messageHeader = splitMessage[0];
            try {
                clusterID = Integer.parseInt(messageHeader.split(":")[0]);
            }
            catch (Exception e) {
                HuskHomes.getInstance().getLogger().warning("Received a Redis message on the HuskHomes channel with an invalid server Cluster ID! \nPlease ensure that the cluster ID is set to a valid integer on all servers.");
                return;
            }
            if (HuskHomes.getSettings().getClusterId() != clusterID) {
                return;
            }
            Message.MessageType messageType = Message.MessageType.valueOf(messageHeader.split(":")[1].toUpperCase(Locale.ENGLISH));
            String target = messageHeader.split(":")[2];
            plugin.getServer().getScheduler().runTask((Plugin)plugin, () -> {
                Player receiver = Bukkit.getPlayerExact((String)target);
                if (target.equalsIgnoreCase("-all-")) {
                    receiver = RedisReceiver.getRandomReceiver();
                } else if (target.contains("server-")) {
                    if (target.split("-")[1].equalsIgnoreCase(HuskHomes.getSettings().getServerID())) {
                        receiver = RedisReceiver.getRandomReceiver();
                    } else {
                        return;
                    }
                }
                if (messageType.requiresPlayer() && (receiver == null || !receiver.isOnline())) {
                    return;
                }
                String messageData = splitMessage[1];
                CrossServerMessageHandler.handlePluginMessage(new RedisMessage(clusterID, receiver != null ? receiver.getName() : null, messageType, messageData), receiver);
            });
        });
    }
}

