/*
 * Decompiled with CFR 0.152.
 */
package me.william278.huskhomes2.integrations;

import me.william278.huskhomes2.HuskHomes;
import me.william278.huskhomes2.api.events.PlayerTeleportRequestAcceptEvent;
import me.william278.huskhomes2.api.events.PlayerTeleportRequestSendEvent;
import me.william278.huskhomes2.util.MessageManager;
import nl.marido.deluxecombat.api.DeluxeCombatAPI;
import nl.marido.deluxecombat.hooks.template.CombatHook;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class DeluxeCombatIntegration
extends CombatHook
implements Listener {
    private final DeluxeCombatAPI api = new DeluxeCombatAPI();
    private final HuskHomes plugin;

    public DeluxeCombatIntegration(HuskHomes plugin) {
        super(plugin.getName(), plugin.getDescription().getVersion());
        this.plugin = plugin;
        this.register();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler(ignoreCancelled=true)
    public void onTeleportRequestSend(PlayerTeleportRequestSendEvent event) {
        event.setCancelled(this.handleRequest("send", event.getSender(), event.getRecipient()));
    }

    @EventHandler(ignoreCancelled=true)
    public void onTeleportRequestAccept(PlayerTeleportRequestAcceptEvent event) {
        event.setCancelled(this.handleRequest("accept", event.getSender(), event.getRecipient()));
    }

    private boolean handleRequest(String type, String senderName, String recipientName) {
        Player sender = this.plugin.getServer().getPlayer(senderName);
        if (sender != null && this.api.isInCombat(sender)) {
            MessageManager.sendMessage(sender, "error_request_" + type + "_in_pvp");
            return true;
        }
        Player receiver = this.plugin.getServer().getPlayer(recipientName);
        if (receiver != null && this.api.isInCombat(receiver)) {
            if (sender != null) {
                MessageManager.sendMessage(sender, "error_request_" + type + "_other_in_pvp");
            }
            return true;
        }
        return false;
    }

    public boolean canCombat(Player p1, Player p2) {
        return !HuskHomes.isTeleporting(p1.getUniqueId()) && !HuskHomes.isTeleporting(p2.getUniqueId());
    }

    public boolean canBeTagged(Player p1, Player p2) {
        return this.canCombat(p1, p2);
    }

    public boolean hasDamagedPlayers(Player p) {
        return this.api.isInCombat(p);
    }
}

