/*
 * Decompiled with CFR 0.152.
 */
package me.william278.huskhomes2.integrations.map;

import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Set;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import me.william278.huskhomes2.HuskHomes;
import me.william278.huskhomes2.data.DataManager;
import me.william278.huskhomes2.integrations.map.Map;
import me.william278.huskhomes2.teleport.points.Home;
import me.william278.huskhomes2.teleport.points.Warp;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.dynmap.DynmapAPI;
import org.dynmap.markers.Marker;
import org.dynmap.markers.MarkerIcon;
import org.dynmap.markers.MarkerSet;

public class DynMap
extends Map {
    private static Plugin dynMap;
    private static final HuskHomes plugin;
    private static final double MARKER_ICON_SCALE = 0.5;

    private InputStream getScaledMarkerIconStream(BufferedImage image) {
        try {
            BufferedImage scaledImage = new BufferedImage(16, 16, 2);
            AffineTransform scaleInstance = AffineTransform.getScaleInstance(0.5, 0.5);
            AffineTransformOp scaleOp = new AffineTransformOp(scaleInstance, 1);
            scaleOp.filter(image, scaledImage);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)scaledImage, "png", outputStream);
            return new ByteArrayInputStream(outputStream.toByteArray());
        }
        catch (IOException e) {
            plugin.getLogger().log(Level.SEVERE, "An exception occurred converting marker icon image data!", e);
            return null;
        }
    }

    @Override
    public void removeWarpMarker(String warpName) {
        String markerId = this.getWarpMarkerName(warpName);
        DynmapAPI dynmapAPI = (DynmapAPI)dynMap;
        MarkerSet markerSet = dynmapAPI.getMarkerAPI().getMarkerSet("huskhomes.warps");
        for (Marker m : markerSet.getMarkers()) {
            if (!m.getMarkerID().equals(markerId)) continue;
            m.deleteMarker();
        }
    }

    @Override
    public void removePublicHomeMarker(String homeName, String ownerName) {
        String markerId = this.getPublicHomeMarkerName(ownerName, homeName);
        DynmapAPI dynmapAPI = (DynmapAPI)dynMap;
        MarkerSet markerSet = dynmapAPI.getMarkerAPI().getMarkerSet("huskhomes.public_homes");
        for (Marker m : markerSet.getMarkers()) {
            if (!m.getMarkerID().equals(markerId)) continue;
            m.deleteMarker();
        }
    }

    @Override
    public void addWarpMarker(Warp warp) {
        try {
            String markerId = this.getWarpMarkerName(warp.getName());
            DynmapAPI dynmapAPI = (DynmapAPI)dynMap;
            MarkerSet markerSet = dynmapAPI.getMarkerAPI().getMarkerSet("huskhomes.warps");
            Marker m = markerSet.createMarker(markerId, warp.getName(), warp.getWorldName(), warp.getX(), warp.getY(), warp.getZ(), dynmapAPI.getMarkerAPI().getMarkerIcon("warp"), false);
            m.setDescription(this.getWarpInfoMenu(warp));
        }
        catch (Exception e) {
            plugin.getLogger().severe("Error adding warp marker to the Dynamic Map (" + e.getCause() + ")");
            plugin.getLogger().warning("This may be because you reloaded the server instead of restarting!");
        }
    }

    @Override
    public void addPublicHomeMarker(Home home) {
        try {
            String markerId = this.getPublicHomeMarkerName(home.getOwnerUsername(), home.getName());
            DynmapAPI dynmapAPI = (DynmapAPI)dynMap;
            MarkerSet markerSet = dynmapAPI.getMarkerAPI().getMarkerSet("huskhomes.public_homes");
            Marker m = markerSet.createMarker(markerId, home.getName(), home.getWorldName(), home.getX(), home.getY(), home.getZ(), dynmapAPI.getMarkerAPI().getMarkerIcon("public_home"), false);
            m.setDescription(this.getPublicHomeInfoMenu(home));
        }
        catch (Exception e) {
            plugin.getLogger().severe("Error adding public home marker to the Dynamic Map (" + e.getCause() + ")");
            plugin.getLogger().warning("This may be because you reloaded the server instead of restarting!");
        }
    }

    @Override
    public void initialize() {
        dynMap = plugin.getServer().getPluginManager().getPlugin("dynmap");
        plugin.getLogger().info("Initializing Dynmap integration");
        DynmapAPI dynmapAPI = (DynmapAPI)dynMap;
        if (dynmapAPI == null) {
            return;
        }
        Set markerIconSet = dynmapAPI.getMarkerAPI().getMarkerIcons();
        for (MarkerIcon icon : markerIconSet) {
            if (!icon.getMarkerIconID().equals("warp") && !icon.getMarkerIconID().equalsIgnoreCase("public_home")) continue;
            dynmapAPI.getMarkerAPI().getMarkerIcons().remove(icon);
        }
        dynmapAPI.getMarkerAPI().createMarkerIcon("warp", "Warp", this.getScaledMarkerIconStream(this.getWarpIcon()));
        dynmapAPI.getMarkerAPI().createMarkerIcon("public_home", "Public Home", this.getScaledMarkerIconStream(this.getPublicHomeIcon()));
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            try (Connection connection = HuskHomes.getConnection();){
                if (HuskHomes.getSettings().showPublicHomesOnMap()) {
                    dynmapAPI.getMarkerAPI().createMarkerSet("huskhomes.public_homes", HuskHomes.getSettings().getMapPublicHomeMarkerSet(), dynmapAPI.getMarkerAPI().getMarkerIcons(), false);
                    for (Home home : DataManager.getPublicHomes(connection)) {
                        if (HuskHomes.getSettings().doBungee() && !home.getServer().equals(HuskHomes.getSettings().getServerID())) continue;
                        Bukkit.getScheduler().runTask((Plugin)plugin, () -> this.addPublicHomeMarker(home));
                    }
                }
                if (HuskHomes.getSettings().showWarpsOnMap()) {
                    dynmapAPI.getMarkerAPI().createMarkerSet("huskhomes.warps", HuskHomes.getSettings().getMapWarpMarkerSet(), dynmapAPI.getMarkerAPI().getMarkerIcons(), false);
                    for (Warp warp : DataManager.getWarps(connection)) {
                        if (HuskHomes.getSettings().doBungee() && !warp.getServer().equals(HuskHomes.getSettings().getServerID())) continue;
                        Bukkit.getScheduler().runTask((Plugin)plugin, () -> this.addWarpMarker(warp));
                    }
                }
            }
            catch (SQLException e) {
                plugin.getLogger().log(Level.WARNING, "An SQL exception occurred adding homes and warps to the DynMap", e);
            }
        });
    }

    static {
        plugin = HuskHomes.getInstance();
    }
}

