/*
 * Decompiled with CFR 0.152.
 */
package me.william278.huskhomes2.listeners;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.UUID;
import java.util.logging.Level;
import me.william278.huskhomes2.HuskHomes;
import me.william278.huskhomes2.api.HuskHomesAPI;
import me.william278.huskhomes2.commands.HomeCommand;
import me.william278.huskhomes2.data.DataManager;
import me.william278.huskhomes2.libraries.paperlib.PaperLib;
import me.william278.huskhomes2.teleport.TeleportManager;
import me.william278.huskhomes2.teleport.points.TeleportationPoint;
import me.william278.huskhomes2.util.MessageManager;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class PlayerListener
implements Listener {
    private static final HuskHomes plugin = HuskHomes.getInstance();

    @EventHandler
    public void onPlayerDie(PlayerDeathEvent e) {
        Player p = e.getEntity();
        if (p.hasPermission("huskhomes.back.death")) {
            TeleportationPoint lastLocation = new TeleportationPoint(p.getLocation(), HuskHomes.getSettings().getServerID());
            if (!HuskHomesAPI.getInstance().setPlayerLastPosition(p, lastLocation).isCancelled()) {
                MessageManager.sendMessage(p, "return_by_death");
            }
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent e) {
        Player p = e.getPlayer();
        try {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
                try (Connection connection = HuskHomes.getConnection();){
                    Boolean isIgnoringRequests;
                    if (!DataManager.playerExists(p, connection).booleanValue()) {
                        DataManager.createPlayer(p, connection);
                        if (TeleportManager.getSpawnLocation() != null) {
                            this.teleportToSpawn(p);
                            return;
                        }
                    } else {
                        DataManager.checkPlayerNameChange(p, connection);
                        HomeCommand.Tab.updatePlayerHomeCache(p);
                    }
                    if ((isIgnoringRequests = DataManager.isPlayerIgnoringRequests(p.getUniqueId(), connection)) != null && isIgnoringRequests.booleanValue()) {
                        HuskHomes.setIgnoringTeleportRequests(p.getUniqueId());
                        MessageManager.sendMessage(p, "tpignore_on_reminder");
                    }
                    if (HuskHomes.getSettings().doBungee()) {
                        if (HuskHomes.getSettings().doForceSpawnOnLogin()) {
                            this.teleportToSpawn(p);
                        }
                    } else if (HuskHomes.getSettings().doForceSpawnOnLogin() && TeleportManager.getSpawnLocation() != null) {
                        this.teleportToSpawn(p);
                    }
                }
                catch (SQLException sqlException) {
                    plugin.getLogger().log(Level.SEVERE, "An SQL error handling a joining player", sqlException);
                }
            });
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Bukkit.getScheduler().runTaskLater((Plugin)HuskHomes.getInstance(), () -> HuskHomes.getPlayerList().updateList(), 1L);
    }

    private void teleportToSpawn(Player player) {
        if (TeleportManager.getSpawnLocation() != null) {
            Bukkit.getScheduler().runTask((Plugin)plugin, () -> {
                if (!player.isEmpty()) {
                    player.eject();
                }
                PaperLib.teleportAsync((Entity)player, TeleportManager.getSpawnLocation().getLocation());
            });
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerQuit(PlayerQuitEvent e) {
        Player p = e.getPlayer();
        UUID uuid = p.getUniqueId();
        if (!HuskHomes.isTeleporting(uuid)) {
            TeleportationPoint logOutLocation = new TeleportationPoint(p.getLocation(), HuskHomes.getSettings().getServerID());
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
                try (Connection connection = HuskHomes.getConnection();){
                    DataManager.setPlayerOfflinePosition(uuid, logOutLocation, connection);
                }
                catch (SQLException ex) {
                    Bukkit.getLogger().severe("An SQL exception occurred in retrieving if a warp exists from the table.");
                }
            });
        } else {
            Bukkit.getScheduler().runTaskLater((Plugin)plugin, () -> {
                if (Bukkit.getPlayer((UUID)uuid) == null) {
                    HuskHomes.setNotTeleporting(uuid);
                }
            }, 1L);
        }
        Bukkit.getScheduler().runTaskLater((Plugin)HuskHomes.getInstance(), () -> HuskHomes.getPlayerList().updateList(), 1L);
    }
}

